/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.node;

import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.editor.enums.PackagePathType;
import com.ds.esd.plugins.api.APIFactory;
import com.ds.esd.plugins.api.node.APIPaths;
import com.ds.esd.tool.enums.FileImgCssType;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.module.EUPackage;
import com.ds.vfs.FileInfo;
import com.ds.vfs.FileVersion;
import com.ds.vfs.Folder;
import com.ds.web.APIConfig;
import java.util.ArrayList;
import java.util.List;

public class XUIFile
implements Comparable<XUIFile> {
    String name;
    String id;
    Integer type;
    String location;
    String className;
    String packageName;
    String imageClass;
    String projectName;
    String caption;
    String path;
    List<XUIFile> sub;
    public Boolean iniFold;

    public XUIFile(ProjectVersion version) {
        this.name = this.projectName = version.getProject().getProjectName();
        this.id = this.location = version.getPath();
        this.imageClass = "fa fa-cubes";
        this.type = 0;
        this.caption = this.name;
        this.iniFold = true;
        this.path = "/";
    }

    public XUIFile(EUPackage euPackage) {
        this.name = euPackage.getName();
        this.iniFold = true;
        this.location = euPackage.getPath();
        String curProjectPath = euPackage.getProjectVersion().getPath();
        if (curProjectPath != null && !curProjectPath.equals("") && this.location.startsWith(curProjectPath)) {
            this.location = this.location.substring(curProjectPath.length());
        }
        this.className = euPackage.getPackageName();
        this.packageName = euPackage.getPackageName();
        this.id = euPackage.getId();
        this.imageClass = euPackage.getImageClass();
        this.type = 1;
        this.caption = euPackage.getDesc();
        this.projectName = euPackage.getProjectVersion().getProject().getProjectName();
    }

    public XUIFile(EUModule module) {
        this.name = module.getName() + ".cls";
        this.iniFold = true;
        this.location = module.getPath();
        String curProjectPath = module.getProjectVersion().getPath();
        if (curProjectPath != null && !curProjectPath.equals("") && this.location.startsWith(curProjectPath)) {
            this.location = this.location.substring(curProjectPath.length());
        }
        this.className = module.getClassName();
        this.id = module.getPath();
        this.imageClass = "spafont spa-icon-page";
        this.type = 1;
        this.caption = this.className;
        String title = module.getComponent().getTitle();
        if (title != null && !title.equals("")) {
            this.caption = this.caption + "(" + title + ")";
        }
        this.projectName = module.getProjectVersion().getProjectName();
    }

    public XUIFile(FileVersion fileVersion, ProjectVersion version) {
        this.name = fileVersion.getFileName();
        this.location = fileVersion.getPath();
        if (version != null) {
            String curProjectPath = version.getPath();
            if (curProjectPath != null && !curProjectPath.equals("") && this.location.startsWith(curProjectPath)) {
                this.location = this.location.substring(curProjectPath.length());
            }
            this.projectName = version.getVersionName();
        }
        this.imageClass = this.imageClass;
        this.id = this.location;
        this.type = 1;
        this.caption = "#" + fileVersion.getIndex() + this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public XUIFile(Folder folder, ProjectVersion version) {
        this.iniFold = true;
        this.name = folder.getDescrition() == null ? folder.getName() : folder.getDescrition();
        String subpath = StringUtility.replace((String)folder.getPath(), (String)version.getPath(), (String)"/");
        try {
            APIPaths apiPaths = APIFactory.getInstance().getAPIPaths(subpath);
            if (apiPaths != null) {
                for (APIConfig config : apiPaths.getApiConfigs()) {
                    if (config.getChinaName() == null) continue;
                    this.name = config.getDesc() + "(" + config.getPackageName() + ")";
                    this.imageClass = apiPaths.getImageClass();
                }
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        this.id = this.location = folder.getPath();
        this.className = StringUtility.replace((String)this.location, (String)version.getPath(), (String)"");
        this.className = StringUtility.replace((String)this.className, (String)"/", (String)".");
        if (this.className.endsWith(".")) {
            this.className = this.className.substring(0, this.className.length() - 1);
        }
        if (this.location.endsWith(".")) {
            this.className = this.className.substring(1, this.className.length());
        }
        this.path = this.location;
        PackagePathType packagePathType = PackagePathType.equalsPath((String)subpath);
        if (packagePathType != null) {
            this.name = packagePathType.getDesc() + "(" + this.className + ")";
            this.imageClass = packagePathType.getImageClass();
            this.setIniFold(true);
            if (packagePathType.equals((Object)PackagePathType.App)) {
                List folders = folder.getChildrenList();
                List infos = folder.getFileList();
                this.setIniFold(false);
                this.sub = new ArrayList<XUIFile>();
                for (Folder cfolder : folders) {
                    this.sub.add(new XUIFile(cfolder, version));
                }
                for (FileInfo fileInfo : infos) {
                    if (!fileInfo.getName().endsWith(".cls")) {
                        this.sub.add(new XUIFile(fileInfo, version));
                        continue;
                    }
                    EUModule module = version.getModule(fileInfo.getPath());
                    if (module == null) continue;
                    this.sub.add(new XUIFile(module));
                }
            }
        } else if (!this.name.endsWith("(" + this.className + ")")) {
            this.name = this.name + "(" + this.className + ")";
        }
        this.type = 0;
        this.caption = this.name;
        if (version != null) {
            String curProjectPath = version.getPath();
            if (curProjectPath != null && !curProjectPath.equals("") && this.location.startsWith(curProjectPath)) {
                this.location = this.location.substring(curProjectPath.length());
            }
            this.projectName = version.getVersionName();
        }
    }

    public XUIFile(FileInfo fileInfo, ProjectVersion version) {
        this.name = fileInfo.getDescrition() == null ? fileInfo.getName() : fileInfo.getDescrition();
        this.location = fileInfo.getPath();
        int index = this.name.lastIndexOf(".");
        Object mimeType = null;
        if (index > 0) {
            String fileType = this.name.substring(index + 1).toLowerCase();
            this.imageClass = FileImgCssType.fromType((String)fileType).getImageClass();
        } else {
            this.imageClass = FileImgCssType.unkown.getImageClass();
        }
        this.id = this.location;
        this.type = 1;
        this.caption = this.name;
        if (version != null) {
            String curProjectPath = version.getPath();
            if (curProjectPath != null && !curProjectPath.equals("") && this.location.startsWith(curProjectPath)) {
                this.location = this.location.substring(curProjectPath.length());
            }
            this.projectName = version.getVersionName();
        }
    }

    public Boolean getIniFold() {
        return this.iniFold;
    }

    public void setIniFold(Boolean iniFold) {
        this.iniFold = iniFold;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<XUIFile> getSub() {
        return this.sub;
    }

    public void setSub(List<XUIFile> sub) {
        this.sub = sub;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    @Override
    public int compareTo(XUIFile o) {
        if (this.className != null && o.getClassName() != null) {
            return this.className.compareTo(o.getClassName());
        }
        if (this.caption != null && o.getCaption() != null) {
            return this.caption.compareTo(o.getCaption());
        }
        if (this.location != null && o.getLocation() != null) {
            return this.location.compareTo(o.getLocation());
        }
        return this.id.compareTo(o.getId());
    }
}

