/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.handler;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSException;
import com.ds.common.md5.MD5InputStream;
import com.ds.config.ErrorResultModel;
import com.ds.config.ResultModel;
import com.ds.esd.dsm.DSMFactory;
import com.ds.esd.dsm.enums.ThumbnailType;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.ResourceHandler;
import com.ds.server.httpproxy.handler.multipart.SimpleRequestContext;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;

public class ThumbnailUPLoadHandler
extends AbstractHandler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class.getName());
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String contentType;
        String resource = request.getPath();
        boolean ruleMatches = this.rule.matcher(resource).matches();
        if (!ruleMatches) {
            return false;
        }
        String mimeType = this.getMimeType(resource);
        if (mimeType != null) {
            response.setMimeType(mimeType);
        }
        if ((contentType = this.getContentType(request)) != null && contentType.indexOf("multipart/form-data") > -1) {
            return this.sendMultiparPostProxy(request, response);
        }
        return true;
    }

    public boolean sendMultiparPostProxy(HttpRequest request, HttpResponse response) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        SimpleRequestContext requestContext = new SimpleRequestContext(StandardCharsets.UTF_8, this.getContentType(request), (InputStream)new ByteArrayInputStream(request.getPostData()));
        PortletFileUpload fileUploadBase = new PortletFileUpload();
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileUploadBase.setFileItemFactory((FileItemFactory)fileItemFactory);
        fileUploadBase.setHeaderEncoding("ctvfs");
        ThumbnailType thumbnailType = null;
        List fileItems = null;
        try {
            fileItems = fileUploadBase.parseRequest((RequestContext)requestContext);
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        ResultModel result = new ResultModel();
        for (FileItem f : fileItems) {
            if (!f.isFormField() || f == null || f.get() == null || f.get().length <= 0) continue;
            params.put(f.getFieldName(), f.getString("utf-8"));
        }
        String thumbnailTypeStr = request.getParameter("thumbnailType");
        if (thumbnailTypeStr == null || thumbnailTypeStr.equals("")) {
            thumbnailTypeStr = (String)params.get("thumbnailType");
        }
        if (thumbnailTypeStr != null && !thumbnailTypeStr.equals("")) {
            thumbnailType = ThumbnailType.formType((String)thumbnailTypeStr);
        }
        for (FileItem f : fileItems) {
            if (f.isFormField()) continue;
            String viewInstId = null;
            if (thumbnailType != null) {
                viewInstId = (String)params.get(thumbnailType.getPkName());
            }
            String files_fullname = (String)params.get("files_fullname");
            try {
                if (thumbnailType != null && viewInstId != null) {
                    DSMFactory.getInstance().getTempManager().uploadThumbnail(new MD5InputStream(f.getInputStream()), files_fullname, viewInstId, thumbnailType);
                    continue;
                }
                result = new ErrorResultModel();
                ((ErrorResultModel)result).setErrdes("thumbnailType is null!");
            }
            catch (JDSException e) {
                result = new ErrorResultModel();
                ((ErrorResultModel)result).setErrdes(e.getMessage());
            }
        }
        response.sendJSONResponse(JSONObject.toJSONString((Object)result));
        return true;
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }

    public String getContentType(HttpRequest request) {
        String contentType = request.getRequestHeader("Content-Type");
        if (contentType == null) {
            contentType = request.getRequestHeader("Content-type");
        }
        return contentType;
    }
}

