/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin;

import com.ds.cluster.ServerNode;
import com.ds.common.JDSException;
import com.ds.common.database.metadata.ProviderConfig;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIProject;
import com.ds.esd.admin.plugins.fdt.node.UIDBConfigNode;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.editor.enums.CustomMenuType;
import com.ds.esd.editor.extmenu.PluginsFactory;
import com.ds.esd.plugins.api.enums.APIType;
import com.ds.esd.plugins.api.node.APIComponentNode;
import com.ds.esd.plugins.api.node.APIPaths;
import com.ds.esd.plugins.font.node.FontConfig;
import com.ds.esd.project.config.DataBaseConfig;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.esd.project.enums.ProjectResourceType;
import com.ds.esd.project.enums.ProjectRoleType;
import com.ds.esd.project.enums.ProjectTempType;
import com.ds.esd.project.enums.ProjectVersionStatus;
import com.ds.esd.project.temp.ProjectTemp;
import com.ds.esd.workspace.MySpace;
import com.ds.esd.workspace.MySpaceConfig;
import com.ds.server.JDSServer;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/"})
@MethodChinaName(cname="RAD\u5de5\u7a0b\u7ba1\u7406")
public class ProjectManager {
    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u5206\u7c7b")
    @RequestMapping(value={"getTempType"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ProjectTemp>> getTempType(String path, String pattern) {
        ListResultModel result = new ListResultModel();
        ArrayList<ProjectTemp> temps = new ArrayList<ProjectTemp>();
        for (ProjectTempType type : ProjectTempType.values()) {
            ProjectTemp temp = new ProjectTemp(type);
            temps.add(temp);
        }
        result.setData(temps);
        return result;
    }

    @RequestMapping(value={"projectManager"}, method={RequestMethod.GET})
    @MethodChinaName(cname="\u5de5\u7a0b\u7f16\u8f91")
    public ModelAndView projectManager(ModelAndView mv, HttpServletResponse response, @PathVariable String projectName) {
        mv.addObject("projectName", (Object)projectName);
        ArrayList modules = new ArrayList();
        ArrayList<FileInfo> cssFiles = new ArrayList<FileInfo>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            PluginsFactory.getInstance().getAllTopMenu(CustomMenuType.top);
            List fontNodes = version.getProject().getFonts();
            for (FontConfig fontNode : fontNodes) {
                Folder folder = this.getClient().getFolderByPath(new String[]{fontNode.getFile()});
                List fileInfos = folder.getFileListRecursively();
                for (FileInfo cssFile : fileInfos) {
                    if (!cssFile.getName().endsWith(".css") || cssFiles.contains(cssFile)) continue;
                    cssFiles.add(cssFile);
                }
            }
            mv.addObject("cssFiles", cssFiles);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        mv.setViewName("/projectManager");
        return mv;
    }

    @RequestMapping(value={"debug"}, method={RequestMethod.GET})
    @MethodChinaName(cname="\u8c03\u8bd5")
    public ModelAndView debug(ModelAndView mv, @PathVariable String projectName) {
        mv.addObject("projectName", (Object)projectName);
        ArrayList<FileInfo> cssFiles = new ArrayList<FileInfo>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            List fontNodes = version.getProject().getFonts();
            for (FontConfig fontNode : fontNodes) {
                Folder folder = this.getClient().getFolderByPath(new String[]{fontNode.getFile()});
                List fileInfos = folder.getFileListRecursively();
                for (FileInfo cssFile : fileInfos) {
                    if (!cssFile.getName().endsWith(".css") || cssFiles.contains(cssFile)) continue;
                    cssFiles.add(cssFile);
                }
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        mv.addObject("cssFiles", cssFiles);
        mv.setViewName("/projectDebug");
        return mv;
    }

    @MethodChinaName(cname="\u521b\u5efa\u5de5\u7a0b")
    @RequestMapping(value={"createProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createProject(String projectName, String desc, String tempName, String url) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            if (tempName != null && projectName.equals(tempName)) {
                projectName = projectName + "1";
            }
            Project project = this.getClient().cloneProject(projectName, desc, tempName, ProjectDefAccess.Public);
            if (url != null) {
                project.getConfig().setPublicServerUrl(url);
            }
            project.getConfig().addDevPersons(ProjectRoleType.own, this.getClient().getConnectInfo().getUserID());
            project.updateConfig(project.getConfig());
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u5de5\u7a0b")
    @RequestMapping(value={"updateProjectInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> updateProjectInfo(String projectName, String desc, String url, String indexPage) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().updateProjectInfo(projectName, desc);
            if (url != null || indexPage != null) {
                project.getConfig().setPublicServerUrl(url);
                project.getConfig().setIndex(indexPage);
                project.updateConfig(project.getConfig());
            }
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u8d44\u6e90\u5de5\u7a0b")
    @RequestMapping(value={"createResourceProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createResourceProject(String projectName, String desc, ProjectResourceType type) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().cloneResourceProject(projectName, desc, null, type);
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b")
    @RequestMapping(value={"getResouceProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getResouceProjectList(ProjectResourceType type) {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getResourceAllProject(type);
            result = PageUtil.getDefaultPageList((List)projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u6a21\u5757\u5de5\u7a0b")
    @RequestMapping(value={"createModuleComProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createModuleComProject(String projectName, String desc, String url) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().cloneProject(projectName, desc, null, ProjectDefAccess.Module);
            if (url != null) {
                project.getConfig().setPublicServerUrl(url);
                project.getConfig().addDevPersons(ProjectRoleType.own, this.getClient().getConnectInfo().getUserID());
                project.updateConfig(project.getConfig());
            }
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6a21\u5757\u5de5\u7a0b")
    @RequestMapping(value={"getModuleProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getModuleProjectList() {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Module);
            result = PageUtil.getDefaultPageList((List)projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u6a21\u677f\u5de5\u7a0b")
    @RequestMapping(value={"createExtComProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createExtComProject(String projectName, String desc, String url) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().cloneProject(projectName, desc, null, ProjectDefAccess.ExtCom);
            if (url != null) {
                project.getConfig().setPublicServerUrl(url);
                project.getConfig().addDevPersons(ProjectRoleType.own, this.getClient().getConnectInfo().getUserID());
                project.updateConfig(project.getConfig());
            }
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u901a\u7528\u6a21\u5757\u5de5\u7a0b")
    @RequestMapping(value={"createExtModuleProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createExtModuleProject(String projectName, String desc, String url) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().cloneProject(projectName, desc, null, ProjectDefAccess.Module);
            if (url != null) {
                project.getConfig().setPublicServerUrl(url);
                project.getConfig().addDevPersons(ProjectRoleType.own, this.getClient().getConnectInfo().getUserID());
                project.updateConfig(project.getConfig());
            }
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6a21\u677f\u5de5\u7a0b")
    @RequestMapping(value={"getExtComProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getExtComProjectList() {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.ExtCom);
            result = PageUtil.getDefaultPageList((List)projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6a21\u5757\u5de5\u7a0b")
    @RequestMapping(value={"getExtModuleProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getExtModuleProjectList() {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Module);
            result = PageUtil.getDefaultPageList((List)projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u7ec4\u4ef6\u5de5\u7a0b")
    @RequestMapping(value={"createComponentProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createComponentProject(String projectName, String desc, String url) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().cloneProject(projectName, desc, null, ProjectDefAccess.Component);
            if (url != null) {
                project.getConfig().setPublicServerUrl(url);
                project.getConfig().addDevPersons(ProjectRoleType.own, this.getClient().getConnectInfo().getUserID());
                project.updateConfig(project.getConfig());
            }
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u7ec4\u4ef6\u5de5\u7a0b")
    @RequestMapping(value={"getComponentProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getComponentProjectList() {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Component);
            result = PageUtil.getDefaultPageList((List)projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u4fe1\u606f")
    @RequestMapping(value={"getProjectInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> getProjectInfo(String projectName) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u521b\u5efa\u6a21\u677f\u5de5\u7a0b")
    @RequestMapping(value={"createTempProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createTempProject(String projectName, String desc) {
        ResultModel result = new ResultModel();
        ArrayList modules = new ArrayList();
        try {
            Project project = this.getClient().createProject(projectName, desc, ProjectDefAccess.Templat);
            result.setData((Object)new XUIProject(project));
        }
        catch (JDSException e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b")
    @RequestMapping(value={"getTempProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getTempProjectList(ProjectTempType type) {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = new ArrayList();
            if (type == null) {
                type = ProjectTempType.Custom;
            }
            switch (type) {
                case Custom: {
                    projects = this.getClient().getAllProject(ProjectDefAccess.Templat);
                    break;
                }
                case OA: {
                    projects = this.getClient().getAllProject(ProjectDefAccess.Templat);
                    break;
                }
                case IOT: {
                    break;
                }
                case Clone: {
                    projects = this.getClient().getAllProject(ProjectDefAccess.Public);
                    break;
                }
                default: {
                    projects = this.getClient().getAllProject(ProjectDefAccess.Templat);
                }
            }
            result = PageUtil.getDefaultPageList(projects, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b")
    @RequestMapping(value={"getProjectList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getProjectList(String pattern) {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Public);
            ArrayList<Project> projectList = new ArrayList<Project>();
            for (Project project : projects) {
                if (pattern != null && !pattern.equals("")) {
                    Pattern p = Pattern.compile(pattern);
                    Matcher matcher = p.matcher(project.getProjectName());
                    Matcher descmatcher = p.matcher(project.getDesc());
                    if (!matcher.find() && !descmatcher.find()) continue;
                    projectList.add(project);
                    continue;
                }
                projectList.add(project);
            }
            result = PageUtil.getDefaultPageList(projectList, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u5206\u652f\u6570\u636e")
    @RequestMapping(value={"getProjectVersionList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIProject>> getProjectVersionList(String projectName, String pattern) {
        ListResultModel result = new ListResultModel();
        ArrayList modules = new ArrayList();
        Project project = null;
        try {
            project = this.getClient().getProjectByName(projectName);
            ArrayList<ProjectVersion> versions = new ArrayList<ProjectVersion>();
            for (ProjectVersion version : project.getAllEIProjectVersion()) {
                if (pattern != null && !pattern.equals("")) {
                    Pattern p = Pattern.compile(pattern);
                    Matcher matcher = p.matcher(version.getVersionName());
                    Matcher descmatcher = p.matcher(version.getDesc());
                    if (!matcher.find() && !descmatcher.find()) continue;
                    versions.add(version);
                    continue;
                }
                versions.add(version);
            }
            result = PageUtil.getDefaultPageList(versions, XUIProject.class);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u7248\u672c\u72b6\u6001")
    @RequestMapping(value={"versionStatusAction"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> versionStatusAction(String versionName, ProjectVersionStatus status) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(versionName);
            if (status != null && projectVersion != null) {
                switch (status) {
                    case RELEASED: {
                        projectVersion.activateProjectVersion();
                        break;
                    }
                    case CLEAR: {
                        projectVersion.delete();
                        break;
                    }
                    case DELETEED: {
                        projectVersion.delete();
                        break;
                    }
                    case UNDERREVISION: {
                        projectVersion.freezeProjectVersion();
                    }
                }
            }
            result.setData((Object)true);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u65b0\u589e\u7248\u672c")
    @RequestMapping(value={"createVersion"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIProject> createVersion(String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion projectVersion = this.getClient().createProcessVersion(projectName);
            result.setData((Object)new XUIProject(projectVersion));
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u5de5\u7a0b\u7248\u672c")
    @RequestMapping(value={"delProjectVersion"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delProjectVersion(String versionName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(versionName);
            this.getClient().delProject(versionName);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u5de5\u7a0b\u7248\u672c")
    @RequestMapping(value={"delProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delProject(String id) {
        ResultModel result = new ResultModel();
        try {
            String[] ids;
            for (String projectId : ids = StringUtility.split((String)id, (String)";")) {
                this.getClient().delProject(projectId);
            }
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"getDbConfigTree"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<UIDBConfigNode>> getDbConfigTree() {
        ListResultModel result = new ListResultModel();
        try {
            ArrayList<UIDBConfigNode> uidbConfigNodes = new ArrayList<UIDBConfigNode>();
            List configs = this.getClient().getAllDbConfig();
            for (ProviderConfig config : configs) {
                uidbConfigNodes.add(new UIDBConfigNode(config));
            }
            result.setData(uidbConfigNodes);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"getDbConfigList"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ProviderConfig>> getDbConfigList() {
        ListResultModel result = new ListResultModel();
        try {
            List configs = this.getClient().getAllDbConfig();
            result.setData((Object)configs);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"addDBConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addDBConfig(@RequestBody ProviderConfig config) {
        ResultModel result = new ResultModel();
        try {
            this.getClient().updateDbConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u589e\u52a0\u6570\u636e\u5e93\u8868")
    @RequestMapping(value={"addTableNames"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addTableNames(String projectName, String configKey, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            ProjectConfig config = version.getProject().getConfig();
            ArrayList<String> tableNames = new ArrayList<String>();
            List<String> configKeyList = Arrays.asList(StringUtility.split((String)id, (String)";"));
            for (String tableName : configKeyList) {
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            DataBaseConfig dataBaseConfig = config.getDataBaseConfigBykey(configKey);
            dataBaseConfig.setTableName(tableNames);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"removeDBConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> removeDBConfig(String configKey) {
        ResultModel result = new ResultModel();
        try {
            MySpace space = this.getClient().getSpace();
            MySpaceConfig spaceConfig = space.getConfig();
            ArrayList newConfigs = new ArrayList();
            Map configMap = spaceConfig.getDbConfig();
            List<String> configKeyList = Arrays.asList(StringUtility.split((String)configKey, (String)";"));
            for (String delkey : configKeyList) {
                configMap.remove(delkey);
            }
            this.getClient().updateSpaceConfig(spaceConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"removeDBformPrj"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> removeDBConfig(String configKey, String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            ProjectConfig config = version.getProject().getConfig();
            List<String> configKeyList = Arrays.asList(StringUtility.split((String)configKey, (String)";"));
            for (String configkey : configKeyList) {
                List configs = config.getDbConfigs();
                configs.remove(config.getDataBaseConfigBykey(configKey));
            }
            config.setDbConfigs(config.getDbConfigs());
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u5de5\u7a0b\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"addProjectDBConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addProjectDBConfig(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            ProjectConfig config = version.getProject().getConfig();
            List<String> configKeyList = Arrays.asList(StringUtility.split((String)id, (String)";"));
            for (String configkey : configKeyList) {
                DataBaseConfig dataBaseConfig = config.getDataBaseConfigBykey(id);
                if (dataBaseConfig != null) continue;
                dataBaseConfig = new DataBaseConfig(configkey);
                config.addDbConfig(dataBaseConfig);
            }
            config.setDbConfigs(config.getDbConfigs());
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u5de5\u7a0b\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"updateProjectDBConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> updateDBConfig(String projectName, String configKey, String tableNames, String simpleName, String ftlTemps) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            ProjectConfig config = version.getProject().getConfig();
            DataBaseConfig dataBaseConfig = config.getDataBaseConfigBykey(configKey);
            if (dataBaseConfig == null) {
                dataBaseConfig = new DataBaseConfig();
                config.addDbConfig(dataBaseConfig);
            }
            if (tableNames != null) {
                String[] tableNameArr = StringUtility.split((String)tableNames, (String)";");
                dataBaseConfig.setTableName(Arrays.asList(tableNameArr));
            }
            if (ftlTemps != null) {
                String[] ftlTempArr = StringUtility.split((String)ftlTemps, (String)";");
                dataBaseConfig.setFtlTemps(Arrays.asList(ftlTempArr));
            }
            config.setDbConfigs(config.getDbConfigs());
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u52a0\u8f7d\u6570\u636e\u5e93\u914d\u7f6e")
    @RequestMapping(value={"loadDBConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<DataBaseConfig>> loadDBConfig(String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            ProjectConfig projectConfig = project.getConfig();
            List configKeys = projectConfig.getDbConfigs();
            ArrayList<DataBaseConfig> realConfigKeys = new ArrayList<DataBaseConfig>();
            ArrayList<DataBaseConfig> errorConfigKeys = new ArrayList<DataBaseConfig>();
            for (DataBaseConfig config : configKeys) {
                String configKey = config.getConfigKey();
                if (configKey != null && this.getClient().getDbConfig(configKey) != null) {
                    config.setProjectName(projectName);
                    realConfigKeys.add(config);
                    continue;
                }
                errorConfigKeys.add(config);
            }
            if (!errorConfigKeys.isEmpty()) {
                configKeys.removeAll(errorConfigKeys);
                this.getClient().updateProjectConfig(project.getId(), projectConfig);
            }
            result.setData(realConfigKeys);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u6587\u4ef6\u5939")
    @RequestMapping(value={"addAPI"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addAPI(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] ids = StringUtility.split((String)id, (String)";");
            ProjectConfig config = version.getProject().getConfig();
            List apis = config.getApiFilter();
            for (String apiId : ids) {
                if (apiId.indexOf(":") == -1) {
                    apiId = "localhost:" + apiId;
                }
                if (apis.contains(apiId)) continue;
                apis.add(apiId);
            }
            config.setApiFilter(apis);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getAllService"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getAllService(String pattern) {
        ListResultModel module = new ListResultModel();
        ArrayList<APIComponentNode> topMenus = new ArrayList<APIComponentNode>();
        try {
            APIComponentNode userNode = new APIComponentNode("userService", "\u7528\u6237\u670d\u52a1", pattern, "xui-icon-dragcopy");
            List userpaths = this.getClient().getAPITopPaths(pattern, APIType.userdef);
            for (APIPaths apiPaths : userpaths) {
                if (apiPaths.getChildIds().size() <= 0) continue;
                APIComponentNode componentNode = new APIComponentNode(apiPaths, true, pattern, null);
                userNode.addSub(componentNode);
            }
            topMenus.add(userNode);
            APIComponentNode loacalNode = new APIComponentNode("loaclServer", "\u7cfb\u7d71\u7cfb\u7edf", pattern, "xui-icon-dragcopy");
            List paths = this.getClient().getAPITopPaths(pattern, APIType.system);
            for (APIPaths apiPaths : paths) {
                if (apiPaths.getChildIds().size() <= 0) continue;
                APIComponentNode componentNode = new APIComponentNode(apiPaths, true, pattern, null);
                if (pattern == null || pattern.equals("")) {
                    componentNode.setIniFold(true);
                }
                loacalNode.addSub(componentNode);
            }
            topMenus.add(loacalNode);
            APIComponentNode serverNode = new APIComponentNode("allServer", "\u8fdc\u7a0b\u670d\u52a1", pattern, "xui-icon-upload");
            ArrayList servers = new ArrayList();
            List serviceBeans = JDSServer.getClusterClient().getAllServer();
            for (ServerNode bean : serviceBeans) {
                if (bean.getServices().size() <= 0) continue;
                APIComponentNode serverAPI = new APIComponentNode(this.getClient().getAPIPaths(bean.getId() + ":/"), true, pattern, null);
                serverAPI.setImageClass("xui-uicmd-cmdbox");
                if (pattern == null || pattern.equals("")) {
                    serverAPI.setIniFold(true);
                }
                serverNode.addSub(serverAPI);
            }
            topMenus.add(serverNode);
            module.setData(topMenus);
        }
        catch (JDSException e) {
            module = new ErrorListResultModel();
            ((ErrorListResultModel)module).setErrcode(100);
            ((ErrorListResultModel)module).setErrdes(e.getMessage());
        }
        return module;
    }

    @ResponseBody
    @RequestMapping(value={"getAllLoclService"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getAllLoclService(String pattern) {
        ListResultModel module = new ListResultModel();
        ArrayList<APIComponentNode> topMenus = new ArrayList<APIComponentNode>();
        try {
            List paths = this.getClient().getAPITopPaths(pattern, APIType.local);
            for (APIPaths apiPaths : paths) {
                if (apiPaths.getChildIds().size() <= 0) continue;
                APIComponentNode componentNode = new APIComponentNode(apiPaths, true, pattern, null);
                topMenus.add(componentNode);
            }
            module.setData(topMenus);
        }
        catch (JDSException e) {
            module = new ErrorListResultModel();
            ((ErrorListResultModel)module).setErrcode(100);
            ((ErrorListResultModel)module).setErrdes(e.getMessage());
        }
        return module;
    }

    @MethodChinaName(cname="\u79fb\u9664\u914d\u7f6e")
    @RequestMapping(value={"deleteAPIConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> deleteAPIConfig(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            ProjectConfig projectConfig = version.getProject().getConfig();
            List idList = projectConfig.getApiFilter();
            String[] ids = StringUtility.split((String)id, (String)";");
            ArrayList<String> allapiIds = new ArrayList<String>();
            allapiIds.addAll(Arrays.asList(ids));
            for (String cid : idList) {
                APIPaths apiPaths = this.getClient().getAPIPaths(cid);
                if (apiPaths != null) continue;
                allapiIds.add(cid);
            }
            for (String cid : allapiIds) {
                idList.remove(cid);
                if (cid.indexOf(":") == -1) {
                    cid = "localhost:" + cid;
                }
                idList.remove(cid);
            }
            version.updateConfig(projectConfig);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u914d\u7f6e")
    @RequestMapping(value={"getAPIConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<APIComponentNode>> getAPIConfig(String projectName, String id) {
        ListResultModel result = new ListResultModel();
        try {
            ESDClient client = ESDFacrory.getESDClient();
            List configs = client.getAPIMethodsByProject(projectName);
            result = PageUtil.getDefaultPageList((List)configs, APIComponentNode.class);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

