package com.ds.esd.util;

import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.CnToSpell;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.context.JDSActionContext;
import com.ds.esd.custom.CustomViewFactory;
import com.ds.esd.custom.bean.CustomViewBean;
import com.ds.esd.custom.bean.MethodConfig;
import com.ds.esd.tool.ui.component.list.TreeListItem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreePageUtil {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, TreePageUtil.class);

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(Set<K> objs, Class<T> clazz) {
        return getTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(Set<K> objs, Class<T> clazz, List<String> ids) {
        List<K> result = new ArrayList<K>();
        result.addAll(objs);
        return getTreeList(result, clazz, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(List<K> objs, Class<T> clazz) {
        return getTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(List<K> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel<List<T>> userStatusInfo = new TreeListResultModel<List<T>>();
        if (ids == null) {
            ids = new ArrayList<>();
        }
        List<T> pageResult = fillObjs(objs, clazz, ids);

        if (ids.isEmpty()) {
            Object id = JDSActionContext.getActionContext().getParams("id");
            if (id != null && !id.equals("")) {
                String[] orgIdArr = StringUtility.split(id.toString(), ";");
                ids = Arrays.asList(orgIdArr);
            } else {
                if (pageResult.size() > 0) {
                    ids.add(pageResult.get(0).getId());
                }
            }
        }

        userStatusInfo.setIds(ids);
        userStatusInfo.setData(pageResult);
        return userStatusInfo;
    }

    public static <T extends TreeListItem> List<T> fillObjs(List objs, Class<T> clazz) {
        return fillObjs(objs, clazz, null);
    }

    public static <T extends TreeListItem> List<T> fillObjs(List objs, Class<T> clazz, List<String> ids) {
        List<FillItemTask<T>> tasks = new ArrayList<FillItemTask<T>>();
        List<T> pageResult = new ArrayList<T>();
        MethodConfig methodConfig = (MethodConfig) JDSActionContext.getActionContext().getContext().get(CustomViewFactory.TopMethodBeanKey);
        CustomViewBean customViewBean = (CustomViewBean) methodConfig.getView();
        for (Object obj : objs)
            if (obj != null) {
                if (clazz == null || obj.getClass().isAssignableFrom(clazz)) {
                    pageResult.add((T) obj);
                } else {
                    FillItemTask<T> task = new FillItemTask(obj, clazz, customViewBean, ids);
                    try {
                        T item = task.call();
                        if (item.getPattern() != null && !item.getPattern().equals("")) {
                            Pattern p = Pattern.compile(item.getPattern(), Pattern.CASE_INSENSITIVE);
                            Matcher namematcher = p.matcher(item.getName() == null ? "" : item.getName());
                            Matcher cnnamematcher = p.matcher(item.getClassName() == null ? "" : item.getClassName());
                            Matcher captionmatcher = p.matcher(item.getCaption() == null ? "" : item.getCaption());
                            Matcher cnmatcher = p.matcher(CnToSpell.getFullSpell(item.getCaption() == null ? "" : item.getCaption()));
                            if (namematcher.find()
                                    || cnnamematcher.find()
                                    || captionmatcher.find()
                                    || cnmatcher.find()
                                    || item.getSub() != null
                                    ) {
                                if (!pageResult.contains(item)) {
                                    pageResult.add(item);
                                }
                            }
                        } else {
                            pageResult.add(item);
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    //tasks.add(task);
                }
            }

//        try {
//            List<Future<T>> futures = Executors.newCachedThreadPool().invokeAll(tasks);
//            for (Future<T> resultFuture : futures) {
//                try {
//                    T result = resultFuture.get();
//                    pageResult.add(result);
//                } catch (InterruptedException e) {
//                    e.printStackTrace();
//                } catch (ExecutionException e) {
//                    e.printStackTrace();
//                }
//            }
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }


        return pageResult;
    }


    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> changTreeList(ListResultModel<List<K>> objs, Class<T> clazz) {
        return changTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> changTreeList(ListResultModel<List<K>> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel<List<T>> userStatusInfo = new TreeListResultModel<List<T>>();
        try {
            List<T> pageResult = new ArrayList<T>();
            List<K> list = objs.get();
            if (ids == null) {
                ids = new ArrayList<>();
            }
            userStatusInfo.setData(fillObjs(list, clazz, ids));
            userStatusInfo.setSize(objs.getSize());

            if (ids.isEmpty()) {
                Object id = JDSActionContext.getActionContext().getParams("id");
                if (id != null && !id.equals("")) {
                    String[] orgIdArr = StringUtility.split(id.toString(), ";");
                    ids = Arrays.asList(orgIdArr);
                } else {
                    if (pageResult.size() > 0) {
                        ids.add(pageResult.get(0).getId());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel) userStatusInfo).setErrdes("内部错误");
        }

        return userStatusInfo;
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(List<T> objs) {
        return getDefaultTreeList(objs, new ArrayList<>());
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(List<T> objs, List<String> ids) {
        return getDefaultTreeList(objs, null, ids);
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(T... objs) {
        List<T> result = new ArrayList<T>();
        result.addAll(Arrays.asList(objs));
        return getDefaultTreeList(objs);
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(Set<T> objs, List<String> ids) {
        List<T> result = new ArrayList<T>();
        result.addAll(objs);
        return getDefaultTreeList(result, null, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(Set<K> objs, Class<T> clazz) {
        return getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(Set<K> objs, Class<T> clazz, List<String> ids) {
        List<K> result = new ArrayList<K>();
        result.addAll(objs);
        return getDefaultTreeList(result, clazz, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(ListResultModel<List<K>> objs, Class<T> clazz) {
        return getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(ListResultModel<List<K>> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel<List<T>> userStatusInfo = new TreeListResultModel<List<T>>();
        try {
            List<T> pageResult = new ArrayList<T>();
            List<K> list = objs.get();
            if (ids == null) {
                ids = new ArrayList<>();
            }
            userStatusInfo.setData(fillObjs(list, clazz, ids));
            userStatusInfo.setSize(objs.getSize());

            if (ids.isEmpty()) {
                Object id = JDSActionContext.getActionContext().getParams("id");
                if (id != null && !id.equals("")) {
                    String[] orgIdArr = StringUtility.split(id.toString(), ";");
                    ids = Arrays.asList(orgIdArr);
                } else {
                    if (pageResult.size() > 0) {
                        ids.add(pageResult.get(0).getId());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel) userStatusInfo).setErrdes("内部错误");
        }

        return userStatusInfo;
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(List<K> objs, Class<T> clazz) {
        return getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(List<K> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel userStatusInfo = null;
        try {
            userStatusInfo = getTreeList(objs, clazz, ids);
        } catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            // ((ErrorResultModel) userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel) userStatusInfo).setErrdes("内部错误");
        }

        return userStatusInfo;

    }


}
