package com.ds.esd.localproxy.handler.filter;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.IOUtility;
import com.ds.server.httpproxy.core.Handler;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.CharsetUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;

public class ProxyDispatcherServlet extends HttpServlet {

    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ProxyDispatcherServlet.class);

    void doPostProxy(Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {


        if (ServletFileUpload.isMultipartContent(req)) {
            MultipartEntityBuilder reqEntitybuild = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(CharsetUtils.get("UTF-8"));
            DiskFileItemFactory dfif = new DiskFileItemFactory();
            dfif.setSizeThreshold(2 * 1024 * 1024 * 1024); //
            ServletFileUpload fileupload = new ServletFileUpload(dfif);

            List<FileItem> files = null;
            try {
                files = fileupload.parseRequest(req);
            } catch (FileUploadException e) {
                e.printStackTrace();
            }
            for (FileItem f : files) {
                if (!f.isFormField()) {
                    String fileName = f.getName();
                    InputStreamBody fileStream = new InputStreamBody(f.getInputStream(), fileName);
                    reqEntitybuild.addPart("file", fileStream);
                } else {
                    if (f != null && f.get() != null && f.get().length > 0) {
                        reqEntitybuild.addTextBody(f.getFieldName(), f.getString("UTF-8"));
                    } else {
                        reqEntitybuild.addTextBody(f.getFieldName(), "");
                    }

                }
            }
            request = request.body(reqEntitybuild.build());
        } else {
            String contentType = req.getContentType();
            if (contentType.indexOf("application/json") > -1) {

                String userData = JSONObject.toJSON(IOUtility.toString(req.getInputStream())).toString();

                request.bodyString(userData, ContentType.APPLICATION_JSON);
            } else {

                Form form = Form.form();
                Enumeration<String> paramNames = req.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String name = paramNames.nextElement();
                    form.add(name, req.getParameter(name));
                }
                request.bodyForm(form.build(), Charset.forName("utf-8"));
            }


        }


        Response response = request.execute();

        HttpResponse httpResponse = response.returnResponse();
        Header[] reqheads = httpResponse.getAllHeaders();

        resp.setHeader("Transfer-Encoding", null);
        for (Header header : reqheads) {
            if (!header.getName().equals("Transfer-Encoding")) {
                resp.setHeader(header.getName(), header.getValue());
            }

        }
        if (httpResponse.getEntity().getContentLength() > 0) {
            resp.setHeader("Content-Length", httpResponse.getEntity().getContentLength() + "");
            resp.setHeader("Transfer-Encoding", null);
        }


        InputStream stream = httpResponse.getEntity().getContent();
        OutputStream os = resp.getOutputStream();
        byte[] b = new byte[4096];
        int length;
        while ((length = stream.read(b)) > 0) {
            os.write(b, 0, length);
        }
        try {
            os.close();
            stream.close();
        } catch (final IOException ioe) {
            resp.setStatus(500);
        }
    }


    void doGetProxy(Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {

        Enumeration<String> heads = req.getHeaderNames();
        while (heads.hasMoreElements()) {
            String name = heads.nextElement();
            request.setHeader(name, req.getHeader(name));
        }

        Response response = request.execute();
        HttpResponse httpResponse = response.returnResponse();
        Header[] reqheads = httpResponse.getAllHeaders();
        for (Header header : reqheads) {
            if (!header.getName().equals("Transfer-Encoding")) {
                resp.setHeader(header.getName(), header.getValue());
            } else {
                resp.setHeader("Transfer-Encoding", null);
            }

        }
        if (httpResponse.getEntity().getContentLength() > 0) {
            resp.setHeader("Content-Length", httpResponse.getEntity().getContentLength() + "");
            resp.setHeader("Transfer-Encoding", null);
        }

        InputStream stream = httpResponse.getEntity().getContent();
        OutputStream os = resp.getOutputStream();
        byte[] b = new byte[4096];
        int length;
        while ((length = stream.read(b)) > 0) {
            os.write(b, 0, length);
        }
        try {
            os.close();
            stream.close();
        } catch (final IOException ioe) {
            resp.setStatus(500);
        }
    }


    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String realUrl = req.getRequestURL().toString();
        String url = req.getPathInfo();
        String queryStr = req.getQueryString();
        if (queryStr != null && !queryStr.equals("")) {
            url = url + "?" + queryStr;
        }


        if (req.getMethod().toUpperCase().equals("GET")) {

            if (url.startsWith("/root") || url.startsWith("/RAD") || url.startsWith("/public")) {
                // super.service(req, res);
                url = "http://192.168.5.43:5337" + url;
            } else {
                url = "http://192.168.5.47:5338" + url;

            }
            Request request = Request.Get(url);
            doGetProxy(request, req, res);
        } else if (req.getMethod().toUpperCase().equals("POST")) {

            if (url.startsWith("/root") || url.startsWith("/RAD") || url.startsWith("/public")) {
                // super.service(req, res);
                url = "http://192.168.5.43:5337" + url;
            } else {
                url = "http://192.168.5.47:5338" + url;

            }
            Request request = Request.Post(url);

            if (!ServletFileUpload.isMultipartContent(req)) {

                Enumeration<String> heads = req.getHeaderNames();
                while (heads.hasMoreElements()) {
                    String name = heads.nextElement();
                    if (!name.toLowerCase().equals("content-length")) {
                        //  request.setHeader(name, StringUtility.replace(req.getHeader(name), "app47.bsisoft.cn", url));
                        request.setHeader(name, req.getHeader(name));
                    }

                }
            } else {
                Enumeration<String> heads = req.getHeaderNames();
                while (heads.hasMoreElements()) {
                    String name = heads.nextElement();
                    for (String httpHeader : Handler.httpHeaderArr) {
                        if (name.toLowerCase().equals(httpHeader)) {
                            request.setHeader(name, req.getHeader(name));
                        }
                    }
                }
            }


            doPostProxy(request, req, res);
        }

    }

    ;

}
