package com.ds.esd.localproxy.handler.filter;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.localproxy.Conts;
import com.ds.esd.tool.module.EUModule;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import freemarker.template.TemplateException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DemoDispatcherServlet extends HttpServlet {

    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, DemoDispatcherServlet.class);
    static List<String> urlList;

//    private static List<XUIAPIConfig> getMethodConfig(String className) {
//        List<XUIAPIConfig> configs = new ArrayList<XUIAPIConfig>();
//        try {
//            APIConfig config = APIConfigFactory.getAPIConfig(className);
//            List<RequestMethodBean> methods = config.getMethods();
//            for (RequestMethodBean methodBean : methods) {
//                XUIAPIConfig xuiapiConfig = new XUIAPIConfig(methodBean);
//                configs.add(xuiapiConfig);
//            }
//        } catch (NotFoundException e) {
//            e.printStackTrace();
//        }
//
//        return configs;
//    }
//
//    public static synchronized List<String> getUrlList() {
//        if (urlList == null) {
//            urlList = new ArrayList<String>();
//            List<Class> classList = new ArrayList<Class>();
//            classList.add(RADEditor.class);
//            classList.add(RADProjectManager.class);
//            classList.add(RADToolService.class);
//            classList.add(RADTempManager.class);
//
//            for (Class clazz : classList) {
//                List<XUIAPIConfig> configs = getMethodConfig(clazz.getName());
//                for (XUIAPIConfig config : configs) {
//                    urlList.add(config.getId());
//                }
//
//            }
//        }
//
//
//        return urlList;
//
//    }


    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setAttribute("ServletResponse", res);
        JDSActionContext.getActionContext().remove();
        Long currTime = System.currentTimeMillis();


        if (req instanceof HttpServletRequest) {
            String path = req.getPathInfo();//RequestUtils.getRelativeReqUrl((HttpServletRequest) req);

            String json = "{}";
            // 激活下载操作
            InputStream stream = null;
            FileInfo fileInfo = null;
            try {
                ESDClient client = ESDFacrory.getESDClient();
                if (path.startsWith("/")) {
                    path = path.substring(1, path.length());
                }
                String projectName = path.substring(0, path.indexOf("/"));
                fileInfo = client.getFileByPath(path, projectName);
                if (fileInfo != null) {
                    stream = fileInfo.getCurrentVersonInputStream();
                }

                if (stream != null) {
                    res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                    res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                    if (fileInfo.getPath().endsWith(".cls")) {
                        EUModule module = null;
                        try {
                            module = client.getModule(fileInfo.getPath(), projectName);
                        } catch (JDSException e) {
                            e.printStackTrace();
                        }

                        json = client.genJSON(module, null).toString();
                        res.getWriter().write(json);
                    } else if (fileInfo.getPath().endsWith(".js")) {
                        try {
                            freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), res.getWriter(),CtVfsFactory.getLocalCachePath());
                        } catch (TemplateException e) {
                            e.printStackTrace();
                        }
                    } else {
                        res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));

                        // 循环写入输出流
                        OutputStream os = res.getOutputStream();
                        byte[] b = new byte[4096];
                        int length;
                        while ((length = stream.read(b)) > 0) {
                            os.write(b, 0, length);
                        }
                        try {
                            os.close();
                            stream.close();
                        } catch (final IOException ioe) {
                            res.setStatus(500);
                        }
                    }
                }
            } catch (JDSException e) {
                e.printStackTrace();
            }


        }
    }

}
