package com.ds.esd.localproxy.handler.filter;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.context.JDSActionContext;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.localproxy.Conts;
import com.ds.esd.tool.module.EUModule;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.VFSConstants;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import com.ds.web.util.RequestUtils;
import freemarker.template.TemplateException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;

public class DefaultDispatcherServlet extends HttpServlet {

    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, DefaultDispatcherServlet.class);


    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setAttribute("ServletResponse", res);
        JDSActionContext.getActionContext().remove();

        Long currTime = System.currentTimeMillis();


        if (req instanceof HttpServletRequest) {
            String path = RequestUtils.getRelativeReqUrl((HttpServletRequest) req);
            String path2 = req.getPathInfo();//RequestUtils.getRelativeReqUrl((HttpServletRequest) req);
            String json = "{}";


            if (path.indexOf("?") > -1) {
                path = path.substring(0, path.indexOf("?"));
            }

            if (path.indexOf("#") > -1) {
                path = path.substring(0, path.indexOf("#"));
            }

            if (path.endsWith(".vhtml")) {
                path = StringUtility.replace(path, ".vhtml", ".html");
            }
            if (path.startsWith("/RAD/form")) {
                path = path.substring("/RAD".length());
            }


            if (path.startsWith("/root/") || path.startsWith("root/")
                    || path.startsWith("form/")
                    || path.startsWith("/form/")
                    ) {
                logger.info("httpUrl=" + path);
                if (path.startsWith("/root/")) {
                    path = path.substring("/root".length());
                }


                // 激活下载操作
                InputStream stream = null;
                FileInfo fileInfo = null;
                try {
                    path = StringUtility.replace(path, ".js", ".cls");
                    fileInfo = getVfsClient().getFileByPath(path);
                    if (fileInfo == null) {
                        path = StringUtility.replace(path, ".cls", ".js");
                        fileInfo = getVfsClient().getFileByPath(path);
                    }
                    if (fileInfo != null) {
                        stream = fileInfo.getCurrentVersonInputStream();
                    }

                } catch (JDSException e) {
                    e.printStackTrace();
                }

                if (stream != null) {
                    res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                    res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();

                    if (fileInfo.getPath().endsWith(".js")) {
                        try {
                            freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), res.getWriter(),CtVfsFactory.getLocalCachePath());
                        } catch (TemplateException e) {
                            e.printStackTrace();
                        }
                    } else {
                        res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));

                        // 循环写入输出流
                        OutputStream os = res.getOutputStream();
                        byte[] b = new byte[4096];
                        int length;
                        while ((length = stream.read(b)) > 0) {
                            os.write(b, 0, length);
                        }
                        try {
                            os.close();
                            stream.close();
                        } catch (final IOException ioe) {
                            res.setStatus(500);
                        }
                    }
                } else if (path.endsWith("debug.html")) {
                    String localPath = JDSConfig.getAbsolutePath(".." + File.separator + ".." + File.separator);
                    File file = new File(localPath + "/RAD/debug.html");
                    json = IOUtility.toString(new FileInputStream(file), VFSConstants.Default_Encoding);
                    try {
                        getVfsClient().saveFileAsContent(path, json,  VFSConstants.Default_Encoding);
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }
                    res.getWriter().write(json);
                } else if (path.endsWith(".js") || path.endsWith(".vv")) {
                    res.getWriter().write(json);
                } else {
                    res.setStatus(404);
                }
            } else {
                String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
                String localPath = JDSConfig.getAbsolutePath(".." + File.separator + ".." + File.separator);
                File file = new File(localPath + path);

                if (file.exists()) {
                    res.setContentType(Conts.getSuffixMap().get(fileName.substring(fileName.indexOf("."))));
                    res.setHeader("Content-disposition", "filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
                    res.setHeader("Content-Length", String.valueOf(file.length()));
                    // 激活下载操作
                    OutputStream os = res.getOutputStream();
                    InputStream stream = new FileInputStream(file);

                    // 循环写入输出流
                    byte[] b = new byte[4096];
                    int length;
                    while ((length = stream.read(b)) > 0) {
                        os.write(b, 0, length);

                    }
                    try {
                        os.close();
                        stream.close();
                    } catch (final IOException ioe) {
                    }

                } else {

                    ESDClient client = null;
                    try {
                        client = ESDFacrory.getESDClient();
                        path = StringUtility.replace(path, "/RAD/", "");
                        String projectName = path.substring(0, path.indexOf("/"));
                        String filePath = path.substring(path.indexOf("/") + 1, path.length());
                        FileInfo fileInfo = client.getFileByPath(filePath, projectName);

                        if (fileInfo == null) {
                            filePath = StringUtility.replace(filePath, ".js", ".cls");
                            fileInfo = client.getFileByPath(filePath,projectName);
                        }
                        if (fileInfo != null) {
                            MD5InputStream stream = fileInfo.getCurrentVersonInputStream();

                            res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                            res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                            JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                            if (fileInfo.getPath().endsWith(".cls")) {
                                EUModule module = null;
                                try {
                                    module = client.getModule(fileInfo.getPath(), projectName);
                                } catch (JDSException e) {
                                    e.printStackTrace();
                                }
                                json = client.genJSON(module, null).toString();
                                res.getWriter().write(json);
                            } else if (fileInfo.getPath().endsWith(".js")) {
                                try {
                                    freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), res.getWriter(),CtVfsFactory.getLocalCachePath());
                                } catch (TemplateException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));
                                // 循环写入输出流
                                OutputStream os = res.getOutputStream();
                                byte[] b = new byte[4096];
                                int length;
                                while ((length = stream.read(b)) > 0) {
                                    os.write(b, 0, length);
                                }
                                try {
                                    os.close();
                                    stream.close();
                                } catch (final IOException ioe) {
                                    res.setStatus(500);
                                }
                            }
                        }
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }


                    //  super.service(req, res);
                }
                String url = RequestUtils.getRelativeReqUrl((HttpServletRequest) req);
                logger.info("httpUrl=" + url + " time=" + (System.currentTimeMillis() - currTime));
            }

        }

    }


    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }

}
