package com.ds.esd.localproxy.handler;


import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSConstants;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.config.ErrorResultModel;
import com.ds.config.JDSUtil;
import com.ds.config.ResultModel;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.web.RequestMethodBean;
import com.ds.web.util.JSONGenUtil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;


public class DSMSpringMVCHandler extends AbstractRADHandler {
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, DSMSpringMVCHandler.class);
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }


    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = rule.matcher(request.getUrl()).matches();
        if (!ruleMatches) {
            return false;
        }
        logger.info("request url " + request.getUrl());
        RequestMethodBean methodBean = this.getRequestMethodBean(request);

        if (methodBean == null) {
            return false;
        }

        try {
            Object object = null;
            String contentType = this.getContentType(request);
            if (contentType != null && contentType.indexOf("multipart/form-data") > -1) {
                object = upload(methodBean, request, response);
            } else {
                object = this.invokMethod(methodBean, request, response);
            }

            Class iClass = JSONGenUtil.getInnerReturnType(methodBean.getSourceMethod());


            if (!InputStream.class.isAssignableFrom(iClass)) {
                String json = object.toString();
                if (json.endsWith(".ftl")) {
                    return this.sendFtl(request, response, json);
                } else {
                    if (methodBean.getResponseBody() != null) {
                        json = JSONObject.toJSONString(object);
                    }
                    return sendJSON(methodBean, response, json);
                }

            } else {
                ResultModel<InputStream> resultModel = (ResultModel<InputStream>) this.invokMethod(methodBean, request, response);
                InputStream inputStream = resultModel.get();
                if (inputStream != null) {
                    String mdrStr = MD5.getHashString(inputStream);
                    File file = new File(JDSUtil.getJdsRealPath() + "temp" + File.separator + mdrStr + ".temp");
                    response.addHeader("Content-disposition", "filename=" + new String(file.getName().getBytes("utf-8"), "ISO8859-1"));
                    response.addHeader("Content-Length", String.valueOf(file.length()));
                    response.sendResponse(inputStream, Integer.valueOf(Long.toString(file.length())));
                }
                return true;

            }

        } catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel resultModel = new ErrorResultModel();
            resultModel.setErrdes(e.getMessage());
            return sendJSON(methodBean, response, JSONObject.toJSONString(resultModel, false));
        }

    }


}
