package com.ds.esd.dic.org;

import com.ds.esd.tool.ui.component.list.TreeListItem;
import com.ds.esd.tool.ui.component.panel.TreeViewProperties;
import com.ds.esd.tool.ui.enums.SelModeType;
import com.ds.org.Org;

import java.util.ArrayList;
import java.util.List;

public class DepartmentTreeProperties extends TreeViewProperties {


    public DepartmentTreeProperties(String alias, String topId) {
        this(alias, null, topId, SelModeType.multibycheckbox);
    }


    public DepartmentTreeProperties(String alias, List<Org> orgList, String topId) {
        this(alias, orgList, topId, SelModeType.multibycheckbox);
    }


    public DepartmentTreeProperties(String alias, List<Org> orgList, String topId, SelModeType type) {
        this.setName(alias);
        this.setIniFold(false);
        this.setDesc(alias);
        boolean signSelect = false;

        if (type.equals(SelModeType.singlecheckbox)) {
            signSelect = true;
        }
        DepartmentExtTree departmentExtTree = new DepartmentExtTree(orgList, topId, signSelect);
        if (departmentExtTree != null) {
            UINode node = departmentExtTree.getTopTree();
            List<TreeListItem> ndoes = new ArrayList<TreeListItem>();
            ndoes.add(node);
            if (!departmentExtTree.isSignSelect()) {
                this.setSelMode(SelModeType.multibycheckbox);
            } else {
                this.setSelMode(SelModeType.singlecheckbox);
            }

            this.setItems(ndoes);
        }


    }
}
