package com.ds.esd.dic.org;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.org.Org;
import com.ds.org.OrgNotFoundException;
import com.ds.org.conf.OrgConstants;
import com.ds.server.OrgManagerFactory;
import net.sf.cglib.beans.BeanMap;

import java.util.*;

public class DepartmentExtTree {
    protected static Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), DepartmentExtTree.class);

    private List<Org> orgs = new ArrayList<Org>();

    private Org topOrg;

    private String topOrgId;

    private boolean signSelect = false;

    public boolean isSignSelect() {
        return signSelect;
    }

    public void setSignSelect(boolean signSelect) {
        this.signSelect = signSelect;
    }

    public DepartmentExtTree(List<Org> childorgs, String topOrgId, boolean signSelect) {
        Map orgMap = new HashMap();
        this.signSelect = signSelect;
        this.orgs = childorgs;
        if (topOrgId == null) {
            this.topOrgId = OrgManagerFactory.getOrgManager().getTopOrgs(JDSActionContext.getActionContext().getSystemCode()).get(0).getOrgId();
        } else {
            this.topOrgId = topOrgId;
        }
        if (orgs == null || orgs.size() == 0) {
            try {
                Org topOrg = OrgManagerFactory.getOrgManager().getOrgByID(this.topOrgId);
                this.orgs = topOrg.getChildrenRecursivelyList();
            } catch (OrgNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (orgs != null) {
            for (Org org : orgs) {
                if (!orgMap.containsKey(org.getOrgId())) {
                    addOrg(orgMap, org);
                }
            }
        }
        orgs.addAll(orgMap.values());
    }

    private UINode getChildTree(String orgId) {
        if (orgId == null) {
            return this.getTopTree();
        }

        Org org = null;
        try {
            org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
        } catch (OrgNotFoundException e) {
            e.printStackTrace();
        }
        UINode childNode = null;
        if (org == null || !isOrgInOrgs(org, orgs)) {

            // childNode.setId(org.getID());
            // childNode.setCaption("读取错误");
        } else {
            childNode = new UINode();
            childNode.setId(org.getOrgId());
            childNode.setCaption(org.getName());

            if (org.getChildrenList().size() > 0) {
                List<Org> list = org.getChildrenList();
                CommonComparator comparator = new CommonComparator();
                comparator.setFields_user(new String[]{"index"});
                Collections.sort(list, comparator);

                for (int j = 0; j < list.size(); j++) {
                    Org ccorg = list.get(j);
                    if (isOrgInOrgs(ccorg, orgs)) {
                        addChildNode(childNode, ccorg, orgs);

                    }
                }
            }

        }

        return childNode;
    }

    public UINode getTopTree() {
        String rootStr = "点击选择组织机构";
        UINode root = new UINode();
        try {
            topOrg = OrgManagerFactory.getOrgManager().getOrgByID(this.topOrgId);
        } catch (OrgNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        root.setId(topOrg.getOrgId());
        root.setSignSelect(this.signSelect);

        root.setCaption(topOrg.getName());

        if (orgs.size() == 0) {
            rootStr = "没有设定";
            root.setCaption(rootStr);

        } else {
            List<Org> list = new ArrayList<Org>();
            for (int k = 0; k < this.topOrg.getChildrenList().size(); k++) {
                list.add(topOrg.getChildrenList().get(k));
            }

            CommonComparator comparator = new CommonComparator();
            comparator.setFields_user(new String[]{"index"});
            Collections.sort(list, comparator);
            for (int k = 0; k < list.size(); k++) {
                UINode node = this.getChildTree(list.get(k).getOrgId());
                if (node != null) {
                    root.addSub(node);
                }
            }
        }

        return root;
    }

    /**
     * @param map
     * @param org
     */
    private void addOrg(Map map, Org org) {
        if (org != null) {
            map.put(org.getOrgId(), org);
            Org parent = org.getParent();

            if (parent != null) {
                if (this.topOrgId != null && org.getOrgId().equals(topOrgId)) {
                    this.topOrg = parent;
                    map.put(parent.getOrgId(), parent);
                } else {
                    if (!map.containsKey(parent.getOrgId())) {
                        addOrg(map, parent);
                    }
                }

            } else {
                this.topOrg = org;

            }

        }

    }

    private boolean isOrgInOrgs(Org org, List<Org> orgs) {
        for (Org corg : orgs) {
            if (org.getOrgId().equals(corg.getOrgId())) {
                return Boolean.TRUE;
            }
        }
        return false;
    }


    private UINode addChildNode(UINode parentnode, Org org, List<Org> orgs) {
        if (isOrgInOrgs(org, orgs)) {
            UINode inputNode = new UINode();
            inputNode.setId(org.getOrgId());
            inputNode.setCaption(org.getName());
            inputNode.setImageClass("xui-icon-menu");
            parentnode.addSub(inputNode);
            List<Org> childs = org.getChildrenList();
            for (Org corg : childs) {
                addChildNode(inputNode, corg, orgs);
            }
        }
        return parentnode;

    }

    class CommonComparator implements Comparator {
        /***********************************************************************
         * @param 比较对象的属性用String[]的形式传过来
         *            比较的对象一定要符合javaBean，即要有Set,Get方法
         */
        String[] fields_user = null;

        public String[] getFields_user() {
            return fields_user;
        }

        public void setFields_user(String[] fields_user) {
            this.fields_user = fields_user;
        }

        /**
         * 定义排序规则 如果按照不止一个属性进行排序 这按照属性的顺序进行排序,类是sql order by 即只要比较出同位置的属性就停止
         */
        public int compare(Object obj1, Object obj2) {
            // 没有属性，则不排序
            if (fields_user == null || fields_user.length <= 0) {
                return 2;// 不比较
            }
            for (int i = 0; i < fields_user.length; i++) {
                if (compareField(obj1, obj2, fields_user[i])) {
                    // 如果obj1的属性值大于obj2的属性值，则返回正数
                    return 1;
                } else {
                    // 小于返回负数
                    return -1;
                }
            }
            // 相等返回0
            return 0;
        }

        /**
         * @param fieldName 根据属性名排序
         */
        private boolean compareField(Object o1, Object o2, String fieldName) {
            try {
                Object value1 = BeanMap.create(o1).get(fieldName);
                Object value2 = BeanMap.create(o2).get(fieldName);
                if ((value1 != null && value2 != null) && Integer.parseInt(value1.toString()) > Integer.parseInt(value2.toString())) {
                    return true;
                }
            } catch (Exception e) {
                log.info("---------对象的该属性不存在或者不允许在此安全级别上反射该属性，详情请查阅JAVA DOC--------");
                e.printStackTrace();
            }
            return false;
        }


    }

}
