package com.ds.esd.dic.file;

import com.ds.esd.tool.ui.component.list.TreeListItem;
import com.ds.esd.tool.ui.component.panel.TreeViewProperties;
import com.ds.esd.tool.ui.enums.SelModeType;
import com.ds.vfs.Folder;

import java.util.ArrayList;
import java.util.List;

public class FolderTreeProperties extends TreeViewProperties<TreeListItem> {


    public FolderTreeProperties(String alias) {
        this(alias, null, null, SelModeType.multibycheckbox);
    }

    public FolderTreeProperties(String alias, String topFolderId, List<Folder> folders) {
        this(alias, topFolderId, folders, SelModeType.multibycheckbox);
    }


    public FolderTreeProperties(String alias, String topFolderId, List<Folder> folders, SelModeType type) {
        this.setName(alias);
        this.setIniFold(false);
        this.setDesc(alias);
        boolean signSelect = false;

        if (type.equals(SelModeType.singlecheckbox)) {
            signSelect = true;
        }
        FolderExtTree folderExtTree = new FolderExtTree(folders, topFolderId, signSelect);

        if (folderExtTree != null) {
            UIFileNode node = folderExtTree.getChildTree(topFolderId);
            List<TreeListItem> ndoes = new ArrayList<TreeListItem>();
            ndoes.add(node);
            if (!folderExtTree.isSignSelect()) {
                this.setSelMode(SelModeType.multibycheckbox);
            } else {
                this.setSelMode(SelModeType.singlecheckbox);
            }

            this.setItems(ndoes);
        }


    }
}
