package com.ds.esd.dic.file;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esd.client.ESDFacrory;
import com.ds.org.conf.OrgConstants;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import net.sf.cglib.beans.BeanMap;

import java.util.*;

public class FolderExtTree {
    protected static Log log = LogFactory.getLog(OrgConstants.CONFIG_KEY.getType(), FolderExtTree.class);

    private List<Folder> folders = new ArrayList<Folder>();

    private Folder topFolder;

    private String topFolderId;

    private boolean signSelect = false;

    public boolean isSignSelect() {
        return signSelect;
    }

    public void setSignSelect(boolean signSelect) {
        this.signSelect = signSelect;
    }

    public FolderExtTree(List<Folder> allfolders, String topFolderId, boolean signSelect) {
        Map folderMap = new HashMap();
        this.folders = allfolders;
        this.signSelect = signSelect;
        try {
            if (topFolderId == null) {
                this.topFolderId = ESDFacrory.getESDClient().getSpace().getId();
            } else {
                this.topFolderId = topFolderId;
            }


            Folder topFolder = CtVfsFactory.getCtVfsService().getFolderById(this.topFolderId);
            if (topFolder != null && folders == null) {
                folders = topFolder.getChildrenRecursivelyList();
            }
        } catch (JDSException e) {
            e.printStackTrace();
        }

        for (Folder folder : folders) {
            if (!folderMap.containsKey(folder.getID())) {
                addFolder(folderMap, folder);
            }
            if (folder != null) {
                if (!folderMap.containsKey(folder.getID())) {
                    addFolder(folderMap, folder);
                }
            }
        }
        folders.addAll(folderMap.values());

    }

    public UIFileNode getChildTree(String folderId) {
        if (folderId == null) {
            return this.getTopTree();
        }

        Folder folder = null;
        try {
            folder = CtVfsFactory.getCtVfsService().getFolderById(folderId);

        } catch (JDSException e) {
            e.printStackTrace();
        }
        UIFileNode childNode = null;
        if (folder == null || !isFolderInFolders(folder, folders)) {

            // childNode.setId(org.getID());
            // childNode.setCaption("读取错误");
        } else {
            childNode = new UIFileNode();
            childNode.setId(folder.getPath());
            childNode.setCaption(folder.getName());

            if (folder.getChildrenList().size() > 0) {
                List<Folder> list = folder.getChildrenList();


                CommonComparator comparator = new CommonComparator();
                comparator.setFields_user(new String[]{"index"});
                Collections.sort(list, comparator);

                for (int j = 0; j < list.size(); j++) {
                    Folder cfolder = list.get(j);
                    if (isFolderInFolders(cfolder, folders)) {
                        addChildNode(childNode, cfolder, folders);

                    }
                }
            }

        }

        return childNode;
    }

    private UIFileNode getTopTree() {
        String rootStr = "所有文件";
        UIFileNode root = new UIFileNode();
        try {
            topFolder = CtVfsFactory.getCtVfsService().getFolderById(this.topFolderId);
        } catch (JDSException e) {
            e.printStackTrace();
        }
        root.setId(topFolder.getPath());
        root.setSignSelect(this.signSelect);
        root.setCaption(topFolder.getName());

        if (folders.size() == 0) {
            rootStr = "没有设定";
            root.setCaption(rootStr);

        } else {
            List<Folder> list = new ArrayList<Folder>();
            for (int k = 0; k < this.topFolder.getChildrenList().size(); k++) {
                list.add(topFolder.getChildrenList().get(k));
            }

            CommonComparator comparator = new CommonComparator();
            comparator.setFields_user(new String[]{"index"});
            Collections.sort(list, comparator);
            for (int k = 0; k < list.size(); k++) {
                UIFileNode node = this.getChildTree(list.get(k).getID());
                if (node != null) {
                    root.addSub(node);
                }
            }
        }

        return root;
    }


    private void addFolder(Map<String, Folder> map, Folder folder) {
        if (folder != null) {
            map.put(folder.getID(), folder);
            Folder parent = folder.getParent();

            if (parent != null) {
                if (this.topFolderId != null && folder.getID().equals(topFolderId)) {
                    this.topFolder = parent;
                    map.put(parent.getID(), parent);
                } else {
                    if (!map.containsKey(parent.getID())) {
                        addFolder(map, parent);
                    }
                }

            } else {
                this.topFolder = folder;

            }

        }

    }

    private boolean isFolderInFolders(Folder folder, List<Folder> folders) {
        for (Folder cfolder : folders) {
            if (folder.getID().equals(cfolder.getID())) {
                return Boolean.TRUE;
            }
        }
        return false;
    }


    private UIFileNode addChildNode(UIFileNode parentnode, Folder folder, List<Folder> folders) {
        if (isFolderInFolders(folder, folders)) {
            UIFileNode inputNode = new UIFileNode();
            inputNode.setId(folder.getPath());
            inputNode.setCaption(folder.getName());
            inputNode.setImageClass("xui-icon-file-fold");
            parentnode.addSub(inputNode);

            List<Folder> childFolders = folder.getChildrenList();
            for (Folder cfolder : childFolders) {
                addChildNode(inputNode, cfolder, folders);
            }

        }

        return parentnode;

    }

    class CommonComparator implements Comparator {
        /***********************************************************************
         * @param 比较对象的属性用String[]的形式传过来
         *            比较的对象一定要符合javaBean，即要有Set,Get方法
         */
        String[] fields_user = null;

        public String[] getFields_user() {
            return fields_user;
        }

        public void setFields_user(String[] fields_user) {
            this.fields_user = fields_user;
        }

        /**
         * 定义排序规则 如果按照不止一个属性进行排序 这按照属性的顺序进行排序,类是sql order by 即只要比较出同位置的属性就停止
         */
        public int compare(Object obj1, Object obj2) {
            // 没有属性，则不排序
            if (fields_user == null || fields_user.length <= 0) {
                return 2;// 不比较
            }
            for (int i = 0; i < fields_user.length; i++) {
                if (compareField(obj1, obj2, fields_user[i])) {
                    // 如果obj1的属性值大于obj2的属性值，则返回正数
                    return 1;
                } else {
                    // 小于返回负数
                    return -1;
                }
            }
            // 相等返回0
            return 0;
        }

        /**
         * @param fieldName 根据属性名排序
         */
        private boolean compareField(Object o1, Object o2, String fieldName) {
            try {
                Object value1 = BeanMap.create(o1).get(fieldName);
                Object value2 = BeanMap.create(o2).get(fieldName);
                if ((value1 != null && value2 != null) && Integer.parseInt(value1.toString()) > Integer.parseInt(value2.toString())) {
                    return true;
                }
            } catch (Exception e) {
                log.info("---------对象的该属性不存在或者不允许在此安全级别上反射该属性，详情请查阅JAVA DOC--------");
                e.printStackTrace();
            }
            return false;
        }


    }

}
