package com.ds.esd.dic.file;

import com.ds.esd.tool.ui.component.list.TreeListItem;
import com.ds.esd.tool.ui.component.panel.TreeViewProperties;
import com.ds.esd.tool.ui.enums.SelModeType;
import com.ds.vfs.FileInfo;

import java.util.ArrayList;
import java.util.List;

public class FileTreeProperties extends TreeViewProperties {


    public FileTreeProperties(String alias) {
        this(alias, null, null, SelModeType.multibycheckbox, true);
    }

    public FileTreeProperties(String alias, List<FileInfo> fileList, String topFolderId) {
        this(alias, fileList, topFolderId, SelModeType.multibycheckbox, true);
    }

    public FileTreeProperties(String alias, List<FileInfo> fileList, String topFolderId, boolean viewfile) {
        this(alias, fileList, topFolderId, SelModeType.multibycheckbox, viewfile);
    }

    public FileTreeProperties(String alias, List<FileInfo> fileList, String topFolderId, SelModeType type, boolean viewFile) {
        this.setName(alias);
        this.setIniFold(false);
        this.setDesc(alias);
        boolean signSelect = false;

        if (type.equals(SelModeType.single)) {
            signSelect = true;
        }
        FileExtTree filetree = new FileExtTree(fileList, topFolderId, viewFile, signSelect);

        if (filetree != null) {
            UIFileNode node = filetree.getChildTree(topFolderId);
            List<TreeListItem> ndoes = new ArrayList<TreeListItem>();
            ndoes.add(node);
            if (!filetree.isSignSelect()) {
                this.setSelMode(SelModeType.multibycheckbox);
            } else {
                this.setSelMode(SelModeType.single);
            }

            this.setItems(ndoes);
        }


    }
}
