/*
 * Decompiled with CFR 0.152.
 */
package com.quinn.hunter.transform.concurrent;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class Worker {
    protected final LinkedList<Future<?>> futures = new LinkedList<Future<?>>(){

        @Override
        public synchronized boolean add(Future<?> future) {
            return super.add(future);
        }

        @Override
        public synchronized Future<?> pollFirst() {
            return (Future)super.pollFirst();
        }
    };
    protected ExecutorService executor;

    Worker(ExecutorService executor) {
        this.executor = executor;
    }

    public void execute(Runnable runnable) {
        this.futures.add(this.executor.submit(runnable));
    }

    public <T> Future<T> submit(Callable<T> callable) {
        Future<T> future = this.executor.submit(callable);
        this.futures.add(future);
        return future;
    }

    public void await() throws IOException {
        Future<?> future;
        while ((future = this.futures.pollFirst()) != null) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public <I> void submitAndAwait(Collection<I> is, Consumer<I> consumer) throws IOException {
        is.stream().map(f -> () -> consumer.accept(f)).forEach(this::execute);
        this.await();
    }
}

