/*
 * Decompiled with CFR 0.152.
 */
package com.quinn.hunter.transform.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ExtendClassWriter
extends ClassWriter {
    public static final String TAG = "ExtendClassWriter";
    private static final String OBJECT = "java/lang/Object";
    private ClassLoader urlClassLoader;

    public ExtendClassWriter(ClassLoader urlClassLoader, int flags) {
        super(flags);
        this.urlClassLoader = urlClassLoader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1 == null || type1.equals(OBJECT) || type2 == null || type2.equals(OBJECT)) {
            return OBJECT;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        ClassReader type1ClassReader = this.getClassReader(type1);
        ClassReader type2ClassReader = this.getClassReader(type2);
        if (type1ClassReader == null || type2ClassReader == null) {
            return OBJECT;
        }
        if (this.isInterface(type1ClassReader)) {
            String interfaceName = type1;
            if (this.isImplements(interfaceName, type2ClassReader)) {
                return interfaceName;
            }
            if (this.isInterface(type2ClassReader) && this.isImplements(interfaceName = type2, type1ClassReader)) {
                return interfaceName;
            }
            return OBJECT;
        }
        if (this.isInterface(type2ClassReader)) {
            String interfaceName = type2;
            if (this.isImplements(interfaceName, type1ClassReader)) {
                return interfaceName;
            }
            return OBJECT;
        }
        HashSet<String> superClassNames = new HashSet<String>();
        superClassNames.add(type1);
        superClassNames.add(type2);
        String type1SuperClassName = type1ClassReader.getSuperName();
        if (!superClassNames.add(type1SuperClassName)) {
            return type1SuperClassName;
        }
        String type2SuperClassName = type2ClassReader.getSuperName();
        if (!superClassNames.add(type2SuperClassName)) {
            return type2SuperClassName;
        }
        while (type1SuperClassName != null || type2SuperClassName != null) {
            if (type1SuperClassName != null && (type1SuperClassName = this.getSuperClassName(type1SuperClassName)) != null && !superClassNames.add(type1SuperClassName)) {
                return type1SuperClassName;
            }
            if (type2SuperClassName == null || (type2SuperClassName = this.getSuperClassName(type2SuperClassName)) == null || superClassNames.add(type2SuperClassName)) continue;
            return type2SuperClassName;
        }
        return OBJECT;
    }

    private boolean isImplements(String interfaceName, ClassReader classReader) {
        ClassReader classInfo = classReader;
        while (classInfo != null) {
            String[] interfaceNames;
            for (String name : interfaceNames = classInfo.getInterfaces()) {
                if (name == null || !name.equals(interfaceName)) continue;
                return true;
            }
            for (String name : interfaceNames) {
                ClassReader interfaceInfo;
                if (name == null || (interfaceInfo = this.getClassReader(name)) == null || !this.isImplements(interfaceName, interfaceInfo)) continue;
                return true;
            }
            String superClassName = classInfo.getSuperName();
            if (superClassName == null || superClassName.equals(OBJECT)) break;
            classInfo = this.getClassReader(superClassName);
        }
        return false;
    }

    private boolean isInterface(ClassReader classReader) {
        return (classReader.getAccess() & 0x200) != 0;
    }

    private String getSuperClassName(String className) {
        ClassReader classReader = this.getClassReader(className);
        if (classReader == null) {
            return null;
        }
        return classReader.getSuperName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader getClassReader(String className) {
        InputStream inputStream = this.urlClassLoader.getResourceAsStream(className + ".class");
        try {
            if (inputStream != null) {
                ClassReader classReader = new ClassReader(inputStream);
                return classReader;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

