/*
 * Decompiled with CFR 0.152.
 */
package com.quinn.hunter.transform.asm;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.AppExtension;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.gradle.api.Project;

public class ClassLoaderHelper {
    public static URLClassLoader getClassLoader(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, Project project) throws MalformedURLException {
        ImmutableList.Builder urls = new ImmutableList.Builder();
        String androidJarPath = ClassLoaderHelper.getAndroidJarPath(project);
        File file = new File(androidJarPath);
        URL androidJarURL = file.toURI().toURL();
        urls.add((Object)androidJarURL);
        for (TransformInput totalInputs : Iterables.concat(inputs, referencedInputs)) {
            for (DirectoryInput directoryInput : totalInputs.getDirectoryInputs()) {
                if (!directoryInput.getFile().isDirectory()) continue;
                urls.add((Object)directoryInput.getFile().toURI().toURL());
            }
            for (JarInput jarInput : totalInputs.getJarInputs()) {
                if (!jarInput.getFile().isFile()) continue;
                urls.add((Object)jarInput.getFile().toURI().toURL());
            }
        }
        ImmutableList allUrls = urls.build();
        URL[] classLoaderUrls = (URL[])allUrls.toArray((Object[])new URL[0]);
        return new URLClassLoader(classLoaderUrls);
    }

    private static String getAndroidJarPath(Project project) {
        AppExtension appExtension = (AppExtension)project.getProperties().get("android");
        String sdkDirectory = appExtension.getSdkDirectory().getAbsolutePath();
        String compileSdkVersion = appExtension.getCompileSdkVersion();
        sdkDirectory = sdkDirectory + File.separator + "platforms" + File.separator;
        return sdkDirectory + compileSdkVersion + File.separator + "android.jar";
    }
}

