/*
 * Decompiled with CFR 0.152.
 */
package com.quinn.hunter.transform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.quinn.hunter.transform.RunVariant;
import com.quinn.hunter.transform.asm.BaseWeaver;
import com.quinn.hunter.transform.asm.ClassLoaderHelper;
import com.quinn.hunter.transform.concurrent.Schedulers;
import com.quinn.hunter.transform.concurrent.Worker;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class HunterTransform
extends Transform {
    private final Logger logger;
    private static final Set<QualifiedContent.Scope> SCOPES = new HashSet<QualifiedContent.Scope>();
    private final Project project;
    protected BaseWeaver bytecodeWeaver;
    private final Worker worker;
    private boolean emptyRun = false;

    public HunterTransform(Project project) {
        this.project = project;
        this.logger = project.getLogger();
        this.worker = Schedulers.IO();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return SCOPES;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        RunVariant runVariant = this.getRunVariant();
        if ("debug".equals(context.getVariantName())) {
            this.emptyRun = runVariant == RunVariant.RELEASE || runVariant == RunVariant.NEVER;
        } else if ("release".equals(context.getVariantName())) {
            this.emptyRun = runVariant == RunVariant.DEBUG || runVariant == RunVariant.NEVER;
        }
        this.logger.warn(this.getName() + " isIncremental = " + isIncremental + ", runVariant = " + (Object)((Object)runVariant) + ", emptyRun = " + this.emptyRun + ", inDuplicatedClassSafeMode = " + this.inDuplicatedClassSafeMode());
        long startTime = System.currentTimeMillis();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        URLClassLoader urlClassLoader = ClassLoaderHelper.getClassLoader(inputs, referencedInputs, this.project);
        this.bytecodeWeaver.setClassLoader(urlClassLoader);
        boolean flagForCleanDexBuilderFolder = false;
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                Status status = jarInput.getStatus();
                File dest = outputProvider.getContentLocation(jarInput.getFile().getAbsolutePath(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (isIncremental && !this.emptyRun) {
                    switch (status) {
                        case NOTCHANGED: {
                            break;
                        }
                        case ADDED: 
                        case CHANGED: {
                            this.transformJar(jarInput.getFile(), dest, status);
                            break;
                        }
                        case REMOVED: {
                            if (!dest.exists()) break;
                            FileUtils.forceDelete((File)dest);
                        }
                    }
                    continue;
                }
                if (this.inDuplicatedClassSafeMode() && !isIncremental && !flagForCleanDexBuilderFolder) {
                    this.cleanDexBuilderFolder(dest);
                    flagForCleanDexBuilderFolder = true;
                }
                this.transformJar(jarInput.getFile(), dest, status);
            }
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File dest = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                FileUtils.forceMkdir((File)dest);
                if (isIncremental && !this.emptyRun) {
                    String srcDirPath = directoryInput.getFile().getAbsolutePath();
                    String destDirPath = dest.getAbsolutePath();
                    Map fileStatusMap = directoryInput.getChangedFiles();
                    for (Map.Entry changedFile : fileStatusMap.entrySet()) {
                        Status status = (Status)changedFile.getValue();
                        File inputFile = (File)changedFile.getKey();
                        String destFilePath = inputFile.getAbsolutePath().replace(srcDirPath, destDirPath);
                        File destFile = new File(destFilePath);
                        switch (status) {
                            case NOTCHANGED: {
                                break;
                            }
                            case REMOVED: {
                                if (!destFile.exists()) break;
                                destFile.delete();
                                break;
                            }
                            case ADDED: 
                            case CHANGED: {
                                try {
                                    FileUtils.touch((File)destFile);
                                }
                                catch (IOException e) {
                                    FileUtils.forceMkdirParent((File)destFile);
                                }
                                this.transformSingleFile(inputFile, destFile, srcDirPath);
                            }
                        }
                    }
                    continue;
                }
                this.transformDir(directoryInput.getFile(), dest);
            }
        }
        this.worker.await();
        long costTime = System.currentTimeMillis() - startTime;
        this.logger.warn(this.getName() + " costed " + costTime + "ms");
    }

    private void transformSingleFile(File inputFile, File outputFile, String srcBaseDir) {
        this.worker.submit(() -> {
            this.bytecodeWeaver.weaveSingleClassToFile(inputFile, outputFile, srcBaseDir);
            return null;
        });
    }

    private void transformDir(File inputDir, File outputDir) throws IOException {
        if (this.emptyRun) {
            FileUtils.copyDirectory((File)inputDir, (File)outputDir);
            return;
        }
        String inputDirPath = inputDir.getAbsolutePath();
        String outputDirPath = outputDir.getAbsolutePath();
        if (inputDir.isDirectory()) {
            for (File file : com.android.utils.FileUtils.getAllFiles((File)inputDir)) {
                this.worker.submit(() -> {
                    String filePath = file.getAbsolutePath();
                    File outputFile = new File(filePath.replace(inputDirPath, outputDirPath));
                    this.bytecodeWeaver.weaveSingleClassToFile(file, outputFile, inputDirPath);
                    return null;
                });
            }
        }
    }

    private void transformJar(File srcJar, File destJar, Status status) {
        this.worker.submit(() -> {
            if (this.emptyRun) {
                FileUtils.copyFile((File)srcJar, (File)destJar);
                return null;
            }
            this.bytecodeWeaver.weaveJar(srcJar, destJar);
            return null;
        });
    }

    private void cleanDexBuilderFolder(File dest) {
        this.worker.submit(() -> {
            try {
                String dexBuilderDir = this.replaceLastPart(dest.getAbsolutePath(), this.getName(), "dexBuilder");
                File file = new File(dexBuilderDir).getParentFile();
                this.project.getLogger().warn("clean dexBuilder folder = " + file.getAbsolutePath());
                if (file.exists() && file.isDirectory()) {
                    com.android.utils.FileUtils.deleteDirectoryContents((File)file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    private String replaceLastPart(String originString, String replacement, String toreplace) {
        int start = originString.lastIndexOf(replacement);
        StringBuilder builder = new StringBuilder();
        builder.append(originString, 0, start);
        builder.append(toreplace);
        builder.append(originString.substring(start + replacement.length()));
        return builder.toString();
    }

    public boolean isCacheable() {
        return true;
    }

    protected RunVariant getRunVariant() {
        return RunVariant.ALWAYS;
    }

    protected boolean inDuplicatedClassSafeMode() {
        return false;
    }

    static {
        SCOPES.add(QualifiedContent.Scope.PROJECT);
        SCOPES.add(QualifiedContent.Scope.SUB_PROJECTS);
        SCOPES.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
    }
}

