/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.rxtx.starter;

import cn.qqhxj.rxtx.context.SerialContext;
import cn.qqhxj.rxtx.context.SerialContextImpl;
import cn.qqhxj.rxtx.context.SerialPortConfig;
import cn.qqhxj.rxtx.starter.annotation.EnableSerialPort;
import cn.qqhxj.rxtx.starter.annotation.EnableSerialPorts;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Order(value=-2147483648)
public class SerialPortRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(SerialPortRegistrar.class);

    private void registerBeanDefinitions(Map<String, Object> attributes, BeanDefinitionRegistry beanDefinitionRegistry) {
        SerialPortConfig serialPortConfig = new SerialPortConfig();
        String alias = String.valueOf(attributes.get("value"));
        attributes.remove("value");
        attributes.forEach((k, v) -> {
            try {
                Field field = SerialPortConfig.class.getDeclaredField((String)k);
                field.setAccessible(true);
                field.set(serialPortConfig, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (StringUtils.isEmpty((Object)alias)) {
            alias = String.valueOf(serialPortConfig.getPort());
        }
        serialPortConfig.setAlias(alias);
        SerialPortRegistrar.registerSerialContextBean(beanDefinitionRegistry, serialPortConfig, serialPortConfig.getAlias());
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Set annotationTypes = annotationMetadata.getAnnotationTypes();
        for (String annotationType : annotationTypes) {
            Map attributes;
            if (annotationType.equals(EnableSerialPorts.class.getName())) {
                Object value;
                Map annotationAttributes = annotationMetadata.getAnnotationAttributes(EnableSerialPorts.class.getName(), false);
                if (annotationAttributes == null || (value = annotationAttributes.get("value")) == null || !(value instanceof AnnotationAttributes[])) continue;
                for (AnnotationAttributes attributes2 : (AnnotationAttributes[])value) {
                    this.registerBeanDefinitions((Map<String, Object>)attributes2, beanDefinitionRegistry);
                }
                continue;
            }
            if (!annotationType.equals(EnableSerialPort.class.getName()) || (attributes = annotationMetadata.getAnnotationAttributes(EnableSerialPort.class.getName(), false)) == null) continue;
            this.registerBeanDefinitions(attributes, beanDefinitionRegistry);
        }
    }

    public static void registerSerialContextBean(BeanDefinitionRegistry beanDefinitionRegistry, SerialPortConfig serialPortConfig, String beanName) {
        try {
            log.info("[{}] configured [port={},errorAutoConnect={},reconnectInterval={},baud={},parity={},dataBits={},stopBits={}]", new Object[]{serialPortConfig.getAlias(), serialPortConfig.getPort(), serialPortConfig.isErrorAutoConnect(), serialPortConfig.getReconnectInterval(), serialPortConfig.getBaud(), serialPortConfig.getParity(), serialPortConfig.getDataBits(), serialPortConfig.getStopBits()});
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SerialContextImpl.class);
            builder.addConstructorArgValue((Object)serialPortConfig);
            beanDefinitionRegistry.registerBeanDefinition(beanName + "." + SerialContext.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
            log.info("Register SerialContextImpl [beanName={}] of {} ", (Object)(beanName + "." + SerialContext.class.getSimpleName()), (Object)serialPortConfig.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

