/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.rxtx.starter;

import cn.qqhxj.rxtx.context.SerialContext;
import cn.qqhxj.rxtx.context.SerialContextImpl;
import cn.qqhxj.rxtx.event.SerialContextEventListener;
import cn.qqhxj.rxtx.parse.SerialDataParser;
import cn.qqhxj.rxtx.processor.SerialByteDataProcessor;
import cn.qqhxj.rxtx.processor.SerialDataProcessor;
import cn.qqhxj.rxtx.reader.AnyDataReader;
import cn.qqhxj.rxtx.reader.SerialReader;
import cn.qqhxj.rxtx.starter.SerialPortProperties;
import cn.qqhxj.rxtx.starter.annotation.SerialPortBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

@Configuration
@EnableConfigurationProperties(value={SerialPortProperties.class})
public class SerialContentInitConfigBean
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SerialContentInitConfigBean.class);
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private SerialPortProperties serialPortProperties;

    public void afterPropertiesSet() throws Exception {
        Map stringSerialContextMap = this.applicationContext.getBeansOfType(SerialContext.class);
        Map baseSerialReaderMap = this.applicationContext.getBeansOfType(SerialReader.class);
        Map serialDataParserMap = this.applicationContext.getBeansOfType(SerialDataParser.class);
        Map serialDataProcessorMap = this.applicationContext.getBeansOfType(SerialDataProcessor.class);
        Map serialByteDataProcessorMap = this.applicationContext.getBeansOfType(SerialByteDataProcessor.class);
        Map serialContextEventListenerMap = this.applicationContext.getBeansOfType(SerialContextEventListener.class);
        baseSerialReaderMap.forEach((key, value) -> {
            if (value.setSerialContext() == null) {
                Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
                for (SerialContext serialContext : serialContexts) {
                    serialContext.setSerialReader(value);
                }
            }
        });
        serialDataParserMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.addSerialDataParser(value);
            }
        });
        serialDataProcessorMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.addSerialDataProcessor(value);
            }
        });
        serialByteDataProcessorMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.setSerialByteDataProcessor(value);
            }
        });
        HashMap hashMap = new HashMap();
        serialContextEventListenerMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                hashMap.put(serialContext, value);
            }
        });
        for (SerialContext serialContext : stringSerialContextMap.values()) {
            if (serialContext.getSerialReader() == null) {
                serialContext.setSerialReader((SerialReader)new AnyDataReader());
            }
            SerialContextEventListener serialContextEventListener = (SerialContextEventListener)hashMap.get(serialContext);
            serialContext.setSerialContextEventListener(serialContextEventListener);
            if (!this.serialPortProperties.isAutoConnect()) continue;
            SerialContextImpl.EVENT_EXECUTOR.schedule(() -> ((SerialContext)serialContext).connect(), this.serialPortProperties.getAutoConnectDelay(), TimeUnit.MILLISECONDS);
        }
        SerialContextImpl.READ_TIME_OUT = this.serialPortProperties.getReadTimeOut();
    }

    public Collection<SerialContext> filterSerialContext(Map<String, SerialContext> serialContextMap, String beanName) {
        BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            MethodMetadata factoryMethodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            if (factoryMethodMetadata != null) {
                return this.getSerialContextListByAnnotatedMetadata((AnnotatedTypeMetadata)factoryMethodMetadata, serialContextMap, serialContextMap.values());
            }
            AnnotationMetadata metadata = annotatedBeanDefinition.getMetadata();
            return this.getSerialContextListByAnnotatedMetadata((AnnotatedTypeMetadata)metadata, serialContextMap, serialContextMap.values());
        }
        return serialContextMap.values();
    }

    private Collection<SerialContext> getSerialContextListByAnnotatedMetadata(AnnotatedTypeMetadata annotatedTypeMetadata, Map<String, SerialContext> serialContextMap, Collection<SerialContext> allSerialContextList) {
        Map defaultAttrs = annotatedTypeMetadata.getAnnotationAttributes(SerialPortBinder.class.getName(), false);
        if (defaultAttrs != null && defaultAttrs.containsKey("value")) {
            ArrayList<SerialContext> serialContextArrayList = new ArrayList<SerialContext>();
            String name = String.valueOf(defaultAttrs.get("value"));
            SerialContext serialContext = serialContextMap.get(name + "." + SerialContext.class.getSimpleName());
            if (serialContext != null) {
                serialContextArrayList.add(serialContext);
            }
            return serialContextArrayList;
        }
        return allSerialContextList;
    }
}

