/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.rxtx.starter;

import cn.qqhxj.rxtx.HexUtil;
import cn.qqhxj.rxtx.context.SerialPortConfig;
import cn.qqhxj.rxtx.processor.SerialByteDataProcessor;
import cn.qqhxj.rxtx.starter.SerialPortProperties;
import cn.qqhxj.rxtx.starter.SerialPortRegistrar;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={SerialPortProperties.class})
@Order(value=-2147483648)
public class SerialAutoConfig
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SerialAutoConfig.class);
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private SerialPortProperties serialPortProperties;

    @PostConstruct
    public void init() {
        log.info("serialPortProperties={}", (Object)this.serialPortProperties);
        List<SerialPortConfig> configList = this.serialPortProperties.getConfig();
        if (configList != null) {
            configList.forEach(config -> {
                try {
                    if (StringUtils.isEmpty((Object)config.getAlias())) {
                        config.setAlias(config.getPort());
                    }
                    SerialPortRegistrar.registerSerialContextBean((BeanDefinitionRegistry)this.applicationContext, config, config.getAlias());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.warn("serial port is not configured");
                }
            });
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SerialByteDataProcessor serialByteDataProcessor() {
        return (bytes, content) -> log.debug("[{}] Received Data:{}", (Object)content.getSerialPortConfig().getAlias(), (Object)HexUtil.bytesToHexString((byte[])bytes));
    }
}

