/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.rxtx.starter;

import cn.qqhxj.rxtx.SerialContext;
import cn.qqhxj.rxtx.event.DefaultSerialDataListener;
import cn.qqhxj.rxtx.parse.SerialDataParser;
import cn.qqhxj.rxtx.processor.SerialByteDataProcessor;
import cn.qqhxj.rxtx.processor.SerialDataProcessor;
import cn.qqhxj.rxtx.reader.AnyDataReader;
import cn.qqhxj.rxtx.reader.BaseSerialReader;
import cn.qqhxj.rxtx.starter.SerialPortProperties;
import cn.qqhxj.rxtx.starter.SerialPortRegistrar;
import cn.qqhxj.rxtx.starter.annotation.SerialPortBinder;
import gnu.io.SerialPortEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;

public class SerialContentBuilder
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SerialContentBuilder.class);
    @Autowired
    private GenericApplicationContext applicationContext;
    @Autowired
    private SerialPortProperties serialPortProperties;

    public void afterPropertiesSet() throws Exception {
        List<SerialPortProperties.SerialPortConfig> configList = this.serialPortProperties.getConfig();
        if (configList != null) {
            configList.forEach(config -> {
                try {
                    SerialPortRegistrar.registerSerialContextBean((BeanDefinitionRegistry)this.applicationContext, config, config.getPortName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.warn("serial port is not configured");
                }
            });
        }
        Map stringSerialContextMap = this.applicationContext.getBeansOfType(SerialContext.class);
        Map baseSerialReaderMap = this.applicationContext.getBeansOfType(BaseSerialReader.class);
        Map serialDataParserMap = this.applicationContext.getBeansOfType(SerialDataParser.class);
        Map serialDataProcessorMap = this.applicationContext.getBeansOfType(SerialDataProcessor.class);
        Map serialByteDataProcessorMap = this.applicationContext.getBeansOfType(SerialByteDataProcessor.class);
        baseSerialReaderMap.forEach((key, value) -> {
            if (value.getSerialPort() == null) {
                Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
                for (SerialContext serialContext : serialContexts) {
                    serialContext.setSerialReader(value);
                }
            }
        });
        serialDataParserMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.addSerialDataParser(value);
            }
        });
        serialDataProcessorMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.addSerialDataProcessor(value);
            }
        });
        serialByteDataProcessorMap.forEach((key, value) -> {
            Collection<SerialContext> serialContexts = this.filterSerialContext(stringSerialContextMap, (String)key);
            for (SerialContext serialContext : serialContexts) {
                serialContext.setSerialByteDataProcessor(value);
            }
        });
        for (SerialContext serialContext : stringSerialContextMap.values()) {
            serialContext.setSerialPortEventListener((SerialPortEventListener)new DefaultSerialDataListener(serialContext));
            if (serialContext.getSerialReader() != null) continue;
            serialContext.setSerialReader((BaseSerialReader)new AnyDataReader());
        }
    }

    public Collection<SerialContext> filterSerialContext(Map<String, SerialContext> serialContextMap, String beanName) {
        BeanDefinition beanDefinition = this.applicationContext.getBeanFactory().getBeanDefinition(beanName);
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            MethodMetadata factoryMethodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            if (factoryMethodMetadata != null) {
                Map defaultAttrs = factoryMethodMetadata.getAnnotationAttributes(SerialPortBinder.class.getName(), false);
                if (defaultAttrs != null && defaultAttrs.containsKey("value")) {
                    ArrayList<SerialContext> serialContextArrayList = new ArrayList<SerialContext>();
                    String name = String.valueOf(defaultAttrs.get("value"));
                    SerialContext serialContext = serialContextMap.get(name + "." + SerialContext.class.getSimpleName());
                    if (serialContext != null) {
                        serialContextArrayList.add(serialContext);
                    }
                    return serialContextArrayList;
                }
            } else {
                AnnotationMetadata metadata = annotatedBeanDefinition.getMetadata();
                Map defaultAttrs = metadata.getAnnotationAttributes(SerialPortBinder.class.getName(), false);
                if (defaultAttrs != null && defaultAttrs.containsKey("value")) {
                    ArrayList<SerialContext> serialContextArrayList = new ArrayList<SerialContext>();
                    String name = String.valueOf(defaultAttrs.get("value"));
                    SerialContext serialContext = serialContextMap.get(name + "." + SerialContext.class.getSimpleName());
                    if (serialContext != null) {
                        serialContextArrayList.add(serialContext);
                    }
                    return serialContextArrayList;
                }
            }
        }
        return serialContextMap.values();
    }
}

