/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.rxtx.starter;

import cn.qqhxj.rxtx.SerialContext;
import cn.qqhxj.rxtx.SerialUtils;
import cn.qqhxj.rxtx.starter.SerialPortProperties;
import cn.qqhxj.rxtx.starter.annotation.EnableSerialPorts;
import gnu.io.SerialPort;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;

@Order(value=-2147483648)
public class SerialPortRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(SerialPortRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(EnableSerialPorts.class.getName(), false);
        Object value = annotationAttributes.get("value");
        if (value != null && value instanceof AnnotationAttributes[]) {
            for (AnnotationAttributes attributes : (AnnotationAttributes[])value) {
                SerialPortProperties.SerialPortConfig serialPortConfig = new SerialPortProperties.SerialPortConfig();
                String beanName = String.valueOf(attributes.get((Object)"value"));
                attributes.remove((Object)"value");
                attributes.forEach((k, v) -> {
                    try {
                        Field field = SerialPortProperties.SerialPortConfig.class.getDeclaredField((String)k);
                        field.setAccessible(true);
                        field.set(serialPortConfig, v);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                SerialPortRegistrar.registerSerialContextBean(beanDefinitionRegistry, serialPortConfig, beanName);
                log.info("start SerialPortRegistrar {}", (Object)serialPortConfig.getPortName());
            }
        }
    }

    public static void registerSerialContextBean(BeanDefinitionRegistry beanDefinitionRegistry, SerialPortProperties.SerialPortConfig serialPortConfig, String beanName) {
        try {
            SerialPort serialPort = SerialUtils.connect((String)serialPortConfig.getPortName(), (int)serialPortConfig.getBaudRate(), (int)serialPortConfig.getDataBits(), (int)serialPortConfig.getStopBits(), (int)serialPortConfig.getParity());
            log.debug("configured SerialPortConfig = {}", (Object)serialPort);
            log.debug("SerialPortConfig parameter  portName = {},baudRate={}, dataBits={},stopBits ={},parity={}", new Object[]{serialPortConfig.getPortName(), serialPortConfig.getBaudRate(), serialPortConfig.getDataBits(), serialPortConfig.getStopBits(), serialPortConfig.getParity()});
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SerialContext.class);
            builder.addConstructorArgValue((Object)serialPort);
            beanDefinitionRegistry.registerBeanDefinition(beanName + "." + SerialContext.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
            log.info("register SerialContext [beanName={}] of {} ", (Object)(beanName + "." + SerialContext.class.getSimpleName()), (Object)serialPortConfig.getPortName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

