/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx.starter;

import cn.qqhxj.common.rxtx.SerialContext;
import cn.qqhxj.common.rxtx.SerialUtils;
import cn.qqhxj.common.rxtx.parse.SerialDataParser;
import cn.qqhxj.common.rxtx.processor.SerialByteDataProcessor;
import cn.qqhxj.common.rxtx.processor.SerialDataProcessor;
import cn.qqhxj.common.rxtx.reader.SerialReader;
import cn.qqhxj.common.rxtx.starter.SerialPortProperties;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class SerialContentBuilder
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SerialContentBuilder.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SerialPortEventListener serialPortEventListener;
    @Autowired
    private SerialPortProperties serialPortProperties;

    public void afterPropertiesSet() throws Exception {
        SerialPort serialPort = null;
        try {
            serialPort = SerialUtils.connect((String)this.serialPortProperties.getPortName(), (int)this.serialPortProperties.getBaudRate());
            log.debug("configured SerialPort = {}", (Object)serialPort);
            SerialContext.setSerialPort((SerialPort)serialPort);
        }
        catch (Exception e) {
            log.warn("serial port is not configured");
        }
        SerialContext.setSerialPortEventListener((SerialPortEventListener)this.serialPortEventListener);
        Collection serialDataParsers = this.applicationContext.getBeansOfType(SerialDataParser.class).values();
        for (SerialDataParser serialDataParser : serialDataParsers) {
            log.debug("configured serialDataParser = {}", (Object)serialDataParser);
        }
        SerialContext.getSerialDataParserSet().addAll(serialDataParsers);
        Collection serialDataProcessors = this.applicationContext.getBeansOfType(SerialDataProcessor.class).values();
        for (SerialDataProcessor serialDataProcessor : serialDataProcessors) {
            log.debug("configured serialDataProcessor = {}", (Object)serialDataProcessor);
        }
        SerialContext.getSerialDataProcessorSet().addAll(serialDataProcessors);
        SerialContext.setSerialReader((SerialReader)((SerialReader)this.applicationContext.getBean(SerialReader.class)));
        SerialContext.setSerialByteDataProcessor((SerialByteDataProcessor)((SerialByteDataProcessor)this.applicationContext.getBean(SerialByteDataProcessor.class)));
    }
}

