/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx.starter;

import cn.qqhxj.common.rxtx.DefaultSerialDataListener;
import cn.qqhxj.common.rxtx.parse.StringSerialDataParser;
import cn.qqhxj.common.rxtx.processor.SerialByteDataProcessor;
import cn.qqhxj.common.rxtx.reader.SerialReader;
import cn.qqhxj.common.rxtx.reader.VariableLengthSerialReader;
import cn.qqhxj.common.rxtx.starter.SerialContentBuilder;
import cn.qqhxj.common.rxtx.starter.SerialPortProperties;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SerialPortProperties.class})
@ConditionalOnClass(value={SerialPort.class})
public class SerialAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(SerialAutoConfig.class);
    @Autowired
    private SerialPortProperties serialPortProperties;

    @Bean
    @ConditionalOnMissingBean
    public SerialPortEventListener serialPortEventListener() {
        DefaultSerialDataListener dataListener = new DefaultSerialDataListener();
        log.debug("config SerialPortEventListener = {}", (Object)dataListener);
        return dataListener;
    }

    @Bean
    @ConditionalOnMissingBean
    public SerialReader serialReader() {
        VariableLengthSerialReader serialReader = null;
        serialReader = new VariableLengthSerialReader('{', '}');
        log.debug("config SerialReader ={}", (Object)serialReader);
        return serialReader;
    }

    @Bean
    @ConditionalOnMissingBean
    public SerialByteDataProcessor serialByteDataProcesser() {
        return new SerialByteDataProcessor(){

            public void process(byte[] bytes) {
                log.debug("Received Data:{}", (Object)this.bytesToHexString(bytes));
            }

            public String bytesToHexString(byte[] bArr) {
                StringBuffer sb = new StringBuffer(bArr.length);
                for (int i = 0; i < bArr.length; ++i) {
                    String sTmp = Integer.toHexString(0xFF & bArr[i]);
                    if (sTmp.length() < 2) {
                        sb.append(0);
                    }
                    sb.append(sTmp.toUpperCase() + "  ");
                }
                return sb.toString();
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public StringSerialDataParser stringSerialDataParser() {
        return new StringSerialDataParser();
    }

    @Bean
    public SerialContentBuilder serialContentBuilder() {
        return new SerialContentBuilder();
    }
}

