/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx.reader;

import cn.qqhxj.common.rxtx.SerialContext;
import cn.qqhxj.common.rxtx.reader.SerialReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class VariableLengthSerialReader
implements SerialReader {
    ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
    private char startChar = (char)123;
    private char endChar = (char)125;
    private boolean haveNext = false;

    public VariableLengthSerialReader(char startChar, char endChar) {
        this.startChar = startChar;
        this.endChar = endChar;
    }

    @Override
    public String readString() {
        byte[] bytes = this.readBytes();
        if (bytes != null && bytes.length > 0) {
            return new String(bytes);
        }
        return null;
    }

    @Override
    public byte[] readBytes() {
        char ch = '\u0000';
        while (ch != '\uffffffff') {
            try {
                ch = SerialContext.getSerialPort().getInputStream().read();
                if (ch == this.startChar) {
                    this.byteBuffer.put((byte)ch);
                    this.haveNext = true;
                    continue;
                }
                if (ch == this.endChar) {
                    this.byteBuffer.put((byte)ch);
                    this.haveNext = false;
                    break;
                }
                if (!this.haveNext) continue;
                this.byteBuffer.put((byte)ch);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.byteBuffer.position() != 0) {
            byte[] array = Arrays.copyOf(this.byteBuffer.array(), this.byteBuffer.position());
            this.byteBuffer = ByteBuffer.allocate(1024);
            return array;
        }
        return null;
    }
}

