/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.util.ArrayList;
import java.util.Enumeration;

public class SerialUtils {
    public static ArrayList<String> getCommNames() {
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        while (portIdentifiers.hasMoreElements()) {
            list.add(((CommPortIdentifier)portIdentifiers.nextElement()).getName());
        }
        return list.isEmpty() ? null : list;
    }

    public static SerialPort connect(String portName, int baudRate, int dataBits, int stopBits, int parity) throws Exception {
        System.out.println(portName + "  " + baudRate + " " + dataBits + " " + stopBits + " " + parity);
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.err.println("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(SerialUtils.class.getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
                return (SerialPort)commPort;
            }
            System.err.println("Error: Only serial ports are handled by this example.");
        }
        return null;
    }

    public static SerialPort connect(String portName, int baudRate) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.err.println("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(SerialUtils.class.getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(baudRate, 8, 1, 0);
                return (SerialPort)commPort;
            }
            System.err.println("Error: Only serial ports are handled by this example.");
        }
        return null;
    }
}

