/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx;

import cn.qqhxj.common.rxtx.SerialContext;
import cn.qqhxj.common.rxtx.parse.SerialDataParser;
import cn.qqhxj.common.rxtx.processor.SerialByteDataProcesser;
import cn.qqhxj.common.rxtx.processor.SerialDataProcessor;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class DefaultSerialDataListener
implements SerialPortEventListener {
    public void serialEvent(SerialPortEvent ev) {
        if (ev.getEventType() == 1) {
            SerialByteDataProcesser processer;
            Set<SerialDataParser> parserSet = SerialContext.getSerialDataParserSet();
            byte[] bytes = SerialContext.readData();
            if (bytes == null) {
                return;
            }
            Object parse = null;
            for (SerialDataParser serialDataParser : parserSet) {
                parse = serialDataParser.parse(bytes);
                if (parse == null) continue;
                this.dataProcessors(parse);
            }
            if (bytes != null && bytes.length > 0 && (processer = SerialContext.getSerialByteDataProcesser()) != null) {
                processer.processer(bytes);
            }
        } else {
            System.err.println("data parse err or not find parser");
        }
    }

    private void dataProcessors(Object obj) {
        Set<SerialDataProcessor> dataProcessors = SerialContext.getSerialDataProcessorSet();
        for (SerialDataProcessor serialDataProcessor : dataProcessors) {
            Type[] types = null;
            Class<?> cl = serialDataProcessor.getClass();
            Class<?> c2 = cl.getSuperclass();
            while (!c2.equals(Object.class)) {
                cl = cl.getSuperclass();
                c2 = cl.getSuperclass();
            }
            for (Type type : types = cl.getGenericInterfaces()) {
                boolean equals;
                ParameterizedType parameterizedType;
                Type rawType;
                if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) || !(equals = rawType.equals(SerialDataProcessor.class))) continue;
                String typeName = ((ParameterizedType)type).getActualTypeArguments()[0].getTypeName();
                try {
                    Class<?> forName = Class.forName(typeName);
                    if (forName != obj.getClass()) continue;
                    serialDataProcessor.processor(obj);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

