/*
 * Decompiled with CFR 0.152.
 */
package cn.qqhxj.common.rxtx.reader;

import cn.qqhxj.common.rxtx.SerialContext;
import cn.qqhxj.common.rxtx.reader.SerialReader;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LiveControlSerialReader
implements SerialReader {
    private byte[] startChat;
    private int flagIndex;
    private int dataLengthIndex;
    private int allLength = 0;
    private int length;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
    private boolean notOver = false;

    public LiveControlSerialReader(int flagIndex, int dataLengthIndex, byte ... startChat) {
        this.startChat = startChat;
        this.flagIndex = flagIndex;
        this.dataLengthIndex = dataLengthIndex;
    }

    @Override
    public String readString() {
        byte[] bytes = this.readBytes();
        if (bytes != null && bytes.length > 0) {
            return new String(bytes);
        }
        return null;
    }

    @Override
    public byte[] readBytes() {
        try {
            byte read = (byte)SerialContext.getSerialPort().getInputStream().read();
            int index = Arrays.binarySearch(this.startChat, read);
            if (index >= 0) {
                this.byteBuffer.put(read);
                this.allLength = 1;
                this.notOver = true;
            } else if (this.notOver) {
                if (this.allLength == this.dataLengthIndex) {
                    this.length = read;
                }
                ++this.allLength;
                this.byteBuffer.put(read);
                if (this.allLength == this.flagIndex + this.length) {
                    this.notOver = false;
                    byte[] array = Arrays.copyOf(this.byteBuffer.array(), this.byteBuffer.position());
                    this.byteBuffer = ByteBuffer.allocate(1024);
                    this.allLength = 0;
                    return array;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

