/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.v3;

import cn.hutool.json.JSONUtil;
import cn.qmso.wxPay.base.Pay;
import cn.qmso.wxPay.v3.pojo.only.bo.transfer.TransferBo;
import cn.qmso.wxPay.v3.pojo.only.bo.transfer.TransferDetailBo;
import cn.qmso.wxPay.v3.pojo.only.bo.transfer.batches.BatchesBo;
import cn.qmso.wxPay.v3.pojo.only.vo.transfer.TransferVo;
import cn.qmso.wxPay.v3.pojo.only.vo.transfer.batches.BatchesVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.cert.Certificate;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxTransferV3Util
extends Pay {
    private static final Logger log = LoggerFactory.getLogger(WxTransferV3Util.class);

    public static BatchesVo selectTransfer(BatchesBo batchesBo, String batchId, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxTransferV3Util.getRequest("https://api.mch.weixin.qq.com/", String.format("v3/transfer/batches/batch-id/%s", batchId), batchesBo, mchid, serial_no, privateKeyFilePath);
        BatchesVo batchesVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            batchesVo = (BatchesVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<BatchesVo>(){});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return batchesVo;
    }

    public static TransferVo transfer(TransferBo transferBo, String mchid, String serial_no, String privateKeyFilePath, String v3Key) throws Exception {
        Map<String, Certificate> mapCertificate = WxTransferV3Util.getCertificate("https://api.mch.weixin.qq.com/", "v3/certificates", mchid, serial_no, privateKeyFilePath, v3Key);
        String platformSerialNo = null;
        Certificate certificate = null;
        for (Map.Entry<String, Certificate> stringCertificateEntry : mapCertificate.entrySet()) {
            platformSerialNo = stringCertificateEntry.getKey();
            certificate = stringCertificateEntry.getValue();
        }
        for (TransferDetailBo transferDetailBo : transferBo.getTransfer_detail_list()) {
            if (!StringUtils.isNotEmpty((CharSequence)transferDetailBo.getUser_name())) continue;
            assert (certificate != null);
            String encryptOAEP = WxTransferV3Util.rsaEncryptOAEP(transferDetailBo.getUser_name(), certificate.getPublicKey());
            transferDetailBo.setUser_name(encryptOAEP);
        }
        Object body = WxTransferV3Util.postRequest("https://api.mch.weixin.qq.com/", "v3/transfer/batches", mchid, serial_no, platformSerialNo, privateKeyFilePath, JSONUtil.toJsonStr((Object)transferBo));
        TransferVo transferVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            transferVo = (TransferVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<TransferVo>(){});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (transferVo == null) {
            transferVo = new TransferVo();
            transferVo.setMessage(JSONObject.fromObject((Object)body).getString("message"));
        }
        return transferVo;
    }
}

