/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.v3;

import cn.hutool.json.JSONUtil;
import cn.qmso.wxPay.base.Pay;
import cn.qmso.wxPay.v3.pojo.only.bo.placeorder.WxPayRequestBo;
import cn.qmso.wxPay.v3.pojo.only.bo.refund.RefundBo;
import cn.qmso.wxPay.v3.pojo.only.vo.apply.fundbill.FundBillVo;
import cn.qmso.wxPay.v3.pojo.only.vo.apply.transactionbill.TransactionBillVo;
import cn.qmso.wxPay.v3.pojo.only.vo.initiatepayment.WxPayResult;
import cn.qmso.wxPay.v3.pojo.only.vo.notify.NotifyVo;
import cn.qmso.wxPay.v3.pojo.only.vo.refund.RefundVo;
import cn.qmso.wxPay.v3.pojo.only.vo.refundnotify.RefundOrderNotifyVo;
import cn.qmso.wxPay.v3.pojo.only.vo.selectorder.SelectOrderVo;
import cn.qmso.wxPay.v3.pojo.only.vo.selectrefund.SelectRefundVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayV3Util
extends Pay {
    private static final Logger logger = LoggerFactory.getLogger(WxPayV3Util.class);

    public static String v3PayGet(String url, WxPayRequestBo wxPayRequestBo, String mercId, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.postRequest("https://api.mch.weixin.qq.com/", url, mercId, serial_no, null, privateKeyFilePath, JSONUtil.toJsonStr((Object)wxPayRequestBo));
        switch (url) {
            case "v3/pay/transactions/app": 
            case "v3/pay/transactions/jsapi": {
                return JSONObject.fromObject((Object)body).getString("prepay_id");
            }
            case "v3/pay/transactions/native": {
                return JSONObject.fromObject((Object)body).getString("code_url");
            }
            case "v3/pay/transactions/h5": {
                return JSONObject.fromObject((Object)body).getString("h5_url");
            }
        }
        return null;
    }

    public static WxPayResult wxTuneUp(String prepayId, String appId, String privateKeyFilePath) throws Exception {
        String time = System.currentTimeMillis() / 1000L + "";
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        String packageStr = "prepay_id=" + prepayId;
        ArrayList<String> list = new ArrayList<String>();
        list.add(appId);
        list.add(time);
        list.add(nonceStr);
        list.add(packageStr);
        String packageSign = WxPayV3Util.sign(WxPayV3Util.buildSignMessage(list).getBytes(), privateKeyFilePath);
        WxPayResult wxPayResult = new WxPayResult(appId, time, nonceStr, packageStr, "RSA", packageSign);
        return wxPayResult;
    }

    public static NotifyVo notify(HttpServletRequest request, HttpServletResponse response, String privateKey) throws Exception {
        String result = WxPayV3Util.readData(request);
        String plainText = WxPayV3Util.verifyNotify(result, privateKey);
        WxPayV3Util.sendMessage(response, plainText);
        NotifyVo notifyVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            notifyVo = (NotifyVo)mapper.readValue(plainText, (TypeReference)new TypeReference<NotifyVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return notifyVo;
    }

    public static SelectOrderVo selectOrder(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.getRequest("https://api.mch.weixin.qq.com/", url, null, mchid, serial_no, privateKeyFilePath);
        SelectOrderVo selectOrderVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            selectOrderVo = (SelectOrderVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<SelectOrderVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return selectOrderVo;
    }

    public static String closeOrder(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"mchid", (Object)mchid);
        Object body = WxPayV3Util.postRequest("https://api.mch.weixin.qq.com/", url, mchid, serial_no, null, privateKeyFilePath, jsonObject.toString());
        return body.toString();
    }

    public static RefundVo refundOrder(String url, String mchid, String serial_no, RefundBo refundBo, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.postRequest("https://api.mch.weixin.qq.com/", url, mchid, serial_no, null, privateKeyFilePath, JSONUtil.toJsonStr((Object)refundBo));
        RefundVo refundVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            refundVo = (RefundVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<RefundVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return refundVo;
    }

    public static RefundOrderNotifyVo refundOrderNotify(HttpServletRequest request, HttpServletResponse response, String privateKey) throws Exception {
        String result = WxPayV3Util.readData(request);
        String plainText = WxPayV3Util.verifyNotify(result, privateKey);
        WxPayV3Util.sendMessage(response, plainText);
        RefundOrderNotifyVo refundOrderNotifyVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            refundOrderNotifyVo = (RefundOrderNotifyVo)mapper.readValue(plainText, (TypeReference)new TypeReference<RefundOrderNotifyVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return refundOrderNotifyVo;
    }

    public static SelectRefundVo selectRefundOrder(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.getRequest("https://api.mch.weixin.qq.com/", url, null, mchid, serial_no, privateKeyFilePath);
        SelectRefundVo selectRefundVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            selectRefundVo = (SelectRefundVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<SelectRefundVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return selectRefundVo;
    }

    public static TransactionBillVo applyTransactionBill(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.getRequest("https://api.mch.weixin.qq.com/", url, null, mchid, serial_no, privateKeyFilePath);
        TransactionBillVo transactionBillVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            transactionBillVo = (TransactionBillVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<TransactionBillVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return transactionBillVo;
    }

    public static FundBillVo applyFundBill(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxPayV3Util.getRequest("https://api.mch.weixin.qq.com/", url, null, mchid, serial_no, privateKeyFilePath);
        FundBillVo fundBillVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            fundBillVo = (FundBillVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<FundBillVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return fundBillVo;
    }
}

