/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.v3;

import cn.hutool.json.JSONUtil;
import cn.qmso.wxPay.base.Pay;
import cn.qmso.wxPay.v2.pojo.only.close.CloseOrderBo;
import cn.qmso.wxPay.v3.pojo.combined.bo.placeorder.CombinedPayBo;
import cn.qmso.wxPay.v3.pojo.combined.vo.notify.CombinedNotfyVo;
import cn.qmso.wxPay.v3.pojo.combined.vo.selectorder.SelectComBinedOrderVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCombinedPayV3Util
extends Pay {
    private static final Logger logger = LoggerFactory.getLogger(WxCombinedPayV3Util.class);

    public static String v3CombinedPayGet(String url, CombinedPayBo combinedPayBo, String mchId, String serialNo, String privateKeyFilePath) throws Exception {
        Object body = WxCombinedPayV3Util.postRequest("https://api.mch.weixin.qq.com/", url, mchId, serialNo, null, privateKeyFilePath, JSONUtil.toJsonStr((Object)combinedPayBo));
        switch (url) {
            case "v3/combine-transactions/app": 
            case "v3/combine-transactions/jsapi": {
                return JSONObject.fromObject((Object)body).getString("prepay_id");
            }
            case "v3/combine-transactions/native": {
                return JSONObject.fromObject((Object)body).getString("code_url");
            }
            case "v3/combine-transactions/h5": {
                return JSONObject.fromObject((Object)body).getString("h5_url");
            }
        }
        return null;
    }

    public static CombinedNotfyVo notify(HttpServletRequest request, HttpServletResponse response, String privateKey) throws Exception {
        String result = WxCombinedPayV3Util.readData(request);
        String plainText = WxCombinedPayV3Util.verifyNotify(result, privateKey);
        WxCombinedPayV3Util.sendMessage(response, plainText);
        CombinedNotfyVo combinedNotfyVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            combinedNotfyVo = (CombinedNotfyVo)mapper.readValue(plainText, (TypeReference)new TypeReference<CombinedNotfyVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return combinedNotfyVo;
    }

    public static SelectComBinedOrderVo selectOrder(String url, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        Object body = WxCombinedPayV3Util.getRequest("https://api.mch.weixin.qq.com/", url, null, mchid, serial_no, privateKeyFilePath);
        SelectComBinedOrderVo selectComBinedOrderVo = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            selectComBinedOrderVo = (SelectComBinedOrderVo)mapper.readValue(body.toString(), (TypeReference)new TypeReference<SelectComBinedOrderVo>(){});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return selectComBinedOrderVo;
    }

    public static String closeCombinedOrder(String url, String mchid, String serial_no, String privateKeyFilePath, CloseOrderBo closeOrderBo) throws Exception {
        Object body = WxCombinedPayV3Util.postRequest("https://api.mch.weixin.qq.com/", url, mchid, serial_no, null, privateKeyFilePath, JSONUtil.toJsonStr((Object)closeOrderBo));
        return body.toString();
    }
}

