/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.v2;

import cn.hutool.json.JSONUtil;
import cn.qmso.wxPay.base.PayV2;
import cn.qmso.wxPay.base.WxPayUtil;
import cn.qmso.wxPay.v2.config.WxPayV2Config;
import cn.qmso.wxPay.v2.pojo.only.close.CloseOrderBo;
import cn.qmso.wxPay.v2.pojo.only.placeorder.PlaceOrderBo;
import cn.qmso.wxPay.v2.pojo.only.placeorder.SceneInfo;
import cn.qmso.wxPay.v2.pojo.only.refund.RefundOrderBo;
import cn.qmso.wxPay.v2.pojo.only.refund.select.SelectRefundOrderBo;
import cn.qmso.wxPay.v2.pojo.only.select.SelectOrderBo;
import cn.qmso.wxPay.v3.pojo.only.vo.initiatepayment.WxPayResult;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxPayV2
extends PayV2 {
    @Autowired
    private WxPayV2Config defaultWxPayV2Config;

    public String placeOrder(PlaceOrderBo placeOrderBo, SceneInfo sceneInfo) throws Exception {
        return this.placeOrder(placeOrderBo, sceneInfo, this.defaultWxPayV2Config);
    }

    public String placeOrder(PlaceOrderBo placeOrderBo, SceneInfo sceneInfo, WxPayV2Config wxPayV2Config) throws Exception {
        if (wxPayV2Config == null) {
            wxPayV2Config = this.defaultWxPayV2Config;
        }
        Map<String, String> map = WxPayUtil.objectToMap(placeOrderBo);
        map.put("total_fee", placeOrderBo.getTotal_fee() + "");
        map.put("appid", wxPayV2Config.getAppid());
        map.put("mch_id", wxPayV2Config.getMch_id());
        map.put("nonce_str", WxPayUtil.generateNonceStr());
        map.put("sign_type", wxPayV2Config.getSign_type());
        if (sceneInfo != null) {
            map.put("scene_info", JSONUtil.toJsonStr((Object)sceneInfo));
        }
        String signedXml = WxPayV2.generateSignedXml(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        Map<String, String> stringStringMap = WxPayV2.notCarryCertificateRequestPost(wxPayV2Config.getMch_id(), "https://api.mch.weixin.qq.com/pay/unifiedorder", signedXml);
        if ("SUCCESS".equals(stringStringMap.get("return_code"))) {
            switch (placeOrderBo.getTrade_type()) {
                case "JSAPI": 
                case "APP": {
                    return stringStringMap.get("prepay_id");
                }
                case "NATIVE": {
                    return stringStringMap.get("code_url");
                }
                case "MWEB": {
                    return stringStringMap.get("h5_url");
                }
            }
            return null;
        }
        return stringStringMap.toString();
    }

    public WxPayResult wxTuneUp(String prepayId) throws Exception {
        return this.wxTuneUp(prepayId, this.defaultWxPayV2Config);
    }

    public WxPayResult wxTuneUp(String prepayId, WxPayV2Config wxPayV2Config) throws Exception {
        if (wxPayV2Config == null) {
            wxPayV2Config = this.defaultWxPayV2Config;
        }
        String time = System.currentTimeMillis() / 1000L + "";
        String nonceStr = WxPayUtil.generateNonceStr();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", wxPayV2Config.getAppid());
        map.put("nonceStr", nonceStr);
        map.put("package", "prepay_id=" + prepayId);
        map.put("signType", wxPayV2Config.getSign_type());
        map.put("timeStamp", time);
        String sign = WxPayV2.generateSignature(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        return new WxPayResult(wxPayV2Config.getAppid(), time, nonceStr, "prepay_id=" + prepayId, wxPayV2Config.getSign_type(), sign);
    }

    public static Map<String, String> notify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String result = WxPayV2.readData(request);
        Map<String, String> stringStringMap = WxPayV2.xmlToMap(result);
        WxPayV2.sendMessage(response, result);
        return stringStringMap;
    }

    public Map<String, String> selectOrder(SelectOrderBo selectOrderBo) throws Exception {
        return this.selectOrder(selectOrderBo, this.defaultWxPayV2Config);
    }

    public Map<String, String> selectOrder(SelectOrderBo selectOrderBo, WxPayV2Config wxPayV2Config) throws Exception {
        if (wxPayV2Config == null) {
            wxPayV2Config = this.defaultWxPayV2Config;
        }
        Map<String, String> map = WxPayUtil.objectToMap(selectOrderBo);
        String signedXml = WxPayV2.generateSignedXml(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        return WxPayV2.notCarryCertificateRequestPost(selectOrderBo.getMch_id(), "https://api.mch.weixin.qq.com/pay/orderquery", signedXml);
    }

    public Map<String, String> closeOrder(CloseOrderBo closeOrderBo) throws Exception {
        return this.closeOrder(closeOrderBo, this.defaultWxPayV2Config);
    }

    public Map<String, String> closeOrder(CloseOrderBo closeOrderBo, WxPayV2Config wxPayV2Config) throws Exception {
        Map<String, String> map = WxPayUtil.objectToMap(closeOrderBo);
        String signedXml = WxPayV2.generateSignedXml(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        return WxPayV2.notCarryCertificateRequestPost(closeOrderBo.getMch_id(), "https://api.mch.weixin.qq.com/pay/closeorder", signedXml);
    }

    public Map<String, String> refundOrder(RefundOrderBo refundOrderBo) throws Exception {
        return this.refundOrder(refundOrderBo, this.defaultWxPayV2Config);
    }

    public Map<String, String> refundOrder(RefundOrderBo refundOrderBo, WxPayV2Config wxPayV2Config) throws Exception {
        if (wxPayV2Config == null) {
            wxPayV2Config = this.defaultWxPayV2Config;
        }
        Map<String, String> map = WxPayUtil.objectToMap(refundOrderBo);
        map.put("appid", wxPayV2Config.getAppid());
        map.put("mch_id", wxPayV2Config.getMch_id());
        map.put("nonce_str", WxPayUtil.generateNonceStr());
        map.put("sign_type", wxPayV2Config.getSign_type());
        String signedXml = WxPayV2.generateSignedXml(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        return WxPayV2.carryCertificateRequestPost(wxPayV2Config.getMch_id(), wxPayV2Config.getCert_path(), "https://api.mch.weixin.qq.com/secapi/pay/refund", signedXml);
    }

    public Map<String, String> selectRefundOrder(SelectRefundOrderBo selectRefundOrderBo) throws Exception {
        return this.selectRefundOrder(selectRefundOrderBo, this.defaultWxPayV2Config);
    }

    public Map<String, String> selectRefundOrder(SelectRefundOrderBo selectRefundOrderBo, WxPayV2Config wxPayV2Config) throws Exception {
        Map<String, String> map = WxPayUtil.objectToMap(selectRefundOrderBo);
        String signedXml = WxPayV2.generateSignedXml(map, wxPayV2Config.getKey(), wxPayV2Config.getSign_type());
        return WxPayV2.notCarryCertificateRequestPost(selectRefundOrderBo.getMch_id(), "https://api.mch.weixin.qq.com/pay/refundquery", signedXml);
    }
}

