/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.base;

import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WxPayUtil {
    public static String generateNonceStr() {
        String symbols = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        SecureRandom random = new SecureRandom();
        char[] nonceChars = new char[32];
        for (int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = symbols.charAt(random.nextInt(symbols.length()));
        }
        return new String(nonceChars);
    }

    public static String generateSignature(Map<String, Object> data, String key, String signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if ("sign".equals(k) || data.get(k) == null) continue;
            sb.append((String)k).append("=").append(data.get(k)).append("&");
        }
        sb.append("key=").append(key);
        if ("MD5".equals(signType)) {
            return WxPayUtil.MD5(sb.toString()).toUpperCase();
        }
        if ("HMACSHA256".equals(signType)) {
            return WxPayUtil.HMACSHA256(sb.toString(), key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", signType));
    }

    public static String MD5(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static Map<String, String> objectToMap(Object object) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (field.get(object) == null) continue;
                dataMap.put(field.getName(), field.get(object).toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return dataMap;
    }
}

