/*
 * Decompiled with CFR 0.152.
 */
package cn.qmso.wxPay.base;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.qmso.wxPay.base.AesUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Pay {
    private static final String charset = "UTF-8";
    private static final Map<String, Certificate> CERTIFICATE_MAP = new ConcurrentHashMap<String, Certificate>();

    protected static String getToken(String method, HttpUrl url, String mercId, String serial_no, String privateKeyFilePath, String body) throws Exception {
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        long timestamp = System.currentTimeMillis() / 1000L;
        String message = Pay.buildMessage(method, url, timestamp, nonceStr, body);
        String signature = Pay.sign(message.getBytes(charset), privateKeyFilePath);
        return "mchid=\"" + mercId + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + serial_no + "\",signature=\"" + signature + "\"";
    }

    protected static String sign(byte[] message, String privateKeyFilePath) throws Exception {
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initSign(Pay.getPrivateKey(privateKeyFilePath));
        sign.update(message);
        return Base64.getEncoder().encodeToString(sign.sign());
    }

    static String buildMessage(String method, HttpUrl url, long timestamp, String nonceStr, String body) {
        String canonicalUrl = url.encodedPath();
        if (url.encodedQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + url.encodedQuery();
        }
        return method + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonceStr + "\n" + body + "\n";
    }

    protected static net.sf.json.JSONObject getCertificates(String url_prex, String url, String mchid, String serial_no, String privateKeyFilePath, String apiV3Key) throws Exception {
        net.sf.json.JSONObject body = null;
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url_prex + url);
        String post = Pay.getToken("GET", HttpUrl.parse((String)(url_prex + url)), mchid, serial_no, privateKeyFilePath, "");
        httpGet.setHeader("Content-type", "application/json");
        httpGet.setHeader("User-Agent", "https://zh.wikipedia.org/wiki/User_agent");
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048 " + post);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = net.sf.json.JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)entity, (String)charset));
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    private static void refreshCertificate(String url_prex, String url, String mchid, String serial_no, String privateKeyFilePath, String apiV3Key) throws Exception {
        net.sf.json.JSONObject certificates = Pay.getCertificates(url_prex, url, mchid, serial_no, privateKeyFilePath, apiV3Key);
        JSONArray data = certificates.getJSONArray("data");
        for (Object datum : data) {
            net.sf.json.JSONObject jsonObject = net.sf.json.JSONObject.fromObject(datum);
            net.sf.json.JSONObject encryptCertificate = jsonObject.getJSONObject("encrypt_certificate");
            String publicKey = Pay.decryptResponseBody(apiV3Key, encryptCertificate.getString("associated_data"), encryptCertificate.getString("nonce"), encryptCertificate.getString("ciphertext"));
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
            Certificate certificate = null;
            try {
                certificate = cf.generateCertificate(inputStream);
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            String responseSerialNo = jsonObject.getString("serial_no");
            CERTIFICATE_MAP.clear();
            CERTIFICATE_MAP.put(responseSerialNo, certificate);
        }
    }

    public static Map<String, Certificate> getCertificate(String url_prex, String url, String mchid, String serial_no, String privateKeyFilePath, String apiV3Key) throws Exception {
        if (CERTIFICATE_MAP.isEmpty()) {
            Pay.refreshCertificate(url_prex, url, mchid, serial_no, privateKeyFilePath, apiV3Key);
        }
        return CERTIFICATE_MAP;
    }

    public static String decryptResponseBody(String apiV3Key, String associatedData, String nonce, String ciphertext) {
        try {
            byte[] bytes;
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec key = new SecretKeySpec(apiV3Key.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            try {
                bytes = cipher.doFinal(Base64.getDecoder().decode(ciphertext));
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String rsaEncryptOAEP(String message, PublicKey publicKey) throws IllegalBlockSizeException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            byte[] data = message.getBytes("utf-8");
            byte[] cipherdata = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(cipherdata);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    static PrivateKey getPrivateKey(String filename) throws IOException {
        String content = new String(Files.readAllBytes(Paths.get(filename, new String[0])), charset);
        try {
            String privateKey = content.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
    }

    protected static String buildSignMessage(ArrayList<String> signMessage) {
        if (signMessage == null || signMessage.size() <= 0) {
            return null;
        }
        StringBuilder sbf = new StringBuilder();
        for (String str : signMessage) {
            sbf.append(str).append("\n");
        }
        return sbf.toString();
    }

    protected static String verifyNotify(String body, String key) throws Exception {
        JSONObject resultObject = JSONUtil.parseObj((String)body);
        JSONObject resource = resultObject.getJSONObject((Object)"resource");
        String cipherText = resource.getStr((Object)"ciphertext");
        String nonceStr = resource.getStr((Object)"nonce");
        String associatedData = resource.getStr((Object)"associated_data");
        AesUtil aesUtil = new AesUtil(key.getBytes(StandardCharsets.UTF_8));
        return aesUtil.decryptToString(associatedData.getBytes(StandardCharsets.UTF_8), nonceStr.getBytes(StandardCharsets.UTF_8), cipherText);
    }

    protected static String readData(HttpServletRequest request) {
        BufferedReader br = null;
        try {
            String line;
            StringBuilder result = new StringBuilder();
            br = request.getReader();
            while ((line = br.readLine()) != null) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(line);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static Object getRequest(String url_prex, String url, Object param, String mchid, String serial_no, String privateKeyFilePath) throws Exception {
        net.sf.json.JSONObject body = null;
        CloseableHttpClient client = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (param != null) {
            Field[] fields;
            for (Field field : fields = param.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                nvps.add(new BasicNameValuePair(field.getName(), field.get(param).toString()));
            }
        }
        URIBuilder uriBuilder = new URIBuilder(url_prex + url);
        uriBuilder.setParameters(nvps);
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        String post = Pay.getToken("GET", HttpUrl.parse((String)(url_prex + url + "?" + httpGet.getURI().getQuery())), mchid, serial_no, privateKeyFilePath, "");
        httpGet.setHeader("Content-type", "application/json");
        httpGet.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048 " + post);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = net.sf.json.JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)entity, (String)charset));
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    protected static Object postRequest(String url_prex, String url, String mchid, String serial_no, String platformSerialNo, String privateKeyFilePath, String jsonStr) throws Exception {
        CloseableHttpResponse response;
        HttpEntity entity;
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url_prex + url);
        StringEntity s = new StringEntity(jsonStr, charset);
        httpPost.setEntity((HttpEntity)s);
        String post = Pay.getToken("POST", HttpUrl.parse((String)(url_prex + url)), mchid, serial_no, privateKeyFilePath, jsonStr);
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048 " + post);
        if (StringUtils.isNotEmpty((CharSequence)platformSerialNo)) {
            httpPost.setHeader("Wechatpay-Serial", platformSerialNo);
        }
        if ((entity = (response = client.execute((HttpUriRequest)httpPost)).getEntity()) != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    protected static void sendMessage(HttpServletResponse response, String plainText) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(12);
        if (StrUtil.isNotEmpty((CharSequence)plainText)) {
            response.setStatus(200);
            map.put("code", "SUCCESS");
            map.put("message", "SUCCESS");
        } else {
            response.setStatus(500);
            map.put("code", "ERROR");
            map.put("message", "\u7b7e\u540d\u9519\u8bef");
        }
        response.setHeader("Content-type", ContentType.JSON.toString());
        response.getOutputStream().write(JSONUtil.toJsonStr(map).getBytes(StandardCharsets.UTF_8));
        response.flushBuffer();
    }
}

