package cn.ps1.aolai.utils;

public class DigitUtil {

	/**
	 * 把单个十六进制0-F字符转为10进制
	 * <p>
	 * 如：'A' >> 10
	 */
	public static int hex2Dec(char ch) {
		return Character.digit(ch, 16);
	}

	/**
	 * 十六进制转为10进制
	 * <P>
	 * 如："BC" >> 188
	 */
	public static int hex2Dec(String hex) {
		return Integer.parseInt(hex, 16);
	}

	/**
	 * 把单个十六进制'0'-'F'字符转为字节
	 */
	public static byte hex2Byte(char ch) {
		return (byte) hex2Dec(ch);
	}

	/**
	 * 十六进制字符转为byte
	 * <P>
	 * 如："BC" >> 188 >> -68
	 */
	public static byte hex2Byte(String hexStr) {
		int val = hex2Dec(hexStr);
		return (byte) (val & 0xff);
	}

	/**
	 * 10进制转为十六进制
	 * <P>
	 * 如：188 >> "BC"
	 */
	public static String toHexStr(int i) {
		String hex = Integer.toHexString(i);
		return hex.length() == 1 ? '0' + hex : hex;
	}

	/**
	 * 二进制字节转为十六进制字符串
	 * <P>
	 * 如：-68 >> 188 >> "BC"
	 */
	public static String toHexStr(byte b) {
		return toHexStr(b & 0xff);
	}

	/**
	 * 二进制字节码流转为十六进制字符串数组
	 */
	public static String[] toHex(byte[] data) {
		return toHex(data, 0, data.length);
	}

	/**
	 * 二进制字节码流转为十六进制字符数组
	 */
	public static String[] toHex(byte[] data, int begin, int end) {
		String[] hexArr = new String[end - begin];
		for (int i = begin; i < end; i++) {
			hexArr[i] = toHexStr(data[i]);
		}
		return hexArr;
	}

	/**
	 * 二进制字节码流转为十六进制字符串
	 */
	public static String toHexStr(byte[] data) {
		return toHexStr(data, 0, data.length);
	}

	/**
	 * 二进制字节码流转为十六进制字符串
	 */
	public static String toHexStr(byte[] data, int begin, int end) {
		StringBuilder builder = new StringBuilder(2 * (end - begin));
		for (int i = begin; i < end; i++) {
			builder.append(toHexStr(data[i]));
		}
		return builder.toString();
	}

	/**
	 * 十六进制字符串转为二进制字节码流
	 */
	public static byte[] hex2Bytes(String hexStr) {
		hexStr = hexStr.replaceAll("\\s*", "");
		char[] hexChs = hexStr.toCharArray();
		// 正常长度必须为偶数，每两位一个字节
		int len = hexStr.length() / 2;
		byte[] bytes = new byte[len];
		for (int i = 0; i < len; i++) {
			int pos = i * 2;
			bytes[i] = (byte) (hex2Byte(hexChs[pos]) << 4 | hex2Byte(hexChs[pos + 1]) & 0xff);
		}
		return bytes;
	}

	/**
	 * 异或校验运算
	 */
	public static byte xorCheck(byte[] arr) {
		byte b = arr[0];
		for (int i = 1; i < arr.length; i++) {
			b = (byte) (b ^ arr[i]);
		}
		return b;
	}

	/**
	 * 根据2位16进制字符串解析温度值
	 */
	public static String hex2Temperature(String str) {
		int i = hex2Dec(str);
		double temperature;
		if ((i >> 15) == 1) {
			temperature = -((i << 17) >> 17) / 10.0;
		} else {
			temperature = i / 10.0;
		}
		return String.valueOf(temperature);
	}

	/**
	 * 简单的平方运算
	 */
	public static int power(int base, int exp) {
		int res = 1;
		for (int i = 0; i < exp; i++)
			res *= base;
		return res;
	}

	private DigitUtil() {
		throw new IllegalStateException("Utility class");
	}

}
