package cn.ps1.aolai.utils;

/**
 * 全局静态变量的总集合，定义了常用的常量
 * 
 * @author Aolai
 *
 */
public class Const {

	/**
	 * 默认字符集转换：UTF-8，推荐用 StandardCharsets.UTF_8替代
	 */
	public static final String UTF8 = "UTF-8";
	/** 元数据表名称：GMETA或META */
	public static String GMETA = "GMETA";
	/** 当应用全部都是接口，则配置一个全局参数忽略token校验 */
	public static boolean All_IN_API = false;

	public static void renameGMeta(String[] arr) {
		if (arr.length > 2) {
			if (!FmtUtil.isEmpty(arr[2]) && !GMETA.equals(arr[2])) {
				RDS_META = "g.";
				GMETA = arr[2];
				System.out.println("---> " + RDS_META + GMETA);
			}
			All_IN_API = arr.length > 3 && "1".equals(arr[3]);
		}
	}

	/**
	 * 排序参数需要大写，如：ASC,DESC
	 */
	public static final String[] SORTBY = { "ASC", "DESC" };

	/** 通用参数ID */
	public static final String ID = "id";

	/**
	 * 国际化语言
	 */
	public static final String LANG = "lang";
	/**
	 * 数据库主键
	 */
	public static final String PKEY = "pkey";

	/**
	 * 常用的常量：“info”
	 */
	public static final String INFO = "info";
	/** 常用的常量：“base” */
	public static final String BASE = "base";
	/** 常用的常量：“json” */
	public static final String JSON = "json";
	/** 常用的常量：“i18n” */
	public static final String I18N = "i18n";
	/** 常用的常量：“like” */
	public static final String LIKE = "like";
	/** 常用的常量：“sort” */
	public static final String SORT = "sort";
	/** 常用的常量：“name” */
	public static final String NAME = "name";
	/** 常用的常量：“type” */
	public static final String TYPE = "type";
	/** 字符串“null” */
	public static final String NULL = "null";
	/** 字符串“show” */
	public static final String HIDE = "hide";
	/** 字符串“show” */
	public static final String SHOW = "show";
	/** 查询条件“cond” */
	public static final String COND = "cond";

	/** 数据版本：“kmbb” */
	public static final String KMBB = "kmbb";
	/** EXCEL文件 */
	public static final String XLSX = "xlsx";
	/** 数据列表 */
	public static final String ROWS = "rows";
	/** 数据一览 */
	public static final String LIST = "list";
	/** 编辑 */
	public static final String EDIT = "edit";
	/** 模糊处理 */
	public static final String BLUR = "blur";
	/** 锁定状态 */
	public static final String LOCK = "lock";
	/** 报表表头“head” */
	public static final String HEAD = "head";

	/** 持久层XML参数@Param */
	public static final String MAP = "map";
	/** 新增 */
	public static final String ADD = "add";
	/** EXCEL文件 */
	public static final String XLS = "xls";
	/** 全部 all */
	public static final String ALL = "all";
	/** 主键 */
	public static final String KEY = "key";
	/** 值 */
	public static final String VAL = "val";
	/** URI */
	public static final String URI = "uri";
	/** URL */
	public static final String URL = "url";

	/** SQL中的包含 */
	public static final String IN = "in";

	/** 约定表名 */
	public static final String TABLE = "table";
	/** 字段别名 */
	public static final String ALIAS = "alias";
	/** 字段名称 */
	public static final String FIELD = "field";
	/** 字段样式 */
	public static final String STYLE = "style";
	/** 字段宽度 */
	public static final String WIDTH = "width";
	/** 限定行数 */
	public static final String LIMIT = "limit";
	/** 定义连接符 */
	public static final String JOINT = "joint";
	/** 排序 */
	public static final String ORDER = "order";
	/** 数据集 */
	public static final String ITEMS = "items";
	/** 数据总数 */
	public static final String TOTAL = "total";
	/** 分页信息，当前页码(pageNo) */
	public static final String PAGE_NO = "pageNo";
	/** 分页信息，每页条数(pageSize) */
	public static final String PAGE_SIZE = "pageSize";

	/**
	 * 默认值：default
	 */
	public static final String DEFAULT = "default";
	/** 内容：content */
	public static final String CONTENT = "content";
	/**
	 * 包含下级或字符串：include
	 */
	public static final String INCLUDE = "include";
	/** 定制化的 */
	public static final String CUSTOM = "custom";
	/** 权限许可 */
	public static final String PERMIT = "permit";
	/** 状态：status */
	public static final String STS = "status";

	/** 特殊字符 */

	/** 字符串："0" */
	public static final String S_0 = "0";
	/** 字符串："1" */
	public static final String S_1 = "1";
	/** 字符串："2" */
	public static final String S_2 = "2";
	/** 字符串："3" */
	public static final String S_3 = "3";
	/** 字符串："5" */
	public static final String S_5 = "5";
	/** 字符串："9" */
	public static final String S_9 = "9";

	/** JSON状态：val='1' */
	public static final String V_1 = "'1'";

	/** STR_0, 请用 S_0 替代 */
	@Deprecated
	public static final String STR_0 = "0";
	/** STR_1, 请用 S_1 替代 */
	@Deprecated
	public static final String STR_1 = "1";
	/** STR_2, 请用 S_2 替代 */
	@Deprecated
	public static final String STR_2 = "2";

	/** 冒号":" */
	public static final String COLON = ":";
	/** 逗号"," */
	public static final String COMMA = ",";
	/** 小数点"." */
	public static final String DOT = ".";
	/** 等于 = */
	public static final String EQU = "=";
	/** 不等于!= */
	public static final String NEQ = "!=";

	/** 简单月份 */
	public static final String MON = "yyyyMM";
	/** 简单日期：yyyyMMdd */
	public static final String DAY = "yyyyMMdd";
	/** 简单日期：SimpleDateFormat */
	public static final String SDF = "yyyy-MM-dd";
	/** 时分秒：DateTimeFormat */
	public static final String DTF = "yyyy-MM-dd HH:mm:ss";
	/** 毫秒 */
	public static final String MSEC = "yyyy-MM-dd HH:mm:ss.SSS";
	/** 当前时间 */
	public static final String NOW = "yyyyMMddHHmmss";

	/** 缓存有效期：1天=24小时=86400秒 */
	public static final int ONE_DD = 86400;
	/** 缓存有效期：10小时=3600秒 */
	public static final int TEN_HH = 36000;
	/** 缓存有效期：2小时=7200秒 */
	public static final int TWO_HH = 7200;
	/** 缓存有效期：1小时=3600秒 */
	public static final int ONE_HH = 3600;
	/** 缓存有效期：10分钟=600秒 */
	public static final int TEN_MM = 600;
	/** 缓存有效期：2分钟=120秒 */
	public static final int TWO_MM = 120;
	/** 缓存有效期：1分钟=60秒 */
	public static final int ONE_MM = 60;
	/** 默认的层宽 */
	public static final int[] TIER_W = { 0, 1, 2, 3, 4, 5 };

	/** 1. 授权(Auth)的 AppId应用 */
	public static final String RDS_APPID = "a."; // 授权访问的ticket
	/** 2. 账套(base) */
	public static final String RDS_BASE = "b."; // 数据库分库
	/** 3. 公司(company) */
	public static final String RDS_COMP = "c."; // 公司
	/** 4. 拒绝(deny)的IP地址 */
	public static final String RDS_DENY = "d."; // 阻止IP访问（验证码防黑客）
	/** 标记(flag)未用 */
	public static final String RDS_FLAG = "f."; // 标记=1
	/** 6. 通行证(certKey) */
	public static final String RDS_CERT = "k."; // certKey
	/** 7. 登录失败(loss)次数 */
	public static final String RDS_LOSS = "l."; // 登录失败次数（防暴力破解）
	/** 8.用以缓存客户端的IP地址(ipAddress) */
	public static final String RDS_ADDR = "i.";
	/** 9. 元数据(meta) */
	public static String RDS_META = "m."; // 元数据表结构（频繁调用的DTO）

	/** 10.组织(organize)未用 */
	public static final String RDS_ORGN = "o.";
	/** 11.页面控制(page) */
	public static final String RDS_PAGE = "p.";  // 缓存的页面权限
	/** 12. 页面权限控制(role) */
	public static final String RDS_ROLE = "r.";  // 缓存的页面权限
	/** 13. 缓存的 Token信息 */
	public static final String RDS_TOKEN = "t."; // 当前 Token信息
	/** 14. 用户信息(userInfo) */
	public static final String RDS_USER = "u."; // 当前用户信息
	/** 15. 验证码(verification code) */
	public static final String RDS_CODE = "v."; // 随机动态码

	private Const() {
		throw new IllegalStateException("Utility class");
	}

}
