package cn.ps1.aolai.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 全局通用的配置参数类（config.properties）
 * 
 * @author Aolai
 * @since 1.7 $Date: 2017.6.17
 * @version 1.0
 */

public class ConfUtil {

	private static Logger log = LoggerFactory.getLogger(ConfUtil.class);

	/** 以下为系统约定的全局变量定义及默认配置 */

	/** 应用的配置文件：config.properties */
	private static ResourceBundle confBundle = ResourceBundle.getBundle("config");
	/** 前台传递的参数：config.properties */
	private static ResourceBundle paramBundle = ResourceBundle.getBundle("params");
	/** 需要校验的参数：config.properties */
	private static ResourceBundle validBundle = ResourceBundle.getBundle("valid");

	/** 数据库中（GCONF表中）的参数配置 */
	private static Map<String, String> gCONF = new HashMap<>();

	/** 约定为 “jsonstr”字符串 */
	public static final String JSONSTR = "jsonstr";
	/** 主键：“appCode” */
	public static final String APPCODE = "appCode";
	/** 保存在token中的客户端的IP地址的主键“ipaddr” */
	public static final String IPADDR = "ipaddr";
	/** “ticket” */
	public static final String TICKET = "ticket";
	/** “token” */
	public static final String TOKEN = "token";

	/** 前端传递的k参数，注意与certKey区别，与RDS_CERT无关 */
	public static final String CERT_K = "k";
	/** 分隔符",|;" */
	public static final String COMMA = ",|;";
	/** 跟踪编号 */
	public static final String TRACEID = "traceId";
	/** 证书编号 */
	public static final String CERTID = "certId";
	/** 公司编号 */
	public static final String COMPID = "compId";
	/** 用户编号 */
	public static final String USERID = "userId";
	/** 应用编号 */
	public static final String APPID = "appId";

	/** 无效的参数 */
	public static final String INVD_PARAMS = "invalidParams";	
	/** 不能删除 */
	public static final String CANT_REMOVE = "cantRemove";	
	/** 不能更新 */
	public static final String CANT_UPDATE = "cantUpdate";	
	/** 超数量限制 */
	public static final String OVER_COUNTS = "overCounts";	
	/** 数据或字符串长度超出限制 */
	public static final String OVER_LENGTH = "overLength";
	/** 越权访问 */
	public static final String DENY_ACCESS = "denyAccess";	
	/** 重复命名 */
	public static final String DUPL_NAME = "duplicateName";
	/** 重复数据 */
	public static final String DUPL_DATA = "dataDuplicate";
	/** 数据并发冲突 */
	public static final String DATA_COLL = "dataCollision";
	/** 数据没有找到 */
	public static final String NOT_FOUND = "noDataFound";
	/** 数据已在使用中 */
	public static final String DATA_USED = "dataInUse";
	/** 运行未知的错误 */
	public static final String RUN_FAILED = "doFailed";
	/** 数据库并发回滚 */
	public static final String IS_ROLLBACK = "isRollback";
	/** 手机号码规则 */
	public static final String MOBI_RULES = "mobileRules";

	/**
	 * 以下约定参数要与config.properties（或数据库GCONF表）中的配置相匹配
	 */

	/** 应用接口互访KEY */
	private static String appKEY = "www.ps1.cn";
	/** 应用接口互访KEY */
	public static String appKey() {
		return appKEY;
	}

	/** 后台应用标识的缩写编码，等效前端的appCode，如：“FF” */
	private static String appSIGN = "";
	/** 为方便区分APPCODE，后台应用标识的编码改为appSign，如：“FF” */
	public static String appSign() {
		return appSIGN;
	}

	/** 主应用的请求地址，如：http://host.ps1.cn */
	private static String appCORE = "";
	/** 主应用的请求地址，如：http://host.ps1.cn */
	public static String appCore() {
		return appCORE;
	}

	/** 主应用，如："/doyea" */
	private static String appMAIN = "/main";
	/** 主应用，如："/doyea" */
	public static String appMain() {
		return appMAIN;
	}

	/** 访问主应用的证书 */
	private static String[] appSPEC = {};	
	/** 访问主应用的证书 */
	public static String[] appSpec() {
		return appSPEC;
	}

	/** 多租户分库时账套编号的KEY，如："dbid" 或 "baseId"，未配置默认"baseId" */
	private static String baseDBID = "";
	/** 多租户分库时账套编号的KEY，如："dbid" 或 "baseId"，未配置默认"baseId" */
	public static String dbid() {
		return baseDBID;
	}

	/** 多租户的分割符号"." 或 "_"，未配置默认"."，增加“0” */
	private static String baseDOT = ".";
	/** 多租户的分割符号"." 或 "_"，未配置默认"."，增加“0” */
	public static String baseDot() {
		return baseDOT;
	}

	/** 多租户的账套名称的前缀base.name，如："culai"、"base" */
	private static String baseNAME = "";
	/** 多租户的账套名称的前缀base.name，如："culai"、"base" */
	public static String baseName() {
		return baseNAME;
	}

	/**
	 * 根据租户ID拼接数据库名或表名：“base147.”、“base258_”
	 */
	public static String baseNameOf(Object dbid) {
		// 既不分表、也不分库的数据隔离的情况，返回空“”
		return dataIsolation() ? "" : baseName() + dbid + baseDot();
	}

	/** 用于区分Mysql、PG(public)，Mysql可配置为""，如：mysql\public， */
	private static String baseMAIN = "";
	/** 用于区分Mysql、PG(public)，Mysql可配置为""，如：mysql\public， */
	public static String baseMain() {
		return baseMAIN;
	}

	/** 支持多语言参数，如：ZH,EN */
	private static String[] i18nLOCALES = { "ZH", "EN" };
	/** 支持多语言参数，如：ZH,EN */
	public static String[] locales() {
		return i18nLOCALES;
	}

	/** 单点SSO请求单点登录的远程服务地址，如：http://sso.ps1.cn/aolai/s */
	private static String ssoURL = "";
	/** 单点SSO请求单点登录的远程服务地址，如：http://sso.ps1.cn/aolai/s */
	public static String ssoUrl() {
		return ssoURL;
	}

	/** 各个接口通用校验项目（如：dbid等通用项），默认不用配置 */
	private static boolean validMUST = false;
	/** 各个接口通用校验项目（如：dbid等通用项），默认不用配置 */
	public static boolean mustValid() {
		return validMUST;
	}

	/** 查询数据行数的限制，未配置默认limit.rows=''不限制数据 */
	private static String limitROWS = "2999";
	/** 查询数据行数的限制，未配置默认limit.rows=''不限制数据 */
	public static String limitRows() {
		return limitROWS;
	}

	/** Http请求超时时间，默认2分钟超时，120秒 */
	private static int httpTIMEOUT = 120000;
	/** Http请求超时时间，默认2分钟超时，120秒 */
	public static int httpTimeout() {
		return httpTIMEOUT;
	}

	/** Redis默认的用户缓存时间 2小时 */
	private static int cacheTIME = Const.ONE_HH;
	/** Redis默认的用户缓存时间 2小时 */
	public static int cacheTime() {
		return cacheTIME;
	}

	/** Redis默认的验证码有效缓存时间（默认10分钟10000秒） */
	private static int codeEXPIRED = Const.TEN_MM;
	/** Redis默认的验证码有效缓存时间（默认10分钟10000秒） */
	public static int vcodeDue() {
		return codeEXPIRED;
	}

	/** API是否需要对应三方应用授权才能访问 */
	private static boolean apiPERMIT = false;
	/** API是否需要对应三方应用授权才能访问 */
	public static boolean apiPermit() {
		return apiPERMIT;
	}

	/** 应用请求路径跟踪标识，可不用配置 */
	private static boolean isTRACKING = false;
	/** 应用请求路径跟踪标识，可不用配置 */
	public static boolean isTracking() {
		return isTRACKING;
	}

	/** 开放API接口标识，可不用配置，若需要配置为：true */
	private static boolean isApiOPEN = false;
	/** 开放API接口标识，可不用配置，若需要配置为：true */
	public static boolean isApiOpen() {
		return isApiOPEN;
	}

	/** 响应内容加密，可不用配置 */
	private static boolean isEncRESP = false;
	/** 响应内容加密，可不用配置 */
	public static boolean isEncResp() {
		return isEncRESP;
	}

	/** 响应日志记录，可不用配置 */
	private static boolean isLogRESP = false;
	/** 响应日志记录，可不用配置 */
	public static boolean isLogResp() {
		return isLogRESP;
	}

	/** 请求内容是否忽略加密，默认加密（不忽略），可不用配置 */
	private static boolean isEncOMIT = false;
	/** 请求内容是否忽略加密，默认加密（不忽略），可不用配置 */
	public static boolean isEncOmit() {
		return isEncOMIT;
	}

	/** 日志要不要保存“请求参数”的最大长度 */
	private static int isLogARGS = 0;
	/** 日志要不要保存“请求参数”的最大长度 */
	public static int logArgs() {
		return isLogARGS;
	}

	/** 控制同一账户多人同时登录，未配置默认为仅限单用户登录使用 */
	private static boolean isMultiLOGIN = false;
	/** 控制同一账户多人同时登录，未配置默认为仅限单用户登录使用 */
	public static boolean isMultLogin() {
		return isMultiLOGIN;
	}

	/** 是否支持自定义设置标签的隐藏和显示的数量 */
	private static boolean isCustomMETA = false;
	/** 是否支持自定义设置标签的隐藏和显示的数量 */
	public static boolean isCustomMeta() {
		return isCustomMETA;
	}

	/** 避开数据库校验规则 */
	private static boolean avoidRULES = false;
	/** 避开数据库校验规则 */
	public static boolean avoidRules() {
		return avoidRULES;
	}

	/** 失败尝试次数 */
	private static int tryTIMES = 1;
	/**
	 * 失败尝试次数
	 */
	public static int tryTimes() {
		return tryTIMES;
	}

	// SQL注入：注释符--(后面有空格)也就是--+，注释符#，注释符/**/，payload结尾单引号闭合
	/** 有效的防SQL注入的文本值 */
//	private static String sqlVTEXT = "'(%|\\^)?[\\w+ \u4e00-\u9fa5]*(%|\\$)?'";
	private static String sqlVTEXT = "(%|\\^)?[\\w+ \u4e00-\u9fa5]*(%|\\$)?";
	/** 有效的防SQL注入的文本值 */
	public static String sqlVText() {
		return sqlVTEXT;
	}

	/** 有效的 SQL表达式，暂时禁用: "!","&&","||","XOR" */
	public static final String[] SQL_EXPR = { "=", "!=", ">", "<", ">=", "<=", "<>", "or", "like",
			"in", "(", ")", "is", "not", "null", "and", "between", "json_extract(", "length(",
			"rlike", "regexp", "+", "-" };// , "max(", "min(" };

	// 可以自定义SQL注入的关键字
	private static void setSqlEXPR(String expr) {
		if (expr.length() == 0)
			expr = "=,!=,>,<,>=,<=,<>,or,like,in,(,),is,not,null,and,between,json_extract(,length(,rlike,regexp,+,-";
		sqlEXPR = Arrays.asList(expr.split(Const.COMMA));
	}

	private static List<String> sqlEXPR = new ArrayList<>();

	/**
	 * 有效的 SQL表达式的关键字
	 */
	public static boolean isSqlExpr(String key) {
		return key.length() == 0 || sqlEXPR.contains(key.toLowerCase());
	}

	private static Map<String, String> metas = new HashMap<>();
	static {
		// 先初始化GMETA信息
		metas.put(Const.TABLE, "META_TABLE"); // 增补表名
		metas.put(Const.FIELD, "META_FIELD"); // ★
		metas.put(Const.ALIAS, "META_ALIAS"); // ★
		metas.put(Const.TYPE, "META_TYPE"); // ★
		metas.put(Const.NAME, "META_NAME");
		metas.put(Const.NULL, "META_NULL");
		metas.put(Const.LANG, "META_I18N"); // ★
		metas.put(Const.PKEY, "META_PKEY"); // ★
		metas.put(Const.SORT, "META_SORT");
		//新增加了样式字段
		metas.put(Const.STYLE, "META_STYLE"); // ★
		//metas.put(Const.WIDTH, "META_WIDTH");
		metas.put(Const.DEFAULT, "META_DEFAULT");
	}

	/**
	 * GMETA表的元数据
	 */
	public static Map<String, String> gMETAS() {
		return metas;
	}

	/**
	 * 初始化加载数据，从数据库中读取GMETA元数据参数
	 */
	private static void initGmeta(Object res) {
		Map<String, String> params = obj2Map(res);
		metas = params.isEmpty() ? metas : params;
		log.info("^_^");// ^_^ T_T o.o oOo
	}

	/**
	 * 初始化全局配置，在 SpringContext中调用此方法
	 */
	public static void initAppGconf(String initCnf) {
		if (initCnf == null)
			initCnf = getProp("app.gconf", "");

		// 根据配置判断是否启用数据库："1,GCONF,,0"
		if ("".equals(initCnf)) {
			// 读取配置文件：config.properties
			for (String key : confBundle.keySet()) {
				gCONF.put(key, getProp(key, ""));
			}
		} else {
			String[] arr = initCnf.split(ConfUtil.COMMA);
			Const.renameGMeta(arr);

			// 获取数据库中的数据，并初始化
			Map<String, String> cnfMap = obj2Map(invoke(null, "appGconfOne", arr));
			if (cnfMap.isEmpty()) {
				log.error("initAppGconf...GCONF is null");
				return;
			} else {
				gCONF = cnfMap;
			}
		}
		// 加载数据
		loadGconf();
		log.info("> initAppGconf()...{}", gCONF);
		initGmeta(invoke(null, "appGmetaOne", ""));
	}

	/**
	 * 初始化加载数据，从数据库中读取系统配置参数
	 */
	private static void loadGconf() {

		appKEY = getConf("app.key", appKEY);
		appSIGN = getConf("app.code", appSIGN);
		appCORE = getConf("app.core", appCORE);
		appMAIN = getConf("app.main", appMAIN);
		// 格式为：ticket:apec
		// VJEFKISG:12044b9cbfb8eeaeba3e21d1d7a26611
		appSPEC = getConf("app.spec", "").split(Const.COLON);

		baseDBID = getConf("base.dbid", baseDBID);
		baseDOT = getConf("base.dot", Const.DOT); // 默认'.'
		baseNAME = getConf("base.name", "");
		// PG时public，Mysql可配置为""
		baseMAIN = getConf("base.main", ""); // mysql时可配置为""
		i18nLOCALES = getConf("i18n.locales", "ZH,EN").split(COMMA);

		ssoURL = getConf("sso.url", "");
		validMUST = getConf("valid.must", "").length() > 0;
		limitROWS = getConf("limit.rows", limitROWS);
		httpTIMEOUT = getInt("http.timeout", 90000);
		cacheTIME = getInt("cache.time", cacheTIME);
		codeEXPIRED = getInt("code.expired", codeEXPIRED);

		apiPERMIT = getConf("api.permit", "").length() > 0;
		isTRACKING = getConf("app.trace", "").length() > 0;
		isApiOPEN = getConf("api.open", "").length() > 0; // 开放API模式:"true"
		isEncRESP = getConf("enc.resp", "").length() > 0;
		isLogRESP = getConf("log.resp", "").length() > 0;
		isEncOMIT = getConf("enc.omit", "").length() > 0;
		// 日志要不要保存“请求参数”的最大长度
		isLogARGS = Integer.parseInt(getConf("log.args", Const.S_0));
		isMultiLOGIN = getConf("multi.login", "").length() > 0;
		isCustomMETA = getConf("meta.custom", "").length() > 0;
		// 避开数据库校验规则
		avoidRULES = getConf("avoid.rules", "").length() > 0;
		tryTIMES = getInt("try.times", tryTIMES);

		String sv = getConf("sql.vtext", sqlVTEXT);
		// 剔除单引号
		sqlVTEXT = sv.matches("^'.*'$") ? sv.substring(1, sv.length() - 1) : sv;

		// 可以自定义SQL注入的关键字
		setSqlEXPR(getConf("sql.expr", ""));
	}

	/**
	 * 获取配置参数的值
	 */
	public static String getConf(String key, String def) {
		String val = gCONF.get(key);
		return val == null || "".equals(val) ? def : val;
	}

	/**
	 * 获取配置参数的值
	 */
	public static String getConf(String key) {
		return getConf(key, "");
	}

	/**
	 * 获取配置参数的值
	 */
	public static int getInt(String key, int def) {
		log.debug("getInt...{}", key);
		String val = gCONF.get(key);
		return val == null ? def : FmtUtil.getInt(val, def);
	}

	/**
	 * 租户数据隔离（既非分库、也非分表），需配置为：baseDOT=“0”
	 */
	public static boolean dataIsolation() {
		return Const.S_0.equals(baseDot());
	}

	/**
	 * 调用：根据Bean名称，发起第三方服务接口调用<br>
	 */
	public static Object invoke(Object bean, String method, Object args) {
		try {
			// 获取bean
			if (bean == null)
				bean = SpringContext.getBean("gconfService");
			// 获取公开方法
			Method m = bean.getClass().getMethod(method, Object.class);
			// 调用方法，根据参数进行处理
			return m.invoke(bean, args);
		} catch (Exception e) {
			log.error("invoke...{}({})", method, args);
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 获取配置参数的值
	 */
	public static String get(String key, String def) {
		return getConf(key, def);
	}

	/**
	 * 获取配置参数的值
	 */
/*	public static String get(String key) {
		return getConf(key);
	}*/

	/** 以下为配置参数文件的处理 */

	/**
	 * 前台请求接口数据返给前台的响应参数名
	 */
	public static String getParam(String key) {
		return getProp(paramBundle, key, "");
	}

	/**
	 * 前台请求接口的必需参数
	 */
	public static String getValid(String key) {
		return getProp(validBundle, key, "");
	}

	/** 读取配置文件数据 */
	private static String getProp(ResourceBundle rb, String key, String def) {
		try {
			return rb.getString(key);
		} catch (Exception e) {
			log.debug("getPropKey...{}", e.getMessage());
			return def;
		}
	}

	/** 读取配置文件数据 */
	private static String getProp(String key, String def) {
		return getProp(confBundle, key, def);
	}

	/** 对象转换为Map */
	@SuppressWarnings("unchecked")
	public static <T> Map<String, T> obj2Map(Object obj) {
		return obj instanceof Map ? (Map<String, T>) obj : new HashMap<>();
	}

	/** 对象转换为Map */
	@SuppressWarnings("unchecked")
	public static <T> List<T> obj2List(Object obj) {
		return obj instanceof Collection ? (List<T>) obj : new ArrayList<>();
	}

	/** 使用like包含(include) */
	public static final String OP_LIKE = "A"; // include
	/** 使用等于= */
	public static final String OP_EQU = "C";
	/** 使用不等于!= */
	public static final String OP_NEQ = "D";
	/** 以...开始 */
	public static final String OP_SW = "E"; // start with
	/** 以...结束 */
	public static final String OP_EW = "F"; // end with
	/** 使用大于> */
	public static final String OP_MT = "G"; // more than or equal
	/** 使用小于< */
	public static final String OP_LT = "H"; // less than or equal
	/** 大于等于>= */
	public static final String OP_ME = "I"; // more than or equal
	/** 小于等于<= */
	public static final String OP_LE = "J"; // less than or equal
	/** 为空 */
	public static final String OP_NUL = "K";
	/** 非空 */
	public static final String OP_NON = "L"; // non null
	/** 枚举 */
	public static final String OP_IN = "M";
	/** 区间 */
	public static final String OP_BTWN = "N";

	/** 操作符表达式 */
	private static Map<String, String> opKey = new HashMap<>();
	static {
		opKey.put("A", "like"); // 包含
		opKey.put("B", "not like"); // 不包含
		opKey.put("C", "="); // 等于
		opKey.put("D", "!="); // 不等于
		opKey.put("E", "like"); // 以...开始
		opKey.put("F", "like"); // 以...结束
		opKey.put("G", ">"); // 大于
		opKey.put("H", "<"); // 小于
		opKey.put("I", ">="); // 大于等于
		opKey.put("J", "<="); // 小于等于
		opKey.put("K", "="); // 为空
		opKey.put("L", "!="); // 不为空
		opKey.put("M", "in"); // 枚举的包含（未执行、执行中、已执行）
		opKey.put("N", "between {0} and {1}"); // 区间，基本是时间区间
	}

	/** 参数值 */
	private static Map<String, String> opVal = new HashMap<>();
	static {
		opVal.put("A", "%{}%"); // 包含
		opVal.put("B", "%{}%"); // 不包含
		opVal.put("C", "{}"); // 等于
		opVal.put("D", "{}"); // 不等于
		opVal.put("E", "{}%"); // 以...开始
		opVal.put("F", "%{}"); // 以...结束
		opVal.put("G", "{}"); // 大于
		opVal.put("H", "{}"); // 小于
		opVal.put("I", "{}"); // 大于等于
		opVal.put("J", "{}"); // 小于等于
		opVal.put("K", ""); // 为空，也变成传递“”
		opVal.put("L", ""); // 不为空，也变成传递“”
		// 以下场景有多个数据数组时不会执行
		opVal.put("M", "({})"); // 枚举的包含in（未执行、执行中、已执行）
		opVal.put("N", "{0} and {1}"); // 区间，基本是时间区间
	}

	/**
	 * 数值转换为有效的SQL字符串
	 */
	static String getOpVal(Object key, String val) {
		if (opVal.containsKey(key)) {
			// 匹配一个或多个由空格、数字或下划线组成的字符串
			if (FmtUtil.isValidWord(val)) {
				return opVal.get(key).replaceAll("\\{\\}", val);
			} else if ("".equals(val)) {
				return opVal.get(key);
			}
		}
		throw new FailedException();
	}

	/**
	 * 获取组合主键的操作符
	 */
	public static String getOpr(Object key) {
		return opKey.get(key);
	}

	/**
	 * 根据运算符号拼接查询条件：{"E":"{}%"} ->转化为 "名字%" 
	 */
	public static Object opExpr(Object key, Map<String, Object> map) {
		// 获取参数的数值，同时支持单一数值参数，也支持列表
		Object val = map.get(Const.VAL);
		// 有多个值的列表场景
		List<String> valList = ConfUtil.obj2List(val);
		if (valList.isEmpty()) {
			// 单个字符串值
			if (val instanceof CharSequence) {
				return getOpVal(key, (String) val);
			}
		} else {
			// 多个值包含仅一个值的场景如：in ('abc')
			// "N" 介于...之间
			if ("N".equals(key) && "time".equals(map.get(Const.STYLE))) {
				for (int i = 0; i < valList.size(); i++) {
					String d = FmtUtil.timeParse(valList.get(i), Const.DAY, Const.SDF);
					valList.set(i, d + (i == 0 ? " 00:00:00" : " 23:59:59"));
				}
			}
			return val;
		}
		throw new FailedException();
	}

	private ConfUtil() {
		throw new IllegalStateException("Utility class");
	}

}
