package cn.ps1.aolai.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.utils.Const;

/**
 * 全局通用的文件处理相关的公共方法类
 * 
 * @author Aolai
 * @since  $Date: 2022.9.10
 */

@Service
public class XfileService {

	@Autowired
	private UtilsService utils;
	@Autowired
	HttpServletRequest req;
	// 应用的真实路径
	private static String userDir = null;

	/**
	 * 判断系统是否为Windows 10
	 */
	private boolean isWindows() {
		return System.getProperty("os.name").contains("Windows");
	}

	/**
	 * 拼接真实路径
	 */
	public String realPath(String path) {
		return joinPath(realPath(), path);
	}

	/**
	 * 拼接Window/Linux路径<br>
	 * D:\javaApp\myapp<br>
	 * /opt/apache-tomcat/webapps/myapp
	 */
	public String realPath() {
		if (userDir == null) {
			// 默认：/opt/apache-tomcat/webapps/myapp
			userDir = req.getSession().getServletContext().getRealPath("");
		}
		return userDir;
	}

	/**
	 * 拼接真实路径
	 */
	public String joinPath(String basePath, String path) {
		return basePath + path + (isWindows() ? "\\" : "/");
	}

	/**
	 * 拼接文件路径，如：aolai/1036/20220925/
	 */
	public <T> String getFilePath(Map<String, T> map, String[] keys) {
		StringBuilder sb = new StringBuilder();
		for (String key : keys) {
			sb.append(map.get(key) + File.separator);
		}
		return sb.toString();
	}

	/**
	 * 根据文件的全路径截取文件名称
	 */
	public String getFileName(String file) {
		return file.substring(file.lastIndexOf(File.separator));
	}

	/**
	 * 这里返回拼接生成的文件名称
	 */
	public String makeFileName(Object name, Object ext) {
		// 这里为自动生成的文件名称
		return name + Const.DOT + ext;
	}

	/**
	 * 文件尺寸（默认千字节KB）超限额，如：limit=“100M”
	 */
	public boolean overSize(long kiloByte, String limit) {
		// 标示文件字节大小的单位
		if (limit == null)
			return false;
		limit = limit.toUpperCase();// .matches("\\d+[KMGTP]"))
		Matcher m = Pattern.compile("^(\\d+)([KMGTP])$").matcher(limit);
		if (m.find()) {
			int i = "KMGTP".indexOf(m.group(2));
			double max = Math.pow(1024, i) * Integer.parseInt(m.group(1));
			return kiloByte > max;
		}
		return utils.isInteger(limit) && kiloByte > Integer.parseInt(limit);
	}

	/**
	 * 输出文件流到浏览器，用于下载或预览文件
	 */
	public boolean write2Resp(String file, HttpServletResponse resp, String header,
			String contentType) {
		// 清空response, 再设置response的Header
		resp.reset();
		resp.setContentType(contentType);
		try (InputStream inp = new FileInputStream(file);
				OutputStream out = new BufferedOutputStream(resp.getOutputStream())) {
			byte[] bytes = new byte[inp.available()];
			if (inp.read(bytes) > 0) {
				resp.addHeader("Content-Disposition", header + getFileName(file));
				resp.addIntHeader("Content-Length", bytes.length);
				out.write(bytes); // 输出流
				out.flush();
				return true;
			}
		} catch (IOException e) {
			utils.doFailed();
		}
		return false;
	}

}
