package cn.ps1.aolai.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.entity.Gconf;
import cn.ps1.aolai.utils.ConfUtil;

/**
 * 维护全局系统配置表Ggconf中的数据，与其相关的基础业务操作
 *
 * @author Aolai
 * @version 1.0
 * @since OpenJdk1.8 $Date: 2024.3.7
 */

@Service
public class GconfService {

	// 查询GCONF表的配置参数
//	private String[] gconf = { "", Gconf.getTable(), "", "0" };

	@Autowired
	private AolaiService aolai;
	@Autowired
	private UtilsService utils;

	/**
	 * 系统初始化时，通过ConfUtil.initGconf()获取Ggconf表中全部配置参数<br>
	 * 这里params默认为"app.gconf"的参数值：params=“1,GCONF,,0”
	 */
	public Map<String, String> appGconfOne(Object params) {
		if (params == null)
			return null;
		//String[] arr = String.valueOf(params).split(ConfUtil.COMMA);
		String[] arr = (String[]) params;

		// 如果第1位数字标志是‘1’,则刷新参数
		if ("1".equals(arr[0]) && arr.length > 1) {
			Gconf.setTable(arr[1]);
		}
		// 默认查询配置项的条件：confTag="gconf"
		Map<String, Object> cond = new HashMap<>();
		cond.put(Gconf.TAG, "gconf");

		/** 系统刚刚初始化，还未获取到配置参数 */
		List<Map<String, String>> items = getGconf(cond);
		return utils.list2Map(items, Gconf.KEY, Gconf.VAL);
	}

	/**
	 * GMETA表的元数据：从GMETA表中GMETA表自己的元数据一览
	 * 此处需要传入参数，要不然confUtil 反射调用会报错，方法不匹配
	 */
	public Map<String, String> appGmetaOne(Object params) {
		return aolai.gMetaOne();
	}

	/**
	 * 获取全部配置参数：默认表Ggconf<br>
	 * 注意：系统刚刚初始化，还未获取到配置参数，无法实现按租户数据隔离<br>
	 * 注意：再次维护数据时，已实现按租户数据隔离
	 */
	public List<Map<String, String>> getGconf(Map<String, Object> cond) {
		String[] gconf = { "", Gconf.getTable(), "", "0" };
		return aolai.findAll(cond, null, gconf);
	}

	/**
	 * 三方接口调用时，ThirdService.certifyApiKey()根据ticket获取 certKey通行证<br>
	 * 获取应用级通行证：这里可以针对不同应用获取不同应用的通行证书
	 */
/*	public Map<String, String> appCert(Object ticket) {
		// 如：ticket="JLA9EKCL"
		Map<String, Object> where = new HashMap<>();
		// 参数值：certId
		where.put(ConfUtil.CERTID, ticket);
		where.put("certState", "1");
		// 从通行证表中获取通行证（API证书）
		return aolai.findOne("CERT", where, null);
	}*/
	public String appCert(Object ticket) {
		// 如：ticket="yXATDmHI", 返回值：ZFKROBVjNSPGQueWCl
		return ConfUtil.getConf(String.valueOf(ticket));
	}

}
