package cn.ps1.aolai.annotation;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import com.fasterxml.jackson.databind.ObjectMapper;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.SpringContext;

/**
 * 自定义注解解析器，用于解析 jsonstr 传递的参数
 * <p>
 * 直接实现HandlerMethodArgumentResolver类自定义解析方式
 * <p>
 * 也可继承AbstractMessageConverterMethodArgumentResolver实现RequestBody方式解析
 * 
 * @author yujf
 */
public class AolaiBodyResolver implements HandlerMethodArgumentResolver {

	public AolaiBodyResolver() {
		super();
	}

	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		// 绑定注解
		return parameter.hasParameterAnnotation(AolaiJsonBody.class);
	}

	@Override
	public Object resolveArgument(MethodParameter parameter,
			ModelAndViewContainer mavContainer, NativeWebRequest webRequest,
			WebDataBinderFactory binderFactory) throws Exception {
		/**
		 * 根据参数类型，将jsonstr 转化为对应的对象，因aolai框架限制，暂不支持
		 */
		HttpServletRequest req = webRequest.getNativeRequest(HttpServletRequest.class);
		UtilsService utils = SpringContext.getBean(UtilsService.class);
		// 此取解密后的参数
		Map<String, Object> json = utils.jsonParams(req);
		// 根据有注解的参数类型，将对应的字符串转化为对象 ，此处特别注意不支持 List。需改造aolai适配 TODO
		ObjectMapper objectMapper = new ObjectMapper();
		Class<?> c = parameter.getParameterType();
		// 默认参数类型：java.util.Map
		if ("Map".equals(c.getSimpleName()))
			return json;
		return objectMapper.readValue(utils.obj2Str(json), c);
	}
}