/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class XlsxUtil {
    private static Logger LOG = LoggerFactory.getLogger(XlsxUtil.class);
    private String xFile;
    private Workbook workbook;
    private Sheet sheet;

    public XlsxUtil() {
    }

    public XlsxUtil(String xFile) {
        this.xFile = xFile;
        this.initWorkbook();
    }

    public XlsxUtil(InputStream inp) {
        this.initWorkbook(inp);
    }

    public void initWorkbook() {
        FileInputStream inp = null;
        try {
            inp = new FileInputStream(this.xFile);
            this.initWorkbook(inp);
        }
        catch (Exception e) {
            try {
                LOG.error("initWorkbook...{}", (Object)e.getMessage());
                this.newWorkbook();
            }
            catch (Throwable throwable) {
                XlsxUtil.close(inp);
                throw throwable;
            }
            XlsxUtil.close(inp);
        }
        XlsxUtil.close(inp);
    }

    public void initWorkbook(InputStream inp) {
        try {
            if (!inp.markSupported()) {
                inp = new PushbackInputStream(inp, 8);
            }
            this.initSheet(WorkbookFactory.create((InputStream)inp), 0);
        }
        catch (Exception e) {
            LOG.error("initWorkbook...{}", (Object)e.getMessage());
            this.newWorkbook();
        }
    }

    public void newWorkbook() {
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    private void initSheet(Workbook workbook, int index) {
        this.workbook = workbook;
        this.sheet = workbook.getSheetAt(index);
    }

    public synchronized List<Map<String, String>> readExcel(String file, int startRow, Map<String, Integer> header) {
        ArrayList<Map<String, String>> dataList = new ArrayList();
        XlsxUtil excel = new XlsxUtil(file);
        dataList = excel.getDataByRow(startRow, header);
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeExcel(String file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.writeExcel(out);
            out.flush();
        }
        catch (Exception e) {
            try {
                LOG.error("writeExcel....{}", (Object)file);
            }
            catch (Throwable throwable) {
                XlsxUtil.close(out);
                throw throwable;
            }
            XlsxUtil.close(out);
        }
        XlsxUtil.close(out);
    }

    public synchronized void writeExcel(OutputStream out) throws IOException {
        this.workbook.write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> readExcel(MultipartFile file, int startRow, Map<String, Integer> header) {
        ArrayList<Map<String, String>> dataList = new ArrayList();
        XlsxUtil xlsx = new XlsxUtil();
        InputStream inp = null;
        try {
            inp = file.getInputStream();
            xlsx.initWorkbook(inp);
            dataList = xlsx.getDataByRow(startRow, header);
        }
        catch (Exception e) {
            LOG.error("readExcel...{}", (Object)e.getMessage());
        }
        finally {
            XlsxUtil.close(inp);
        }
        return dataList;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            LOG.error("close...{}", (Object)e.getMessage());
        }
    }

    public void shiftRows(int startRow, int endRow, int rows) {
        this.sheet.shiftRows(startRow, endRow, rows, true, false);
    }

    public void cloneBlankRow(int curRow, int oriRow) {
        Row insertRow = this.sheet.createRow(curRow);
        Row originRow = this.sheet.getRow(oriRow);
        insertRow.setHeight(originRow.getHeight());
        CellStyle rowStyle = originRow.getRowStyle();
        if (rowStyle != null) {
            insertRow.setRowStyle(rowStyle);
        }
        this.cloneMergedRegion(curRow, oriRow);
    }

    public void cloneMergedRegion(int curRow, int oriRow) {
        for (int i = 0; i < this.sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = this.sheet.getMergedRegion(i);
            if (region.getFirstRow() != oriRow) continue;
            int rows = region.getLastRow() - oriRow;
            CellRangeAddress newRegion = new CellRangeAddress(curRow, curRow + rows, region.getFirstColumn(), region.getLastColumn());
            this.sheet.addMergedRegion(newRegion);
        }
    }

    public void removeExcelRow(int curRow, int rows) {
        int endRow = curRow + rows;
        for (int i = this.sheet.getNumMergedRegions() - 1; i >= 0; --i) {
            CellRangeAddress region = this.sheet.getMergedRegion(i);
            if (region.getFirstRow() < curRow || region.getFirstRow() >= endRow) continue;
            this.sheet.removeMergedRegion(i);
        }
        this.sheet.shiftRows(endRow, this.sheet.getLastRowNum() + 1, -rows, true, false);
    }

    public List<Map<String, String>> getDataByRow(int startRow, Map<String, Integer> header) {
        Row row;
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        if (header == null || header.isEmpty()) {
            return dataList;
        }
        for (int i = startRow; i <= this.sheet.getLastRowNum() && (row = this.sheet.getRow(i)) != null; ++i) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            for (Map.Entry<String, Integer> e : header.entrySet()) {
                if ("".equals(e.getKey())) continue;
                Cell cell = row.getCell(e.getValue().intValue());
                rowMap.put(e.getKey(), this.getCellValue(cell));
            }
            dataList.add(rowMap);
        }
        return dataList;
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = DateUtil.getJavaDate((double)d);
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                }
                return this.decimal2Text(d);
            }
            case FORMULA: {
                return this.decimal2Text(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        return "";
    }

    private String decimal2Text(double d) {
        String _val = NumberToTextConverter.toText((double)d);
        if (_val.indexOf(69) > 0) {
            String[] ss = _val.split("E");
            int len = ss[0].split("\\.")[1].length();
            int n = Math.abs(Integer.parseInt(ss[1]));
            boolean isMinus = ss[1].indexOf(45) == 0;
            len = isMinus ? len + n : len - n;
            BigDecimal bd = new BigDecimal(_val);
            if (len > 0) {
                bd.setScale(len, 4);
                return bd.toPlainString();
            }
            return String.valueOf(bd.longValue());
        }
        return _val.replaceAll("\\.0+$", "");
    }

    public String getCellValue(int rowNo, int colNo) {
        Row row = this.sheet.getRow(rowNo);
        if (row == null) {
            return "";
        }
        Cell cell = row.getCell(colNo);
        return this.getCellValue(cell);
    }

    public void setCellValue(int rowNo, int colNo, String value) {
        Cell cell;
        Row row = this.sheet.getRow(rowNo);
        if (row == null) {
            row = this.sheet.createRow(rowNo);
        }
        if ((cell = row.getCell(colNo)) == null) {
            cell = row.createCell(colNo);
        }
        cell.setCellValue(value);
    }

    public float[] getColWidth(int maxColNum) {
        float[] widths = new float[maxColNum];
        for (int j = 0; j < maxColNum; ++j) {
            widths[j] = this.sheet.getColumnWidthInPixels(j);
        }
        return widths;
    }

    public int getMaxRowNum() {
        return this.sheet.getLastRowNum();
    }

    public int getMaxColNum(int rowNum) {
        short maxColNum = 0;
        for (int i = 0; i < rowNum; ++i) {
            short colNum;
            Row row = this.sheet.getRow(i);
            if (row == null || (colNum = row.getLastCellNum()) <= maxColNum) continue;
            maxColNum = colNum;
        }
        return maxColNum;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Row getRow(int i) {
        return this.sheet.getRow(i);
    }

    public String getFile() {
        return this.xFile;
    }
}

