/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.ConfUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext appCtx = null;
    private static SpringContext myself = null;

    public static synchronized SpringContext init() {
        if (myself == null) {
            myself = new SpringContext();
        }
        return myself;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (appCtx == null) {
            appCtx = ctx;
            ConfUtil.initGconf();
        }
    }

    public static ApplicationContext getApplicationContext() {
        return appCtx;
    }

    public static synchronized Object getBean(String beanName) {
        return appCtx.getBean(beanName);
    }

    public static synchronized <T> T getBean(Class<T> clazz) {
        return (T)appCtx.getBean(clazz);
    }

    public static synchronized <T> T getBean(String name, Class<T> clazz) {
        return (T)appCtx.getBean(name, clazz);
    }
}

