/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.DigitTools;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Digest {
    private static Logger LOG = LoggerFactory.getLogger(Digest.class);
    private static final String CHARS64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final byte[] SEED11 = new byte[]{68, 70, 74, 75, 77, 81, 83, 86, 87, 88, 90};
    private static ScriptEngine SE = null;
    private static Random rand = new Random();
    public static final String PUB_KEY = "pubk";
    public static final String PRI_KEY = "prik";
    static X9ECParameters sm2p256v1 = GMNamedCurves.getByName((String)"sm2p256v1");
    static ECDomainParameters domainParams = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());

    static String seed() {
        return new String(SEED11);
    }

    public static String randInt(int len) {
        StringBuffer buf = new StringBuffer();
        while (len-- > 0) {
            buf.append(rand.nextInt(10));
        }
        return buf.toString();
    }

    public static String randKey(int len) {
        StringBuffer buf = new StringBuffer();
        while (len-- > 0) {
            buf.append(CHARS64.charAt(rand.nextInt(62)));
        }
        return buf.toString();
    }

    public static String randKey() {
        return Digest.randStr(SEED11, 11);
    }

    public static String randStr(int len) {
        return Digest.randStr(CHARS64.substring(0, len), len);
    }

    public static String randStr(String src) {
        return Digest.randStr(src, src.length());
    }

    public static String randStr(String src, int len) {
        return Digest.randStr(src.getBytes(StandardCharsets.UTF_8), len);
    }

    private static String randStr(byte[] srcData, int len) {
        for (int i = 0; i < len; ++i) {
            int idx = rand.nextInt(srcData.length);
            if (idx == i) continue;
            byte c = srcData[idx];
            srcData[idx] = srcData[i];
            srcData[i] = c;
        }
        return new String(Arrays.copyOf(srcData, len));
    }

    public static String certStr(String src, String key) {
        String s = src + key;
        return s.toUpperCase() + s.toLowerCase() + CHARS64.substring(52);
    }

    public static String certStr(String key) {
        if (key == null) {
            return CHARS64;
        }
        if (key.length() == 26) {
            return Digest.certStr(key, "");
        }
        if (key.length() > 64) {
            return key;
        }
        return Digest.certStr("uncopyrightable", key);
    }

    public static String decrypt(String src) {
        return Digest.decrypt(src, CHARS64);
    }

    public static byte[] decrypt(char[] arr) {
        return Digest.decrypt(arr, CHARS64);
    }

    public static String decrypt(String src, String cert) {
        if (src == null) {
            return src;
        }
        byte[] bytes = Digest.decrypt(src.toCharArray(), cert);
        return new String(bytes);
    }

    public static byte[] decrypt(char[] arr, String cert) {
        int len;
        String key = Digest.certStr(cert);
        char pad = key.charAt(key.length() - 1);
        for (len = arr.length - 1; len > 0 && arr[len] == pad; --len) {
        }
        len = arr.length * 6 / 8 - (arr.length - 1 - len);
        byte[] raw = new byte[len];
        int[] quad = new int[4];
        int rawIdx = 0;
        for (int i = 0; i < arr.length; i += 4) {
            int block = 0;
            for (int idx = 0; idx < 4; ++idx) {
                char c = arr[i + idx];
                quad[idx] = c == pad ? 0 : key.indexOf(c);
                block += quad[idx] << 6 * (3 - idx);
            }
            for (int b = 0; b < 3 && rawIdx + b < raw.length; ++b) {
                raw[rawIdx + b] = (byte)(block >> 8 * (2 - b) & 0xFF);
            }
            rawIdx += 3;
        }
        return raw;
    }

    public static String encrypt(String src) {
        return Digest.encrypt(src.getBytes(StandardCharsets.UTF_8));
    }

    public static String encrypt(byte[] bytes) {
        return Digest.encrypt(bytes, CHARS64.getBytes());
    }

    public static String encrypt(String src, String cert) {
        if (src == null) {
            return null;
        }
        return Digest.encrypt(src.getBytes(StandardCharsets.UTF_8), cert);
    }

    public static String encrypt(byte[] bytes, String cert) {
        return Digest.encrypt(bytes, Digest.certStr(cert).getBytes());
    }

    private static String encrypt(byte[] bytes, byte[] keys) {
        byte[] out = new byte[(bytes.length + 2) / 3 * 4];
        int i = 0;
        int idx = 0;
        while (i < bytes.length) {
            int b;
            boolean[] trip = new boolean[]{true, false, false};
            int bit = 0xFF & bytes[i];
            for (b = 1; b < 3; ++b) {
                bit <<= 8;
                if (i >= bytes.length - b) continue;
                bit |= 0xFF & bytes[i + b];
                trip[b] = true;
            }
            for (b = 0; b < 3; ++b) {
                out[idx + 3 - b] = keys[trip[2 - b] ? bit & 0x3F : 64];
                bit >>= 6;
            }
            out[idx] = keys[bit & 0x3F];
            i += 3;
            idx += 4;
        }
        return out.length == 0 ? "" : new String(out);
    }

    private static String jsEval(String src) {
        if (SE == null) {
            SE = new ScriptEngineManager().getEngineByExtension("js");
        }
        try {
            src = String.valueOf(SE.eval(src));
        }
        catch (Exception e) {
            LOG.error("jsEval...{}", (Object)src);
        }
        return src;
    }

    @Deprecated
    public static String escape(String src) {
        return Digest.jsEval("escape('" + src + "')");
    }

    @Deprecated
    public static String unescape(String src) {
        return Digest.jsEval("unescape('" + src + "')");
    }

    @Deprecated
    public static String decodeURIComponent(String src) {
        return Digest.jsEval("decodeURIComponent('" + src + "')");
    }

    @Deprecated
    public static String encodeURIComponent(String src) {
        return Digest.jsEval("encodeURIComponent('" + src + "')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean imgDecode(String src, String imgName) {
        FileOutputStream out = null;
        boolean result = false;
        try {
            out = new FileOutputStream(imgName);
            ((OutputStream)out).write(Digest.imgDecode(src));
            out.flush();
            result = true;
        }
        catch (Exception e) {
            try {
                LOG.error("imgDecode...{}", (Object)imgName);
            }
            catch (Throwable throwable) {
                Digest.close(out);
                throw throwable;
            }
            Digest.close(out);
        }
        Digest.close(out);
        return result;
    }

    public static byte[] imgDecode(String src) {
        String[] arr = src.split(",");
        return Digest.decode(arr.length == 1 ? arr[0] : arr[1]);
    }

    private static byte[] decode(String src) {
        return Base64.getDecoder().decode(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imgEncode(String imgFile) {
        byte[] bytes = null;
        FileInputStream inp = null;
        try {
            inp = new FileInputStream(imgFile);
            bytes = new byte[((InputStream)inp).available()];
            ((InputStream)inp).read(bytes);
        }
        catch (IOException e) {
            try {
                LOG.error("imgEncode...{}", (Object)imgFile);
                bytes = new byte[]{};
            }
            catch (Throwable throwable) {
                Digest.close(inp);
                throw throwable;
            }
            Digest.close(inp);
        }
        Digest.close(inp);
        return Digest.encode(bytes);
    }

    private static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            LOG.error("close...{}", (Object)e.getMessage());
        }
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            LOG.error("urlDecode...{}", (Object)url);
            return url;
        }
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            LOG.error("urlEncode...{}", (Object)url);
            return url;
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid8() {
        return Digest.uuid8(0);
    }

    public static String uuid8(int incr) {
        char c = CHARS64.charAt(rand.nextInt(62));
        return Digest.enBase62(System.currentTimeMillis() + (long)incr) + c;
    }

    public static long deBase64(String src) {
        return Digest.deBase(src, 64);
    }

    public static String deBase62(String src, int n) {
        String s = src.substring(0, src.length() - n);
        return Digest.deBase62(s) + src.substring(src.length() - n);
    }

    public static long deBase62(String src) {
        return Digest.deBase(src, 62);
    }

    private static long deBase(String src, int n) {
        long result = 0L;
        long radix = 1L;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(src.length() - 1 - i);
            result += (long)CHARS64.indexOf(c) * radix;
            radix *= (long)n;
        }
        return result;
    }

    public static String enBase64(long num) {
        return Digest.enBase(num, 64);
    }

    public static String enBase62(String src, int n) {
        try {
            long l = Long.valueOf(src.substring(0, src.length() - n));
            return Digest.enBase62(l) + src.substring(src.length() - n);
        }
        catch (Exception e) {
            LOG.error("enBase62...{}", (Object)src);
            return null;
        }
    }

    public static String enBase62(long num) {
        return Digest.enBase(num, 62);
    }

    private static String enBase(long num, int n) {
        if (num == 0L) {
            return "A";
        }
        StringBuffer buf = new StringBuffer();
        while (num > 0L) {
            buf.append(CHARS64.charAt(new Long(num % (long)n).intValue()));
            num /= (long)n;
        }
        return buf.reverse().toString();
    }

    public static String getChr3(int num) {
        if (num < 1000) {
            return String.format("%03d", num);
        }
        StringBuffer buf = new StringBuffer();
        if (num < 12960) {
            int bit = (num -= 1000) / 1196;
            String s = Digest.getChr2((num + 100 * (bit + 1)) % 1296);
            buf.append(Digest.getChr(bit)).append(s);
        } else if (num < 46656) {
            buf.append(Digest.getChr(num / 1296)).append(Digest.getChr2(num % 1296));
        }
        return buf.length() > 0 ? buf.toString() : "---";
    }

    public static String getChr2(int num) {
        if (num < 100) {
            return String.format("%02d", num);
        }
        StringBuffer buf = new StringBuffer();
        if (num < 360) {
            buf.append(Digest.getChr(num / 10)).append(Digest.getChr(num % 10));
        } else if (num < 1296) {
            buf.append(Digest.getChr((num -= 360) / 26)).append(Digest.getChr(num % 26 + 10));
        }
        return buf.length() > 0 ? buf.toString() : "--";
    }

    public static char getChr(int num) {
        return (char)(num < 10 ? num + 48 : (num < 36 ? num + 55 : 45));
    }

    public static String md5(String str) {
        return DigestUtils.md5Hex((String)str);
    }

    @Deprecated
    public static String aesEncrypt(String plainText, String key) throws Exception {
        Cipher c = Digest.aesCipher(key, 1);
        byte[] result = plainText.getBytes(StandardCharsets.UTF_8);
        return Digest.encode(c.doFinal(result));
    }

    @Deprecated
    public static String aesDecrypt(String cipherText, String key) throws Exception {
        Cipher cipher = Digest.aesCipher(key, 2);
        byte[] bytes = cipher.doFinal(Digest.decode(cipherText));
        return new String(bytes);
    }

    @Deprecated
    private static Cipher aesCipher(String key, int mode) throws Exception {
        Cipher AES = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
        AES.init(mode, keySpec);
        return AES;
    }

    private static Cipher sm4Cipher(String key, int mode) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher sm4 = Cipher.getInstance("SM4/ECB/PKCS5Padding", "BC");
        byte[] keyBytes = DigitTools.hex2Bytes(key);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "SM4");
        sm4.init(mode, keySpec);
        return sm4;
    }

    public static String sm4Encrypt(String plainText, String salt) {
        try {
            Cipher cipher = Digest.sm4Cipher(salt, 1);
            byte[] bytes = plainText.getBytes(StandardCharsets.UTF_8);
            return DigitTools.toHexStr(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            LOG.error("sm4Encrypt...{}", (Object)plainText);
            return null;
        }
    }

    public static String sm4Decrypt(String cipherText, String salt) {
        try {
            byte[] bytes = DigitTools.hex2Bytes(cipherText);
            Cipher cipher = Digest.sm4Cipher(salt, 2);
            return new String(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            LOG.error("sm4Encrypt...{}", (Object)salt);
            return null;
        }
    }

    public static String genRawKey() {
        String spec = "";
        for (int i = 0; i < 32; ++i) {
            spec = spec + Integer.toHexString(rand.nextInt(16));
        }
        return spec;
    }

    public static String sm3(String src) {
        SM3Digest sm3 = new SM3Digest();
        byte[] data = src.getBytes(StandardCharsets.UTF_8);
        byte[] hash = new byte[sm3.getDigestSize()];
        sm3.update(data, 0, data.length);
        sm3.doFinal(hash, 0);
        return Hex.toHexString((byte[])hash);
    }

    public static String sm3(String src, String key) {
        HMac hMac = new HMac((org.bouncycastle.crypto.Digest)new SM3Digest());
        byte[] data = src.getBytes(StandardCharsets.UTF_8);
        byte[] hash = new byte[hMac.getMacSize()];
        hMac.init((CipherParameters)new KeyParameter(key.getBytes()));
        hMac.update(data, 0, data.length);
        hMac.doFinal(hash, 0);
        return Hex.toHexString((byte[])hash);
    }

    public static Map<String, String> genSm2Pair() {
        ECKeyPairGenerator kpg = new ECKeyPairGenerator();
        SecureRandom rand = new SecureRandom();
        kpg.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParams, rand));
        AsymmetricCipherKeyPair keyPair = kpg.generateKeyPair();
        ECPoint ecp = ((ECPublicKeyParameters)keyPair.getPublic()).getQ();
        BigInteger bi = ((ECPrivateKeyParameters)keyPair.getPrivate()).getD();
        HashMap<String, String> keysMap = new HashMap<String, String>();
        keysMap.put(PUB_KEY, Hex.toHexString((byte[])ecp.getEncoded(true)));
        keysMap.put(PRI_KEY, bi.toString(16));
        return keysMap;
    }

    public static String sm2Encrypt(String plainText, String pubKey) {
        byte[] data = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] pubK = Hex.decode((String)pubKey);
        ECPoint ecp = sm2p256v1.getCurve().decodePoint(pubK);
        ECPublicKeyParameters pk = new ECPublicKeyParameters(ecp, domainParams);
        SM2Engine sm2 = new SM2Engine(SM2Engine.Mode.C1C2C3);
        sm2.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pk));
        try {
            data = sm2.processBlock(data, 0, data.length);
            return Hex.toHexString((byte[])data);
        }
        catch (Exception e) {
            LOG.error("sm2Encrypt...{}", (Object)plainText);
            return null;
        }
    }

    public static String sm2Decrypt(String cipherText, String priKey) {
        byte[] data = Hex.decode((String)cipherText);
        BigInteger bi = new BigInteger(priKey, 16);
        ECPrivateKeyParameters pk = new ECPrivateKeyParameters(bi, domainParams);
        SM2Engine sm2 = new SM2Engine(SM2Engine.Mode.C1C2C3);
        sm2.init(false, (CipherParameters)pk);
        try {
            data = sm2.processBlock(data, 0, data.length);
            return new String(data);
        }
        catch (Exception e) {
            LOG.error("sm2Decrypt...{}", (Object)cipherText);
            return null;
        }
    }
}

