/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.SpringContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfUtil {
    private static Logger LOG = LoggerFactory.getLogger(ConfUtil.class);
    private static ResourceBundle CONF = ResourceBundle.getBundle("config");
    private static ResourceBundle PARAM = ResourceBundle.getBundle("params");
    private static ResourceBundle VALID = ResourceBundle.getBundle("valid");
    private static Map<String, String> GCONF = new HashMap<String, String>();
    public static final String JSONSTR = "jsonstr";
    public static final String APPCODE = "appCode";
    public static final String IPADDR = "ipaddr";
    public static final String TICKET = "ticket";
    public static final String TOKEN = "token";
    public static final String CERT_K = "k";
    public static final String COMMA = ",|;";
    public static final String TRACEID = "traceId";
    public static final String CERTID = "certId";
    public static final String COMPID = "compId";
    public static final String USERID = "userId";
    public static final String INVD_PARAMS = "invalidParams";
    public static final String CANT_REMOVE = "cantRemove";
    public static final String CANT_UPDATE = "cantUpdate";
    public static final String OVER_COUNTS = "overCounts";
    public static final String DENY_ACCESS = "denyAccess";
    public static final String DUPL_NAME = "duplicateName";
    public static final String DUPL_DATA = "dataDuplicate";
    public static final String DATA_COLL = "dataCollision";
    private static boolean usingGconf = false;
    static String APP_KEY = "www.ps1.cn";
    static String APP_CODE = "";
    static String APP_CORE = "";
    static String APP_MAIN = "/main";
    static String[] APP_SPEC = new String[0];
    static String BASE_DBID = "baseId";
    static String BASE_DOT = ".";
    static String BASE_NAME = "";
    static String BASE_MAIN = "";
    static String[] I18N_LOCALES = new String[]{"ZH", "EN"};
    static String SSO_URL = "";
    static String VALID_MUST = "";
    static String LIMIT_ROWS = "2999";
    static int HTTP_TIMEOUT = 120000;
    static int CACHE_TIME = 7200;
    static int CODE_EXPIRED = 600;
    static boolean API_PERMIT = false;
    static boolean IS_TRACKING = false;
    static boolean IS_API_OPEN = false;
    static boolean IS_ENC_RESP = false;
    static boolean IS_LOG_RESP = false;
    static boolean IS_ENC_OMIT = false;
    static int IS_LOG_ARGS = 0;
    static boolean IS_MULTI_LOGIN = false;
    static boolean IS_CUSTOM_COLS = false;
    static boolean AVOID_RULES = false;
    public static String REGEXP = " regexp";
    public static String RLIKE = " rlike";
    public static String[] SQL_EXPR = new String[]{"=", ">", "<", ">=", "<=", "<>", "!=", "regexp", "rlike", "is", "not", "null", "and", "or", "like", "in", "(", ")", "between", "length(", "json_extract("};

    public static String appKey() {
        return APP_KEY;
    }

    public static String appCode() {
        return APP_CODE;
    }

    public static String appCore() {
        return APP_CORE;
    }

    public static String appMain() {
        return APP_MAIN;
    }

    public static String[] appSpec() {
        return APP_SPEC;
    }

    public static String dbid() {
        return BASE_DBID;
    }

    public static String baseDot() {
        return BASE_DOT;
    }

    public static String baseName() {
        return BASE_NAME;
    }

    public static String baseMain() {
        return BASE_MAIN;
    }

    public static String[] locales() {
        return I18N_LOCALES;
    }

    public static String ssoUrl() {
        return SSO_URL;
    }

    public static String mustValid() {
        return VALID_MUST;
    }

    public static String limitRows() {
        return LIMIT_ROWS;
    }

    public static int httpTimeout() {
        return HTTP_TIMEOUT;
    }

    public static int cacheTime() {
        return CACHE_TIME;
    }

    public static int vcodeDue() {
        return CODE_EXPIRED;
    }

    public static boolean apiPermit() {
        return API_PERMIT;
    }

    public static boolean isTracking() {
        return IS_TRACKING;
    }

    public static boolean isApiOpen() {
        return IS_API_OPEN;
    }

    public static boolean isEncResp() {
        return IS_ENC_RESP;
    }

    public static boolean isLogResp() {
        return IS_LOG_RESP;
    }

    public static boolean isEncOmit() {
        return IS_ENC_OMIT;
    }

    public static int logArgs() {
        return IS_LOG_ARGS;
    }

    public static boolean isMultLogin() {
        return IS_MULTI_LOGIN;
    }

    public static boolean isCustomCols() {
        return IS_CUSTOM_COLS;
    }

    public static boolean avoidRules() {
        return AVOID_RULES;
    }

    public static void initGconf() {
        String cnf = ConfUtil.conf("app.gconf", "");
        boolean bl = usingGconf = !"".equals(cnf);
        if (usingGconf) {
            ConfUtil.initGconf(ConfUtil.invoke(null, "appGconf", cnf));
        } else {
            APP_KEY = ConfUtil.conf("app.key", APP_KEY);
            APP_CODE = ConfUtil.conf("app.code", APP_CODE);
            APP_CORE = ConfUtil.conf("app.core", APP_CORE);
            APP_MAIN = ConfUtil.conf("app.main", APP_MAIN);
            APP_SPEC = ConfUtil.conf("app.spec", "").split(":");
            BASE_DBID = ConfUtil.conf("base.dbid", BASE_DBID);
            BASE_DOT = ConfUtil.conf("base.dot", ".");
            BASE_NAME = ConfUtil.conf("base.name", "");
            BASE_MAIN = ConfUtil.conf("base.main", "");
            I18N_LOCALES = ConfUtil.conf("i18n.locales", "ZH,EN").split(COMMA);
            SSO_URL = ConfUtil.conf("sso.url", "");
            VALID_MUST = ConfUtil.conf("valid.must", "");
            LIMIT_ROWS = ConfUtil.conf("limit.rows", LIMIT_ROWS);
            HTTP_TIMEOUT = ConfUtil.conf("http.timeout", 90000);
            CACHE_TIME = ConfUtil.conf("cache.time", 7200);
            CODE_EXPIRED = ConfUtil.conf("code.expired", 600);
            API_PERMIT = ConfUtil.conf("api.permit", "").length() > 0;
            IS_TRACKING = ConfUtil.conf("app.trace", "").length() > 0;
            IS_API_OPEN = ConfUtil.conf("api.open", "").length() > 0;
            IS_ENC_RESP = ConfUtil.conf("enc.resp", "").length() > 0;
            IS_LOG_RESP = ConfUtil.conf("log.resp", "").length() > 0;
            IS_ENC_OMIT = ConfUtil.conf("enc.omit", "").length() > 0;
            IS_LOG_ARGS = Integer.parseInt(ConfUtil.conf("log.args", "0"));
            IS_MULTI_LOGIN = ConfUtil.conf("multi.login", "").length() > 0;
            IS_CUSTOM_COLS = ConfUtil.conf("cols.custom", "").length() > 0;
            AVOID_RULES = ConfUtil.conf("avoid.rules", "").length() > 0;
            REGEXP = ConfUtil.conf("sql.regexp", REGEXP);
            RLIKE = ConfUtil.conf("sql.rlike", RLIKE);
            cnf = ConfUtil.conf("sql.expr", "");
            if (cnf.length() > 0) {
                SQL_EXPR = cnf.split(COMMA);
            }
        }
    }

    private static void initGconf(Object res) {
        GCONF = ConfUtil.obj2Map(res);
        if (GCONF.isEmpty()) {
            LOG.error("initGconf... GCONF is null");
            return;
        }
        LOG.info("getConf()...{}", GCONF);
        LOG.info("------------");
        APP_KEY = ConfUtil.gconf("app.key", APP_KEY);
        APP_KEY = ConfUtil.gconf("app.key", APP_KEY);
        APP_CODE = ConfUtil.gconf("app.code", APP_CODE);
        APP_CORE = ConfUtil.gconf("app.core", APP_CORE);
        APP_MAIN = ConfUtil.gconf("app.main", APP_MAIN);
        APP_SPEC = ConfUtil.gconf("app.spec", "").split(":");
        BASE_DBID = ConfUtil.gconf("base.dbid", BASE_DBID);
        BASE_DOT = ConfUtil.gconf("base.dot", ".");
        BASE_NAME = ConfUtil.gconf("base.name", "");
        BASE_MAIN = ConfUtil.gconf("base.main", "");
        I18N_LOCALES = ConfUtil.gconf("i18n.locales", "ZH,EN").split(COMMA);
        SSO_URL = ConfUtil.gconf("sso.url", "");
        VALID_MUST = ConfUtil.gconf("valid.must", "");
        LIMIT_ROWS = ConfUtil.gconf("limit.rows", LIMIT_ROWS);
        HTTP_TIMEOUT = ConfUtil.gconf("http.timeout", 90000);
        CACHE_TIME = ConfUtil.gconf("cache.time", 7200);
        CODE_EXPIRED = ConfUtil.gconf("code.expired", 600);
        API_PERMIT = ConfUtil.gconf("api.permit", "").length() > 0;
        IS_TRACKING = ConfUtil.gconf("app.trace", "").length() > 0;
        IS_API_OPEN = ConfUtil.gconf("api.open", "").length() > 0;
        IS_ENC_RESP = ConfUtil.gconf("enc.resp", "").length() > 0;
        IS_LOG_RESP = ConfUtil.gconf("log.resp", "").length() > 0;
        IS_ENC_OMIT = ConfUtil.gconf("enc.omit", "").length() > 0;
        IS_LOG_ARGS = Integer.parseInt(ConfUtil.gconf("log.args", "0"));
        IS_MULTI_LOGIN = ConfUtil.gconf("multi.login", "").length() > 0;
        IS_CUSTOM_COLS = ConfUtil.gconf("cols.custom", "").length() > 0;
        AVOID_RULES = ConfUtil.gconf("avoid.rules", "").length() > 0;
        REGEXP = ConfUtil.gconf("sql.regexp", REGEXP);
        RLIKE = ConfUtil.gconf("sql.rlike", RLIKE);
        String cnf = ConfUtil.gconf("sql.expr", "");
        if (cnf.length() > 0) {
            SQL_EXPR = cnf.split(COMMA);
        }
    }

    private static String gconf(String key, String def) {
        String val = GCONF.get(key);
        return val == null || "".equals(val) ? def : val;
    }

    private static int gconf(String key, int def) {
        String val = GCONF.get(key);
        return ConfUtil.isInt(val) ? Integer.parseInt(val) : def;
    }

    public static boolean dataIsolation() {
        return "0".equals(ConfUtil.baseDot());
    }

    public static Object invoke(Object bean, String method, Object args) {
        try {
            if (bean == null) {
                bean = SpringContext.getBean("gconfService");
            }
            Method m = bean.getClass().getMethod(method, Object.class);
            return m.invoke(bean, args);
        }
        catch (Exception e) {
            LOG.error("invoke....{}({})", (Object)method, args);
            return null;
        }
    }

    public static String getConf(String key) {
        return ConfUtil.getConf(key, "");
    }

    public static String getConf(String key, String def) {
        return usingGconf ? ConfUtil.gconf(key, def) : ConfUtil.getProp(CONF, key, def);
    }

    public static int getInt(String key, int def) {
        String val = ConfUtil.get(key, "");
        return ConfUtil.isInt(val) ? Integer.parseInt(val) : def;
    }

    public static String get(String key, String def) {
        return usingGconf ? ConfUtil.gconf(key, def) : ConfUtil.getProp(CONF, key, def);
    }

    public static String get(String key) {
        return ConfUtil.get(key, "");
    }

    public static String getParam(String key) {
        return ConfUtil.getProp(PARAM, key, "");
    }

    public static String getValid(String key) {
        return ConfUtil.getProp(VALID, key, "");
    }

    private static String getProp(ResourceBundle rb, String key, String def) {
        try {
            return rb.getString(key);
        }
        catch (Exception e) {
            LOG.debug("getProp...{}", (Object)e.getMessage());
            return def;
        }
    }

    private static String conf(String key, String def) {
        return ConfUtil.getProp(CONF, key, def);
    }

    private static int conf(String key, int def) {
        String val = ConfUtil.getProp(CONF, key, "");
        return ConfUtil.isInt(val) ? Integer.parseInt(val) : def;
    }

    public static <T> Map<String, T> obj2Map(Object data) {
        return data instanceof Map ? (Map)data : new HashMap();
    }

    public static boolean isInt(String s) {
        return s != null && Pattern.matches("-?\\d+", s);
    }
}

