/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.UtilsService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XfileService {
    @Autowired
    private UtilsService utils;

    public <T> String getFilePath(Map<String, T> map, String[] keys) {
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(map.get(key) + File.separator);
        }
        return sb.toString();
    }

    public String getFileName(String file) {
        return file.substring(file.lastIndexOf(File.separator));
    }

    public String makeFileName(Object name, Object ext) {
        return name + "." + ext;
    }

    public boolean overSize(long kiloByte, String limit) {
        String[] unit = new String[]{"K", "M", "G", "T", "P"};
        if (!this.utils.isEmpty(limit)) {
            limit = limit.toUpperCase();
            for (int i = 0; i < unit.length; ++i) {
                if (limit.indexOf(unit[i]) < 1) continue;
                if (!this.utils.isInteger(limit = limit.split(unit[i])[0])) {
                    return false;
                }
                return (kiloByte = (long)((double)kiloByte / Math.pow(1024.0, i))) > (long)Integer.parseInt(limit);
            }
            return this.utils.isInteger(limit) && kiloByte > (long)Integer.parseInt(limit);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write2Resp(String file, HttpServletResponse resp, String header, String contentType) {
        FileInputStream inp = null;
        BufferedOutputStream out = null;
        boolean isSuccess = true;
        try {
            inp = new FileInputStream(file);
            byte[] bytes = new byte[((InputStream)inp).available()];
            ((InputStream)inp).read(bytes);
            String fileName = this.getFileName(file);
            resp.reset();
            resp.addHeader("Content-Disposition", header + fileName);
            resp.addIntHeader("Content-Length", bytes.length);
            resp.setContentType(contentType);
            out = new BufferedOutputStream((OutputStream)resp.getOutputStream());
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).flush();
            this.utils.close(inp, out);
        }
        catch (IOException e) {
            isSuccess = false;
        }
        finally {
            this.utils.close(inp, out);
        }
        return isSuccess;
    }
}

