/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;
    @Autowired
    private HttpServletRequest req;

    public boolean thirdLogin(HttpServletResponse rsp, Map<String, String> cookies) {
        if (!cookies.containsKey("bindId") || cookies.containsKey("userId")) {
            // empty if block
        }
        return false;
    }

    private boolean verifyKey(String K) {
        return ConfUtil.appKey().equals(K);
    }

    public boolean verifySecret() {
        String jsonStr = this.req.getParameter("jsonstr");
        String k = this.req.getParameter("k");
        if (this.verifyKey(k)) {
            if (jsonStr == null) {
                return true;
            }
            return this.setJsonAttr(this.utils.json2Map(jsonStr));
        }
        String ticket = this.req.getParameter("ticket");
        if (ticket != null) {
            return this.verifyApiKey(jsonStr, ticket);
        }
        if (k == null) {
            return false;
        }
        String priKey = this.redis.getCertKey(k);
        if (priKey != null && jsonStr != null && (jsonStr = Digest.sm2Decrypt(jsonStr, priKey)) != null) {
            return this.setJsonAttr(this.utils.json2Map(jsonStr));
        }
        LOG.warn("Auth failed > {} : {}", (Object)k, (Object)ConfUtil.appKey());
        return false;
    }

    private boolean verifyApiKey(String jsonStr, String ticket) {
        Map<String, Object> params;
        if (!ConfUtil.isApiOpen() || jsonStr == null) {
            return false;
        }
        String spec = this.redis.get("a." + ticket);
        if (spec == null) {
            Object res = ConfUtil.invoke(null, "appCert", ticket);
            Map cert = this.utils.obj2Map(res);
            spec = (String)cert.get("certKey");
            if (spec == null) {
                return false;
            }
            this.redis.set("a." + ticket, spec, this.getSecond());
        }
        if ((params = this.utils.json2Map(jsonStr = Digest.sm4Decrypt(jsonStr, spec))).isEmpty()) {
            return false;
        }
        return this.setJsonAttr(params);
    }

    private boolean setJsonAttr(Map<String, Object> params) {
        params.remove("base");
        Object dbid = params.get(ConfUtil.dbid());
        if (dbid != null) {
            if (Pattern.matches("\\w+", String.valueOf(dbid))) {
                if (ConfUtil.dataIsolation()) {
                    params.put("base", dbid);
                } else {
                    params.put("base", ConfUtil.baseName() + dbid + ConfUtil.baseDot());
                }
            }
            params.remove(ConfUtil.dbid());
        }
        if (!this.utils.findIn(ConfUtil.locales(), params.get("i18n"))) {
            params.put("i18n", this.getUserLang());
        }
        this.req.setAttribute("json", params);
        LOG.debug("setJsonAttr...{}", params);
        return true;
    }

    private String getUserLang() {
        String lang = this.utils.userSelf(this.req).get("userLang");
        if (this.utils.isEmpty(lang)) {
            lang = this.utils.getLocale(this.req).toUpperCase();
        }
        return lang;
    }

    public boolean authAccess(HttpServletResponse rsp, Map<String, String> token) throws Exception {
        String userId = token.get("userId");
        Map<String, String> user = this.redis.getUserInfo(userId);
        if (user == null) {
            this.redis.clearToken(token);
            return this.invlidToken(rsp);
        }
        Map<String, Object> params = this.decryptParams(user, token);
        if (params == null) {
            return this.invlidToken(rsp);
        }
        Object appCode = params.get("appCode");
        String serApp = ConfUtil.appCode();
        String uri = this.utils.getRequestURI(this.req);
        if (this.utils.isEmpty(appCode)) {
            if (serApp.length() > 0) {
                params.put("appCode", serApp);
                String role = this.trustedRole(params, user, uri);
                LOG.debug("trustedRole...{}", (Object)role);
                if (this.utils.isEmpty(role)) {
                    return this.denyAccess(rsp);
                }
            }
            this.requestParams(params);
        } else if (!this.ifPermit(serApp, appCode, uri)) {
            return this.denyAccess(rsp);
        }
        LOG.debug("request from {}.{}", (Object)uri, params);
        if (!this.checkParams(params, uri.substring(1))) {
            return this.invlidParams(rsp);
        }
        if (!this.isTenant(serApp, params.get(ConfUtil.dbid()), user)) {
            return this.invlidParams(rsp);
        }
        return this.setJsonAttr(params);
    }

    private void requestParams(Map<String, Object> params) {
        if (params.isEmpty()) {
            Enumeration map = this.req.getParameterNames();
            while (map.hasMoreElements()) {
                String key = (String)map.nextElement();
                params.put(key, this.req.getParameter(key));
            }
        }
    }

    private Map<String, Object> decryptParams(Map<String, String> user, Map<String, String> token) {
        String spec = token.get("certId");
        this.req.setAttribute("user", user);
        this.req.setAttribute("userId", (Object)user.get("userId"));
        this.req.setAttribute("certId", (Object)spec);
        String jsonStr = this.req.getParameter("jsonstr");
        return this.decryptParams(jsonStr, spec);
    }

    private Map<String, Object> decryptParams(String jsonStr, String spec) {
        if (!ConfUtil.isEncOmit() && !this.utils.isEmpty(jsonStr)) {
            jsonStr = Digest.sm4Decrypt(jsonStr, spec);
            LOG.debug("decryptParams...{}", (Object)jsonStr);
            if (jsonStr == null) {
                return null;
            }
        }
        return this.utils.json2Map(jsonStr);
    }

    private boolean checkParams(Map<?, ?> params, String uri) {
        String keys = ConfUtil.mustValid() + ConfUtil.getValid(uri);
        String[] keyArr = keys.split(",|;");
        return keys.length() == 0 || this.utils.availParams(params, keyArr);
    }

    private boolean ifPermit(String serApp, Object appCode, String uri) {
        if (serApp.length() == 0) {
            return true;
        }
        String app = String.valueOf(appCode);
        Object[] arr = new String[]{"a.", serApp, ".", app};
        String key = this.utils.join(arr);
        Map<String, String> permit = this.redis.hmget(key);
        if (permit == null) {
            permit = this.getActionPermit(serApp, app);
            LOG.debug("getActionPermit...{}", permit);
            if (permit.isEmpty()) {
                return false;
            }
            this.redis.hmset(key, permit, 7200);
        }
        return permit.containsKey(uri);
    }

    private boolean isTenant(String serApp, Object dbid, Map<String, String> user) {
        Map userBase;
        String tenantId;
        return serApp.length() <= 0 || dbid == null || this.utils.isEmpty(tenantId = (String)(userBase = this.utils.json2Map(user.get("userBase"))).get(serApp)) || "0".equals(tenantId) || tenantId.equals(dbid);
    }

    private Map<String, String> getActionPermit(String serApp, String appCode) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("actApp", serApp);
        where.put("actMark", "0");
        where.put("actState", "1");
        if (ConfUtil.apiPermit()) {
            String[] V = new String[]{"'1'", "'1'"};
            Object[] arr = new String[]{"({", "actPermit", "} is NULL OR ", this.utils.jsonExt("actPermit", appCode), "{} OR ", this.utils.jsonExt("actPermit", "all"), "{})"};
            where.put(this.utils.join(arr), V);
        }
        LOG.debug("getActionList...{}", where);
        List<Map<String, String>> list = this.aolai.findList("ACTION", where);
        return this.utils.list2Map(list, "actUri", "actState");
    }

    private String trustedRole(Map<String, Object> params, Map<String, String> user, String uri) {
        Map<String, Object> duty = this.aolai.getRoleParams(params, user);
        Object[] keys = new Object[]{params.get("appCode"), duty.get("compId"), duty.get("dutyId")};
        return this.redis.getActionRole(this.utils.join(keys, "."), uri);
    }

    private boolean invlidParams(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "2");
    }

    public boolean invlidToken(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "3");
    }

    private boolean denyAccess(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "5");
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter out = rsp.getWriter();
        out.write(this.utils.obj2Str(this.utils.result(status)));
        out.flush();
        out.close();
        return false;
    }

    private int getSecond() {
        String sec = this.req.getParameter("sec");
        return this.utils.isInteger(sec) ? Integer.parseInt(sec) : ConfUtil.cacheTime();
    }
}

