/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.dao.AolaiDao;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class GmetaService {
    private static Logger LOG = LoggerFactory.getLogger(GmetaService.class);
    static final String META = "GMETA";
    static final String META_SORT = "META_SORT";
    static final String TENANT = "TENANT";
    static final Pattern P_DIGIT = Pattern.compile("\\d+");
    static final Pattern P_QUOTE = Pattern.compile("\\{ *\\w+ *\\}");
    static final Pattern P_PLACE = Pattern.compile("\\{ *V* *\\}");
    static final Pattern P_JSON = Pattern.compile("^,'\\$(\\.\\w+)+'\\)$");
    static final String TYPE = "type";
    static final String PKEY = "pkey";
    static final String DUPL = "dupl";
    static final String M_PKEY = "!p";
    static final String M_I18N = "!i";
    static final String M_TYPE = "!t";
    static final String NULL = "null";
    static final String LEFT = "left";
    static final String DEFT = "default";
    static final String WHERE = "where";
    static final String ORDER = "order";
    static final String _S = "_";
    static final String _W = "\\w+";
    static final String CAST = "CAST(";
    static final String R_PAREN = "')";
    @Autowired
    AolaiDao dao;
    @Autowired
    RedisService redis;
    @Autowired
    UtilsService utils;
    @Autowired
    private ApplicationContext appCtx;
    static Map<String, String> gmeta = new HashMap<String, String>();

    boolean isPostgres() {
        return this.appCtx.containsBean("dsPostgres");
    }

    void setDataIsolation(Map<String, Object> cond, Object base, String table) {
        if (ConfUtil.dataIsolation()) {
            cond.put(this.tenantKey(table), base);
        }
    }

    String tenantKey(String table) {
        return table + _S + TENANT;
    }

    Map<String, String> addRecord(Object base, String table, Map<String, String> dto, Map<String, Object> data, boolean dupl) {
        data = this.setFieldData(dto, data, true);
        this.setDataIsolation(data, base, table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        if (dupl) {
            map.put(DUPL, this.getDuplPks(table, dto));
        }
        LOG.debug("addRecord...{}", data);
        return this.utils.result(this.dao.addOne(map, data) > 0);
    }

    private String getDuplPks(String table, Map<String, String> dto) {
        if (this.isPostgres()) {
            String pk = ConfUtil.dataIsolation() ? this.tenantKey(table) : "";
            return this.getMetaPks(dto, pk);
        }
        return "";
    }

    private String getMetaPks(Map<String, String> dto, String pk) {
        StringJoiner jt = new StringJoiner(",");
        if (pk.length() > 0) {
            jt.add(pk);
        }
        for (Map.Entry<String, String> e : dto.entrySet()) {
            if (!e.getKey().contains(M_PKEY) || !"1".equals(e.getValue())) continue;
            jt.add(dto.get(e.getKey().split("!")[0]));
        }
        return jt.toString();
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(base, table, this.getDto(table), data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data, boolean dupl) {
        return this.addRecord(null, table, data, dupl);
    }

    public Map<String, String> addRecord(String table, Map<String, Object> data) {
        return this.addRecord(null, table, data, false);
    }

    public Map<String, String> addRecord(Object base, String table, Map<String, Object> data) {
        return this.addRecord(base, table, data, false);
    }

    private Map<String, String> batchAdd(Object base, String table, Map<String, String> dto, List<Map<String, Object>> items, Object lang, boolean dupl) {
        if (items.size() == 0) {
            throw new FailedException();
        }
        Map<String, Object> data = items.get(0);
        data.put("i18n", lang);
        data = this.setFieldData(dto, data, false);
        if (ConfUtil.dataIsolation()) {
            data.put(this.tenantKey(table), TENANT);
        }
        for (Map<String, Object> item : items) {
            for (Map.Entry<String, Object> e : item.entrySet()) {
                this.validationRules(dto, e);
            }
            if (!ConfUtil.dataIsolation()) continue;
            item.put(TENANT, base);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        if (dupl) {
            map.put(DUPL, this.getDuplPks(table, dto));
        }
        LOG.debug("batchAdd...{}", map);
        return this.utils.result(this.dao.batchAdd(map, data, items) > 0);
    }

    public Map<String, String> batchAdd(Object base, String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(base, table, this.getDto(table), items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map, boolean dupl) {
        return this.batchAdd(map.get("base"), table, items, this.i18n(map), dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Map<String, Object> map) {
        return this.batchAdd(table, items, map, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang, boolean dupl) {
        return this.batchAdd(null, table, items, lang, dupl);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items, Object lang) {
        return this.batchAdd(null, table, items, lang, false);
    }

    public Map<String, String> batchAdd(String table, List<Map<String, Object>> items) {
        return this.batchAdd(table, items, new HashMap<String, Object>());
    }

    public Map<String, String> batchAdd(Map<String, String> map) {
        List<Map<String, Object>> list = this.utils.json2List(map.get("items"));
        boolean dupl = map.containsKey(DUPL);
        return this.batchAdd(this.getBase(map), this.getTable(map), list, this.i18n(map), dupl);
    }

    Map<String, String> delete(Object base, String table, Map<String, String> dto, Map<String, Object> where, Object joint) {
        Map<String, Object> cond = this.setCondition(dto, where, joint);
        if (cond.isEmpty()) {
            throw new FailedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        this.setDataIsolation(cond, base, table);
        return this.utils.result(this.dao.delete(map, cond) > 0);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> where, Object joint) {
        return this.delete(base, table, this.getDto(table), where, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> where, Object joint) {
        return this.delete(null, table, where, joint);
    }

    public Map<String, String> delete(String table, Map<String, Object> where) {
        return this.delete(null, table, where, null);
    }

    public Map<String, String> delete(Object base, String table, Map<String, Object> where) {
        return this.delete(base, table, where, null);
    }

    public Map<String, String> delete(Map<String, String> params) {
        Map<String, Object> where = this.utils.json2Map(params.get(WHERE));
        return this.delete(this.getBase(params), this.getTable(params), where);
    }

    Map<String, String> batchDelete(Object base, String table, Map<String, String> dto, List<Map<String, Object>> list, String joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> cond = this.setCondition(dto, list.get(i), joint);
            if (cond.isEmpty()) continue;
            this.setDataIsolation(cond, base, table);
            count += this.dao.delete(map, cond);
        }
        return this.utils.result(count > 0);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list) {
        return this.batchDelete(base, table, this.getDto(table), list, null);
    }

    public Map<String, String> batchDelete(Object base, String table, Object where) {
        String whr = String.valueOf(where);
        return this.batchDelete(base, table, this.utils.json2List(whr));
    }

    public Map<String, String> batchDelete(String table, List<Map<String, Object>> list) {
        return this.batchDelete(null, table, list);
    }

    public Map<String, String> batchDelete(Object base, String table, List<Map<String, Object>> list, String joint) {
        return this.batchDelete(base, table, this.getDto(table), list, joint);
    }

    public Map<String, String> batchDelete(String table, Object where) {
        return this.batchDelete(null, table, where);
    }

    public Map<String, String> batchDelete(Map<String, Object> params) {
        if (params == null) {
            return this.utils.result(false);
        }
        String table = String.valueOf(params.get("table"));
        return this.batchDelete(params.get("base"), table, params.get(WHERE));
    }

    private Map<String, String> update(Object base, String table, Map<String, String> dto, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        Map<String, Object> cond = this.setCondition(dto, where, joint);
        Map<String, Object> values = this.setCondition(dto, fields, null);
        if (cond.isEmpty() || values.isEmpty()) {
            throw new FailedException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        this.setDataIsolation(cond, base, table);
        return this.utils.result(this.dao.update(map, values, cond) > 0);
    }

    public Map<String, String> update(Object base, String table, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        return this.update(base, table, this.getDto(table), fields, where, joint);
    }

    public Map<String, String> update(Object base, String table, Map<String, Object> fields, Map<String, Object> where) {
        return this.update(base, table, fields, where, null);
    }

    public Map<String, String> update(String table, Map<String, Object> fields, Map<String, Object> where, Object joint) {
        return this.update(null, table, fields, where, joint);
    }

    public Map<String, String> update(String table, Map<String, Object> fields, Map<String, Object> where) {
        return this.update(null, table, fields, where, null);
    }

    public Map<String, String> update(Map<String, String> map, Object lang) {
        Map<String, Object> fields = this.utils.json2Map(map.get("fields"));
        Map<String, Object> where = this.utils.json2Map(map.get(WHERE));
        fields.put("i18n", lang);
        where.put("i18n", lang);
        return this.update(this.getBase(map), this.getTable(map), fields, where);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order, String limit) {
        return this.findList(base, tables, uriKey, where, order, LEFT, limit);
    }

    public List<Map<String, String>> findList(Object base, Map<String, Map<String, String>> tables, String uriKey, Map<String, Object> where, Map<String, String> order, String left, String limit) {
        Map<String, String> dto = this.getMetaDto(base, uriKey);
        String[] table = this.joinTables(base, dto, tables, left);
        if (table == null) {
            return new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", table[1]);
        args.put("alias", uriKey);
        args.put("limit", limit);
        Map<String, Object> cond = this.setArgsAndCond(args, dto, where, order);
        this.setDataIsolation(cond, base, table[0]);
        return this.dao.findList(args, cond);
    }

    String[] joinTables(Object base, Map<String, String> dto, Map<String, Map<String, String>> tables, String left) {
        String[] stringArray;
        if (tables == null) {
            return null;
        }
        String table = null;
        String T0 = null;
        String T = null;
        StringJoiner jt = new StringJoiner(" ", " ", "");
        for (String key : tables.keySet()) {
            Map<String, String> cond = tables.get(key);
            table = this.getTable(base, key);
            if (this.utils.isEmpty(cond)) {
                T0 = table;
                T = key;
                continue;
            }
            if (!this.utils.isEmpty(left)) {
                jt.add(left);
            }
            jt.add("join").add(table).add("on");
            if (ConfUtil.dataIsolation()) {
                jt.add(this.tenantKey(key) + "=" + this.utils.sqlVal(base));
            }
            int n = 0;
            for (Map.Entry<String, String> e : cond.entrySet()) {
                String val = e.getValue();
                if (val == null) continue;
                if (n++ > 0 || ConfUtil.dataIsolation()) {
                    jt.add("and");
                }
                val = dto.containsKey(val) ? this.i18n(dto, val, null) : (this.utils.isMatch(val, _W) ? this.utils.sqlVal(val) : "''");
                jt.add(this.i18n(dto, e.getKey(), null) + "=" + val);
            }
        }
        if (T == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = T;
            stringArray = stringArray2;
            stringArray2[1] = T0 + jt.toString();
        }
        return stringArray;
    }

    private void setLimitRows(Map<String, String> args, Map<String, Object> where) {
        String limit;
        if (where != null) {
            String pageNo = String.valueOf(where.get("pageNo"));
            String pageSize = String.valueOf(where.get("pageSize"));
            if (this.utils.isInteger(pageNo) && this.utils.isInteger(pageSize)) {
                long pNo = Long.parseLong(pageNo);
                long pSize = Long.parseLong(pageSize);
                args.put("floor", String.valueOf((pNo - 1L) * pSize));
                args.put("limit", String.valueOf(pSize));
                return;
            }
        }
        if (!this.utils.isInteger(limit = args.get("limit"))) {
            args.put("limit", ConfUtil.limitRows());
        } else if ("0".equals(limit)) {
            args.remove("limit");
        }
    }

    Map<String, Object> setArgsAndCond(Map<String, String> args, Map<String, String> dto, Map<String, Object> where, Map<String, String> order) {
        Object lang = this.i18n(where);
        args.put("alias", this.setAlias(dto, args.get("alias"), lang));
        args.put(ORDER, this.getOrder(dto, order, lang));
        this.setLimitRows(args, where);
        return this.setCondition(dto, where, args.get("joint"));
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> where, Map<String, String> order) {
        String table = this.getTable(args);
        Map<String, String> dto = this.getDto(table);
        Object base = this.getBase(args);
        args.put("table", this.getTable(base, table));
        Map<String, Object> cond = this.setArgsAndCond(args, dto, where, order);
        this.setDataIsolation(cond, base, table);
        return this.dao.findList(args, cond);
    }

    public List<Map<String, String>> findList(Map<String, String> args, Map<String, Object> where) {
        return this.findList(args, where, null);
    }

    public List<Map<String, String>> findList(Object base, String table, String uriKey, Map<String, Object> where, Map<String, String> order) {
        String db = base == null ? null : String.valueOf(base);
        String[] args = new String[]{db, table, uriKey};
        return this.findAll(where, order, args);
    }

    public List<Map<String, String>> findList(Object base, String table, String uriKey, Map<String, Object> where) {
        return this.findList(base, table, uriKey, where, null);
    }

    public List<Map<String, String>> findList(String table, String uriKey, Map<String, Object> where) {
        return this.findList(null, table, uriKey, where, null);
    }

    public List<Map<String, String>> findList(String table, Map<String, Object> where) {
        return this.findList(table, null, where);
    }

    Map<String, String> convertArgs(String[] params) {
        if (params == null || params.length < 2) {
            return null;
        }
        String[] keys = new String[]{"base", "table", "alias", "limit"};
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < params.length && i < keys.length; ++i) {
            args.put(keys[i], params[i]);
        }
        return args;
    }

    public List<Map<String, String>> findAll(Map<String, Object> where, Map<String, String> order, String[] params) {
        Map<String, String> args = this.convertArgs(params);
        return args == null ? new ArrayList<Map<String, String>>() : this.findList(args, where, order);
    }

    private Map<String, String> findOne(Object base, String table, Map<String, String> dto, Map<String, Object> where, String uriKey) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("alias", this.setAlias(dto, uriKey, this.i18n(where)));
        Map<String, Object> cond = this.setCondition(dto, where, null);
        this.setDataIsolation(cond, base, table);
        map = this.dao.findOne(map, cond);
        return this.utils.isEmpty(map) ? this.utils.result(false) : map;
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> where, String uriKey) {
        return this.findOne(base, table, this.getDto(table), where, uriKey);
    }

    public Map<String, String> findOne(Object base, String table, Map<String, Object> where) {
        return this.findOne(base, table, where, null);
    }

    public Map<String, String> findOne(String table, Map<String, Object> where, String uriKey) {
        return this.findOne(null, table, where, uriKey);
    }

    public Map<String, String> findOne(String table, Map<String, Object> where) {
        return this.findOne(null, table, where, null);
    }

    public Map<String, String> findOne(Map<String, String> map, String uriKey) {
        Map<String, Object> where = this.utils.json2Map(map.get(WHERE));
        return this.findOne(this.getBase(map), this.getTable(map), where, uriKey);
    }

    public Map<String, String> findOne(Map<String, String> map) {
        return this.findOne(map, null);
    }

    private boolean exists(Object base, String table, Map<String, String> dto, Map<String, Object> where, Object joint) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        Map<String, Object> cond = this.setCondition(dto, where, joint);
        this.setDataIsolation(cond, base, table);
        return this.dao.countRows(map, cond) > 0;
    }

    public boolean exists(Object base, String table, Map<String, Object> where, Object joint) {
        return this.exists(base, table, this.getDto(table), where, joint);
    }

    public boolean exists(Object base, String table, Map<String, Object> where) {
        return this.exists(base, table, where, null);
    }

    public boolean exists(String table, Map<String, Object> where, Object joint) {
        return this.exists(null, table, where, joint);
    }

    public boolean exists(String table, Map<String, Object> where) {
        return this.exists(null, table, where, null);
    }

    public boolean exists(Map<String, String> map) {
        Map<String, Object> where = this.utils.json2Map(map.get(WHERE));
        return this.exists(this.getBase(map), this.getTable(map), where);
    }

    public int count(String table, Map<String, Object> where) {
        return this.count(null, table, where, null);
    }

    public int count(Object base, String table, Map<String, Object> where) {
        return this.count(base, table, where, null);
    }

    public int count(Object base, String table, Map<String, Object> where, String joint) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("table", this.getTable(base, table));
        Map<String, Object> cond = this.setCondition(this.getDto(table), where, joint);
        this.setDataIsolation(cond, base, table);
        return this.dao.countRows(args, cond);
    }

    private Map<String, String> cacheActionRole(Map<String, Object> map) {
        map.put("alias", this.setAlias("ACTION", null));
        List<Map<String, String>> list = this.dao.getActionRole(map);
        Map<String, String> actMap = this.utils.list2Map(list, "actUri", "actState");
        if (!actMap.isEmpty()) {
            Object[] keys = new Object[]{map.get("appCode"), map.get("compId"), map.get("dutyId")};
            String key = this.utils.join(keys, ".");
            this.redis.setActionRole(key, actMap);
            LOG.debug("cacheActionRole...{}", actMap);
        }
        return actMap;
    }

    public List<Map<String, String>> getMenuRole(Map<String, Object> params) {
        if (this.utils.isEmpty(params)) {
            return new ArrayList<Map<String, String>>();
        }
        this.cacheActionRole(params);
        params.put("alias", this.getAlias("getMenuRole", this.i18n(params)));
        List<Map<String, String>> list = this.dao.getMenuRole(params);
        this.mergeMenuRole(list);
        return list;
    }

    public Map<String, Object> getRoleParams(Map<String, Object> params, Map<String, String> user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object appCode = params.get("appCode");
        if (appCode != null) {
            map.put("compId", user.get("userComp"));
            map.put("i18n", this.i18n(params));
            Map uDuty = this.utils.json2Map(user.get("userDuty"));
            if (uDuty.containsKey(appCode)) {
                map.put("dutyId", uDuty.get(appCode));
                map.put("appCode", appCode);
            }
        }
        return map;
    }

    private Map<String, String> mergeMenuRole(List<Map<String, String>> list) {
        String[] keys = new String[]{"pageId", "pageRoute", "roleAction"};
        if (list.size() == 1) {
            return this.utils.list2Map(list, keys[1], keys[2]);
        }
        HashMap<String, String> menu = new HashMap<String, String>();
        for (int i = list.size() - 1; i > 0; --i) {
            Map<String, String> tmp0 = list.get(i);
            Map<String, String> tmp1 = list.get(i - 1);
            String page0 = tmp0.get(keys[0]);
            String page1 = tmp1.get(keys[0]);
            int ra = Integer.valueOf(tmp0.get(keys[2]));
            if (page1.equals(page0)) {
                ra = Integer.valueOf(tmp1.get(keys[2])) | ra;
                tmp1.put(keys[2], String.valueOf(ra));
                list.remove(i);
            } else {
                menu.put(tmp0.get(keys[1]), tmp0.get(keys[2]));
            }
            if (i != 1) continue;
            menu.put(tmp1.get(keys[1]), tmp1.get(keys[2]));
        }
        return menu;
    }

    public String getParam(Object base, String paramKey) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        Map<Object, Object> result = new HashMap();
        where.put("paramKey", paramKey);
        result = this.findOne(base, "PARAM", where, "getParamVal");
        return (String)result.get("paramVal");
    }

    public String getParam(Map<String, Object> params, String paramKey) {
        return this.getParam(this.getBase(params), paramKey);
    }

    private String i18n(Map<String, String> dto, String key, Object lang) {
        String field = dto.get(key);
        if (dto.containsKey(key + M_I18N) && !this.utils.isEmpty(lang)) {
            field = field + _S + lang;
        }
        return field;
    }

    private <T> Object i18n(Map<String, T> params) {
        return params == null ? null : params.get("i18n");
    }

    private String getOrder(Map<String, String> dto, Map<String, String> order, Object lang) {
        if (this.utils.isEmpty(order)) {
            return this.getMetaPks(dto, "");
        }
        StringJoiner jt = new StringJoiner(",");
        for (Map.Entry<String, String> e : order.entrySet()) {
            String key = e.getKey();
            if (!dto.containsKey(key)) continue;
            jt.add(this.i18n(dto, key, lang) + " " + e.getValue());
        }
        return jt.toString();
    }

    private <T> Map<String, T> setCondition(Map<String, String> dto, Map<String, T> where, Object joint) {
        LinkedHashMap<String, T> cond = new LinkedHashMap<String, T>();
        if (where == null) {
            return cond;
        }
        Object lang = this.i18n(where);
        for (Map.Entry<String, T> e : where.entrySet()) {
            T val = e.getValue();
            if (val == null) continue;
            String key = e.getKey();
            if (dto.containsKey(key)) {
                this.validationRules(dto, e);
                key = this.i18n(dto, key, lang);
                key = key + (joint == null ? "=" : " " + joint);
                cond.put(key, val);
                continue;
            }
            if (!P_QUOTE.matcher(key).find()) continue;
            boolean noneVar = P_PLACE.matcher(key).find();
            if ((key = this.getFieldKey(dto, key, val, lang)) == null) continue;
            cond.put(key, noneVar ? null : (Object)val);
        }
        LOG.debug("setCondition...{}", (Object)this.utils.obj2Str(cond));
        return cond;
    }

    public String getWhere(Map<String, String> dto, String expr, Object lang) {
        return this.getFieldKey(dto, expr, new String[0], lang);
    }

    private <T> String getFieldKey(Map<String, String> dto, String expr, T valArr, Object lang) {
        String[] vArr;
        Object[] arr = expr.split("\\{ *");
        int v = 0;
        boolean isArr = valArr.getClass().isArray();
        String[] stringArray = vArr = isArr ? (String[])valArr : new String[]{};
        if (arr.length > 1 && this.isValidExpr(arr[0])) {
            for (int i = 1; i < arr.length; ++i) {
                String[] key = arr[i].split(" *\\}");
                if (key.length == 0) {
                    if (vArr.length <= v) continue;
                    arr[i] = vArr[v++];
                    continue;
                }
                if (dto.containsKey(key[0])) {
                    arr[i] = this.i18n(dto, key[0], lang);
                    if (key.length <= 1 || !this.isValidExpr(key[1])) continue;
                    int n = i;
                    arr[n] = (String)arr[n] + key[1];
                    continue;
                }
                if (vArr.length <= v || !"".equals(key[0]) && !"V".equals(key[0])) continue;
                arr[i] = vArr[v++] + (key.length > 1 ? key[1] : "");
            }
            return this.utils.join(arr);
        }
        return null;
    }

    private boolean isValidExpr(String expr) {
        if (expr.length() > 0) {
            String[] arr;
            for (String str : arr = expr.split(" +")) {
                if (str.length() == 0 || this.utils.findIn(ConfUtil.SQL_EXPR, (Object)str.toLowerCase()) || P_JSON.matcher(str).find()) continue;
                LOG.error("invalid expr...{}", (Object)str);
                throw new FailedException();
            }
        }
        return true;
    }

    private Map<String, Object> setFieldData(Map<String, String> dto, Map<String, Object> params, boolean isValue) {
        if (params != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            Object lang = this.i18n(params);
            for (Map.Entry<String, Object> e : params.entrySet()) {
                if (!dto.containsKey(e.getKey())) continue;
                String key = this.i18n(dto, e.getKey(), lang);
                if (isValue && this.validationRules(dto, e)) {
                    data.put(key, e.getValue());
                    continue;
                }
                data.put(key, e.getKey());
            }
            if (!data.isEmpty()) {
                return data;
            }
        }
        throw new FailedException();
    }

    private boolean validationRules(Map<String, String> dto, Map.Entry<String, ?> e) {
        if (ConfUtil.avoidRules()) {
            return true;
        }
        String type = dto.get(e.getKey() + M_TYPE);
        if (type == null) {
            return false;
        }
        String str = String.valueOf(e.getValue());
        Matcher matcher = P_DIGIT.matcher(type);
        if (matcher.find()) {
            if (Integer.parseInt(matcher.group()) >= str.length()) {
                return true;
            }
        } else if (type.contains("IN")) {
            if (this.utils.isInteger(str)) {
                return true;
            }
        } else {
            if (type.contains("J")) {
                return true;
            }
            if (type.contains("T")) {
                if (this.utils.isDatetime(str, "yyyy-MM-dd HH:mm:ss")) {
                    return true;
                }
            } else if (type.contains("L")) {
                if (this.utils.isNumeric(str)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String key = String.join((CharSequence)_S, "invalidParams", e.getKey());
        throw new FailedException(key);
    }

    public String setAlias(String table, Object lang) {
        return this.setAlias(table, null, lang);
    }

    public String setAlias(String table, String uriKey, Object lang) {
        return this.setAlias(this.getDto(table), uriKey, lang);
    }

    private String setAlias(Map<String, String> dto, String uriKey, Object lang) {
        if (ConfUtil.isCustomCols() || this.utils.isEmpty(uriKey)) {
            return this.fieldAsAlias(dto, lang);
        }
        String val = ConfUtil.getParam(uriKey);
        if (val.length() == 0) {
            return this.fieldAsAlias(dto, lang);
        }
        return this.fieldAsAlias(dto, val.split(",|;"), lang);
    }

    private String fieldAsAlias(Map<String, String> dto, String[] arr, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (String key : arr) {
            jt.add(this.fieldAsAlias(dto, key, lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, Object lang) {
        StringJoiner jt = new StringJoiner(",");
        for (String key : dto.keySet()) {
            if (key.contains("!")) continue;
            jt.add(this.fieldAsAlias(dto, key, lang));
        }
        return jt.toString();
    }

    private String fieldAsAlias(Map<String, String> dto, String key, Object lang) {
        String val = dto.get(key);
        String type = dto.get(key + M_TYPE);
        String keyStr = "\"" + key + "\"";
        if (type != null) {
            if (type.matches("[IJSBD].+") || type.contains("IN")) {
                val = this.isPostgres() ? CAST + val + " as TEXT)" : CAST + val + " as CHAR)";
            } else if (type.matches("T.+")) {
                val = this.isPostgres() ? "to_char(" + val + ",'yyyy-MM-dd hh24:mi:ss" + (type.length() > 9 ? ".ms" : "") + R_PAREN : "DATE_FORMAT(" + val + ",'%Y-%m-%d %T" + (type.length() > 9 ? ".%f" : "") + R_PAREN;
            } else if (dto.containsKey(key + M_I18N) && !this.utils.isEmpty(lang)) {
                val = val + _S + lang;
            }
        } else if (val == null) {
            val = keyStr;
        }
        return String.join((CharSequence)" ", val, "as", keyStr);
    }

    public String getAlias(String uriKey, Object lang) {
        return this.getAlias(null, uriKey, lang);
    }

    private String getAlias(Object base, String uriKey, Object lang) {
        return this.fieldAsAlias(this.getMetaDto(base, uriKey), lang);
    }

    public String getField(String table, Object lang) {
        return this.fieldAsAlias(this.getDto(table), lang);
    }

    private Map<String, String> getFields(String table, String[] arr, Object lang) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (arr != null) {
            Map<String, String> dto = this.getDto(table);
            for (String key : arr) {
                if (!dto.containsKey(key)) continue;
                map.put(key, this.i18n(dto, key, lang));
            }
        }
        return map;
    }

    Map<String, String> getDto(String table) {
        String rk = "m." + table;
        Map<String, String> dto = this.redis.hmget(rk);
        if (dto == null) {
            dto = this.getDto(this.getTableMeta(table));
            this.redis.hmset(rk, dto, 36000);
        }
        return dto;
    }

    Map<String, String> getMetaDto(Object base, String uriKey) {
        boolean isCustom = ConfUtil.isCustomCols();
        String rk = "m." + (isCustom ? base : "") + uriKey;
        Map<String, String> dto = this.redis.hmget(rk);
        if (dto == null) {
            dto = isCustom ? this.getDto(this.getMeta(this.getFieldList(base, uriKey))) : this.getDto(this.getMeta(uriKey));
            this.redis.hmset(rk, dto, 36000);
        }
        return dto;
    }

    public List<Map<String, String>> getFieldList(Object base, String uriKey) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("fieldUri", uriKey);
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("fieldSort", "ASC");
        return this.findList(base, "FIELD", null, where, order);
    }

    private Map<String, String> getDto(List<Map<String, String>> metaList) {
        HashMap<String, String> dto = new HashMap<String, String>();
        for (int i = 0; i < metaList.size(); ++i) {
            Map<String, String> meta = metaList.get(i);
            String alias = meta.get("alias");
            dto.put(alias, meta.get("field"));
            dto.put(alias + M_TYPE, meta.get(TYPE));
            dto.put(alias + M_PKEY, meta.get(PKEY));
            if (!"1".equals(meta.get("i18n"))) continue;
            dto.put(alias + M_I18N, meta.get("i18n"));
        }
        if (dto.isEmpty()) {
            throw new FailedException();
        }
        return dto;
    }

    public List<Map<String, String>> getMeta(String uriKey) {
        String val = ConfUtil.getParam(uriKey);
        String[] keys = val.length() == 0 ? null : val.split(",|;");
        return this.getMeta(keys);
    }

    private List<Map<String, String>> getMeta(List<Map<String, String>> fieldList) {
        String[] keys = new String[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            keys[i] = fieldList.get(i).get("fieldAlias");
        }
        return this.getMeta(keys);
    }

    private List<Map<String, String>> getMeta(String[] keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(null, META));
        map.put("alias", this.fieldAsAlias(gmeta, null));
        return this.dao.getMeta(map, keys);
    }

    public List<Map<String, String>> getMetaList(String table) {
        return this.getTableMeta(table);
    }

    public List<Map<String, String>> getTableMeta(Object table) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(null, META));
        map.put("alias", this.fieldAsAlias(gmeta, null));
        map.put(ORDER, META_SORT);
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("META_TABLE=", table);
        return this.dao.findList(map, cond);
    }

    public String getTable(Object base, String table) {
        if (this.isPostgres()) {
            if (base != null && !ConfUtil.dataIsolation()) {
                table = base + table;
                String db = String.valueOf(base);
                if (db.charAt(db.length() - 1) == '.') {
                    return table;
                }
            }
            CharSequence[] keys = new String[]{ConfUtil.baseMain(), table};
            return String.join((CharSequence)".", keys);
        }
        if (ConfUtil.dataIsolation()) {
            return table;
        }
        return base == null ? table : base + table;
    }

    private String getTable(Map<String, String> params) {
        return params.get("table");
    }

    private <T> Object getBase(Map<String, T> params) {
        return params.get("base");
    }

    public int getMaxCode(Object base, String table, String field) {
        return this.getMaxCode(base, table, field, null);
    }

    public int getMaxCode(Object base, String table, String field, Map<String, Object> where) {
        Map<String, String> dto = this.getDto(table);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", this.getTable(base, table));
        map.put("field", dto.get(field));
        Map<String, Object> cond = this.setCondition(dto, where, null);
        this.setDataIsolation(cond, base, table);
        return this.dao.getMaxCode(map, cond);
    }

    public List<Map<String, String>> groupCount(Object base, String table, String[] keys, Map<String, Object> where) {
        Map<String, String> dto = this.getDto(table);
        Map<String, String> map = this.getFields(table, keys, null);
        Map<String, Object> cond = this.setCondition(dto, where, null);
        this.setDataIsolation(cond, base, table);
        return this.dao.groupCount(this.getTable(base, table), map, cond);
    }

    static {
        gmeta.put("field", "META_FIELD");
        gmeta.put("alias", "META_ALIAS");
        gmeta.put("name", "META_NAME");
        gmeta.put(TYPE, "META_TYPE");
        gmeta.put(NULL, "META_NULL");
        gmeta.put("i18n", "META_I18N");
        gmeta.put(PKEY, "META_PKEY");
        gmeta.put("width", "META_WIDTH");
        gmeta.put(DEFT, "META_DEFAULT");
        gmeta.put("sort", META_SORT);
    }
}

