/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdService {
    private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private RedisService redis;
    @Autowired
    private UtilsService utils;

    public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> cookies) {
        if (!cookies.containsKey("bindId") || cookies.containsKey("userId")) {
            // empty if block
        }
        return false;
    }

    private boolean verifyAppKey(String K) {
        return ConfUtil.APP_KEY.equals(K) || ConfUtil.ENC_KEY.equals(K);
    }

    public boolean verifySecret(HttpServletRequest req) {
        String jsonStr = req.getParameter("jsonstr");
        String K = req.getParameter("k");
        if (this.verifyAppKey(K)) {
            if (jsonStr == null) {
                return true;
            }
            return this.setReqAttr(req, this.utils.json2Map(jsonStr));
        }
        String ticket = req.getParameter("ticket");
        if (ticket != null) {
            return this.verifyApiKey(req, jsonStr, ticket);
        }
        if (K == null) {
            return false;
        }
        String priKey = this.redis.getCertKey(K);
        if (priKey != null && jsonStr != null && (jsonStr = Digest.sm2Decrypt(jsonStr, priKey)) != null) {
            return this.setReqAttr(req, this.utils.json2Map(jsonStr));
        }
        LOG.warn("Auth failed > {} : {}", (Object)K, (Object)ConfUtil.APP_KEY);
        return false;
    }

    private boolean verifyApiKey(HttpServletRequest req, String jsonStr, String ticket) {
        Map<String, Object> params;
        if (!ConfUtil.IS_API_OPEN || jsonStr == null) {
            return false;
        }
        String spec = this.redis.get("a." + ticket);
        if (spec == null) {
            Object res = ConfUtil.invoke(null, "appCert", ticket);
            Map cert = this.utils.obj2Map(res);
            spec = (String)cert.get("certKey");
            if (spec == null) {
                return false;
            }
            int sec = this.getSecond(req.getParameter("sec"));
            this.redis.set("a." + ticket, spec, sec);
        }
        if ((params = this.utils.json2Map(jsonStr = Digest.sm4Decrypt(jsonStr, spec))).isEmpty()) {
            return false;
        }
        return this.setReqAttr(req, params);
    }

    private boolean setReqAttr(HttpServletRequest req, Map<String, Object> params) {
        Object dbid;
        if (params.isEmpty()) {
            Enumeration map = req.getParameterNames();
            while (map.hasMoreElements()) {
                String key = (String)map.nextElement();
                params.put(key, req.getParameter(key));
            }
        } else if (params.containsKey("base")) {
            params.remove("base");
        }
        if ((dbid = params.get(ConfUtil.BASE_DBID)) != null && Pattern.matches("\\w+", String.valueOf(dbid))) {
            String base = ConfUtil.BASE_NAME + dbid;
            params.put("base", base + ConfUtil.BASE_DOT);
        }
        if (!this.utils.findIn(ConfUtil.I18N_LOCALES, params.get("i18n"))) {
            params.put("i18n", this.getUserLang(req));
        }
        req.setAttribute("json", params);
        LOG.debug("setReqAttr...{}", params);
        return true;
    }

    private String getUserLang(HttpServletRequest req) {
        String lang = this.utils.userSelf(req).get("userLang");
        if (this.utils.isEmpty(lang)) {
            lang = this.utils.getLocale(req).toUpperCase();
        }
        return lang;
    }

    public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp, Map<String, String> token) throws Exception {
        Map userBase;
        String dbid;
        String userId = token.get("userId");
        Map<String, String> user = this.redis.getUserInfo(userId);
        if (user == null) {
            this.redis.clearToken(token);
            return this.invlidToken(rsp);
        }
        String spec = token.get("certId");
        Map<String, Object> params = this.decryptParams(req, user, spec);
        if (params == null) {
            return this.invlidToken(rsp);
        }
        Object appCode = params.get("appCode");
        String svrApp = ConfUtil.APP_CODE;
        String uri = this.utils.getRequestURI(req);
        if (this.utils.isEmpty(appCode)) {
            if (svrApp.length() > 0) {
                params.put("appCode", svrApp);
                String role = this.trustedRole(params, user, uri);
                LOG.debug("trustedRole...{}", (Object)role);
                if (this.utils.isEmpty(role)) {
                    return this.denyAccess(rsp);
                }
            }
        } else if (!this.havePermit(svrApp, String.valueOf(appCode), uri)) {
            return this.denyAccess(rsp);
        }
        LOG.debug("request from {}.{}", (Object)uri, params);
        if (!this.checkParams(params, uri.substring(1))) {
            return this.invlidParams(rsp);
        }
        String dbKey = ConfUtil.BASE_DBID;
        if (svrApp.length() > 0 && params.containsKey(dbKey) && !this.utils.isEmpty(dbid = (String)(userBase = this.utils.json2Map(user.get("userBase"))).get(svrApp)) && !"0".equals(dbid) && !dbid.equals(params.get(dbKey))) {
            return this.invlidParams(rsp);
        }
        return this.setReqAttr(req, params);
    }

    private Map<String, Object> decryptParams(HttpServletRequest req, Map<String, String> user, String spec) {
        req.setAttribute("user", user);
        req.setAttribute("userId", (Object)user.get("userId"));
        req.setAttribute("certId", (Object)spec);
        return this.decryptParams(req.getParameter("jsonstr"), spec);
    }

    private Map<String, Object> decryptParams(String jsonStr, String spec) {
        if (!ConfUtil.IS_ENC_OMIT && !this.utils.isEmpty(jsonStr)) {
            LOG.debug("decryptParams...{}", (Object)jsonStr);
            jsonStr = Digest.sm4Decrypt(jsonStr, spec);
            if (jsonStr == null) {
                return null;
            }
        }
        return this.utils.json2Map(jsonStr);
    }

    private boolean checkParams(Map<?, ?> params, String uri) {
        String keys = ConfUtil.VALID_MUST + ConfUtil.getValid(uri);
        String[] keyArr = keys.split(",|;");
        return keys.length() == 0 || this.utils.availParams(params, keyArr);
    }

    private boolean havePermit(String srvApp, String appCode, String uri) {
        if (srvApp.length() == 0) {
            return true;
        }
        Object[] rks = new String[]{"a.", srvApp, ".", appCode};
        String rk = this.utils.arr2Str(rks);
        Map<String, String> permit = this.redis.hmget(rk);
        if (permit == null) {
            permit = this.getActionPermit(srvApp, appCode);
            LOG.debug("permit...{}", permit);
            if (permit.isEmpty()) {
                return false;
            }
            this.redis.hmset(rk, permit, 7200);
        }
        LOG.debug("havePermit={}", permit);
        return permit.containsKey(uri);
    }

    private Map<String, String> getActionPermit(String srvApp, String appCode) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("actApp", srvApp);
        where.put("actMark", "0");
        where.put("actState", "1");
        if (ConfUtil.API_PERMIT) {
            String[] V = new String[]{"'1'", "'1'"};
            Object[] arr = new String[]{"({", "actPermit", "} is NULL OR ", this.utils.jsonExt("actPermit", appCode), "{} OR ", this.utils.jsonExt("actPermit", "all"), "{})"};
            where.put(this.utils.arr2Str(arr), V);
        }
        LOG.debug("getActionList...{}", where);
        List<Map<String, String>> list = this.aolai.findList("ACTION", where);
        return this.utils.list2Map(list, "actUri", "actState");
    }

    private String trustedRole(Map<String, Object> params, Map<String, String> user, String uri) {
        Map<String, Object> duty = this.aolai.getRoleParams(params, user);
        Object[] keys = new Object[]{params.get("appCode"), duty.get("compId"), duty.get("dutyId")};
        return this.redis.getActionRole(this.utils.join(keys, "."), uri);
    }

    private boolean invlidParams(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "2");
    }

    public boolean invlidToken(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "3");
    }

    private boolean denyAccess(HttpServletResponse rsp) throws Exception {
        return this.invalidResult(rsp, "5");
    }

    private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
        rsp.setContentType("application/json;charset=UTF-8");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter out = rsp.getWriter();
        out.write(this.utils.obj2Str(this.utils.result(status)));
        out.flush();
        out.close();
        return false;
    }

    private int getSecond(String sec) {
        return this.utils.isInteger(sec) ? Integer.parseInt(sec) : ConfUtil.CACHE_TIME;
    }
}

