package cn.ps1.aolai.utils;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;


//import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * 系统配置密码的解码
 * 
 * @author Aolai
 * @since 1.8 $Date: 2021.11.17
 *
 */
public class EncConfigurer extends PropertySourcesPlaceholderConfigurer {

	// 注入需要解密的keys
	private Set<String> decodeKeys;

	/**
	 * 覆盖父类方法，重新加载参数
	 * 
	 * @param props
	 * @throws IOException
	 */
	@Override
	protected void loadProperties(Properties props) throws IOException {

		super.loadProperties(props);

		if (decodeKeys == null || decodeKeys.size() == 0) {
			return;
		}

		for (String key : props.stringPropertyNames()) {
			if (decodeKeys.contains(key)) {
				// getDecryptString 是解密的方法，根据需要自己编写。
				String val = decryptString(props.getProperty(key));
				props.setProperty(key, val);
			}
		}
	}

	public Set<String> getDecodeKeys() {
		return decodeKeys;
	}

	public void setDecodeKeys(Set<String> decodeKeys) {
		this.decodeKeys = decodeKeys;
	}

	/**
	 * 解密逻辑
	 * 
	 * @param src 密文
	 * @return String 返回解码后字符串
	 */
	private String decryptString(String src) {
		return Digest.decrypt(src, Digest.seed());
	}

}
