/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.aolai.utils;

import cn.ps1.aolai.utils.Digest;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfUtil {
    private static Logger LOG = LoggerFactory.getLogger(ConfUtil.class);
    private static ResourceBundle CONF = ResourceBundle.getBundle("config");
    private static ResourceBundle PARAM = ResourceBundle.getBundle("params");
    private static ResourceBundle VALID = ResourceBundle.getBundle("valid");
    public static final String PUB_KEY = "pubk";
    public static final String PRI_KEY = "prik";
    public static final String JSONSTR = "jsonstr";
    public static final String IPADDR = "ipaddr";
    public static final String TOKEN = "token";
    public static final String CERT_K = "k";
    public static final String COMMA = ",|;";
    public static final String USERID = "userId";
    public static final String USERCOMP = "userComp";
    public static final String CERTID = "certId";
    public static final String TRACEID = "traceId";
    public static String APP_KEY = "";
    public static String ENC_KEY = "";
    public static String APP_CODE = "";
    public static String APP_CORE = "";
    public static String APP_MAIN = "";
    public static String BASE_DBID = "";
    public static String BASE_DOT = "";
    public static String BASE_NAME = "";
    public static String BASE_MAIN = "";
    public static String[] I18N_LOCALES = new String[0];
    public static String SSO_URL = "";
    public static String VALID_MUST = "";
    public static String LIMIT_ROWS = "";
    public static int HTTP_TIMEOUT = 120000;
    public static int CACHE_TIME = 7200;
    public static String[] SQL_EXPR = new String[]{"=", ">", "<", ">=", "<=", "<>", "!=", "regexp", "rlike", "is", "not", "null", "and", "or", "like", "in", "(", ")", "between", "length("};
    public static boolean API_PERMIT = false;
    public static boolean IS_TRACKING = false;
    public static boolean IS_API_OPEN = false;
    public static boolean IS_ENC_RESP = false;
    public static boolean IS_LOG_RESP = false;
    public static boolean IS_ENC_OMIT = false;
    public static boolean IS_MULTI_LOGIN = false;
    public static boolean IS_CUSTOM_COLS = false;
    public static String REGEXP = " ";
    public static String RLIKE = " ";

    public static String getConf(String key, String def) {
        return ConfUtil.getProp(CONF, key, def);
    }

    public static String getConf(String key) {
        return ConfUtil.getProp(CONF, key, "");
    }

    public static String getParam(String key) {
        return ConfUtil.getProp(PARAM, key, "");
    }

    public static String getValid(String key) {
        return ConfUtil.getProp(VALID, key, "");
    }

    private static String getProp(ResourceBundle rb, String key, String def) {
        try {
            return rb.getString(key);
        }
        catch (Exception e) {
            LOG.debug("getProp..." + e.getMessage());
            return def;
        }
    }

    static {
        APP_KEY = ConfUtil.getConf("app.key", "www.ps1.cn");
        ENC_KEY = Digest.md5(APP_KEY);
        APP_CODE = ConfUtil.getConf("app.code");
        APP_CORE = ConfUtil.getConf("app.core");
        APP_MAIN = ConfUtil.getConf("app.main");
        BASE_DBID = ConfUtil.getConf("base.dbid", "baseId");
        BASE_DOT = ConfUtil.getConf("base.dot", ".");
        BASE_NAME = ConfUtil.getConf("base.name");
        BASE_MAIN = ConfUtil.getConf("base.main", "public");
        I18N_LOCALES = ConfUtil.getConf("i18n.locales", "ZH,EN").split(COMMA);
        SSO_URL = ConfUtil.getConf("sso.url");
        VALID_MUST = ConfUtil.getConf("valid.must");
        LIMIT_ROWS = ConfUtil.getConf("limit.rows");
        HTTP_TIMEOUT = Integer.parseInt(ConfUtil.getConf("http.timeout", "120000"));
        String conf = ConfUtil.getConf("cache.time");
        if (conf.length() > 0) {
            CACHE_TIME = Integer.parseInt(conf);
        }
        API_PERMIT = ConfUtil.getConf("api.permit").length() > 0;
        IS_TRACKING = ConfUtil.getConf("app.trace").length() > 0;
        IS_API_OPEN = ConfUtil.getConf("api.open").length() > 0;
        IS_ENC_RESP = ConfUtil.getConf("enc.resp").length() > 0;
        IS_LOG_RESP = ConfUtil.getConf("log.resp").length() > 0;
        IS_ENC_OMIT = ConfUtil.getConf("enc.omit").length() > 0;
        IS_MULTI_LOGIN = ConfUtil.getConf("multi.login").length() > 0;
        IS_CUSTOM_COLS = ConfUtil.getConf("cols.custom").length() > 0;
        REGEXP = REGEXP + ConfUtil.getConf("sql.regexp", "regexp");
        RLIKE = RLIKE + ConfUtil.getConf("sql.rlike", "rlike");
        conf = ConfUtil.getConf("sql.expr");
        if (conf.length() > 0) {
            SQL_EXPR = conf.split(COMMA);
        }
    }
}

